/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import phex.download.swarming.SwarmingManager;
import phex.event.DownloadFilesChangeListener;
import phex.event.NetworkHostsChangeListener;
import phex.event.UploadFilesChangeListener;
import phex.gui.common.GUIRegistry;
import phex.gui.common.IconFactory;
import phex.host.HostManager;
import phex.host.NetworkHostsContainer;
import phex.statistic.CompletedUploadCountStatistic;
import phex.upload.UploadManager;
import phex.utils.Localizer;

public class StatusBar
extends JPanel {
    private NetworkHostsContainer hostsContainer;
    private SwarmingManager swarmingMgr;
    private UploadManager uploadMgr;
    private JLabel connectionLabel;
    private JLabel downloadLabel;
    private JLabel uploadLabel;
    private Icon connectedIcon;
    private Icon disconnectedIcon;

    public StatusBar() {
        super(new GridBagLayout());
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.connectionLabel = new JLabel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.connectionLabel, gridBagConstraints);
        this.downloadLabel = new JLabel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.downloadLabel, gridBagConstraints);
        this.uploadLabel = new JLabel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.uploadLabel, gridBagConstraints);
        IconFactory iconFactory = GUIRegistry.getInstance().getIconFactory();
        this.connectedIcon = iconFactory.getIcon("Network");
        this.disconnectedIcon = iconFactory.getIcon("Disconnect");
        HostManager hostManager = HostManager.getInstance();
        this.hostsContainer = hostManager.getNetworkHostsContainer();
        this.swarmingMgr = SwarmingManager.getInstance();
        this.uploadMgr = UploadManager.getInstance();
        this.updateStatusBar();
        StatusChangedListener statusChangedListener = new StatusChangedListener();
        this.hostsContainer.addNetworkHostsChangeListener(statusChangedListener);
        this.uploadMgr.addUploadFilesChangeListener(statusChangedListener);
        this.swarmingMgr.addDownloadFilesChangeListener(statusChangedListener);
    }

    private void updateStatusBar() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int n = StatusBar.this.hostsContainer.getTotalConnectionCount();
                if (n > 0) {
                    StatusBar.this.connectionLabel.setIcon(StatusBar.this.connectedIcon);
                } else {
                    StatusBar.this.connectionLabel.setIcon(StatusBar.this.disconnectedIcon);
                }
                Object[] objectArray = new Object[]{new Integer(n)};
                String string = Localizer.getFormatedString("StatusBarConnections", objectArray);
                StatusBar.this.connectionLabel.setText(string);
                StatusBar.this.connectionLabel.setToolTipText(Localizer.getString("TTTStatusBarConnections"));
                StatusBar.this.setPreferredSize(new Dimension(((StatusBar)StatusBar.this).connectionLabel.getPreferredSize().width, ((StatusBar)StatusBar.this).connectionLabel.getPreferredSize().height + 6));
                objectArray = new Object[]{new Integer(StatusBar.this.swarmingMgr.getDownloadFileCount(2)), new Integer(StatusBar.this.swarmingMgr.getDownloadFileCount()), new Integer(StatusBar.this.swarmingMgr.getDownloadFileCount(3))};
                string = Localizer.getFormatedString("StatusBarDownloads", objectArray);
                StatusBar.this.downloadLabel.setText(string);
                StatusBar.this.downloadLabel.setToolTipText(Localizer.getString("TTTStatusBarDownloads"));
                StatusBar.this.setPreferredSize(new Dimension(((StatusBar)StatusBar.this).downloadLabel.getPreferredSize().width, ((StatusBar)StatusBar.this).downloadLabel.getPreferredSize().height + 6));
                objectArray = new Object[]{new Integer(StatusBar.this.uploadMgr.getUploadingCount()), new Integer(StatusBar.this.uploadMgr.getUploadQueueSize()), CompletedUploadCountStatistic.getInstance().getValue()};
                string = Localizer.getFormatedString("StatusBarUploads", objectArray);
                StatusBar.this.uploadLabel.setText(string);
                StatusBar.this.uploadLabel.setToolTipText(Localizer.getString("TTTStatusBarUploads"));
                StatusBar.this.setPreferredSize(new Dimension(((StatusBar)StatusBar.this).uploadLabel.getPreferredSize().width, ((StatusBar)StatusBar.this).uploadLabel.getPreferredSize().height + 6));
            }
        });
    }

    private class StatusChangedListener
    implements DownloadFilesChangeListener,
    UploadFilesChangeListener,
    NetworkHostsChangeListener {
        private StatusChangedListener() {
        }

        public void networkHostChanged(int n) {
            StatusBar.this.updateStatusBar();
        }

        public void networkHostAdded(int n) {
            StatusBar.this.updateStatusBar();
        }

        public void networkHostRemoved(int n) {
            StatusBar.this.updateStatusBar();
        }

        public void uploadFileChanged(int n) {
            StatusBar.this.updateStatusBar();
        }

        public void uploadFileAdded(int n) {
            StatusBar.this.updateStatusBar();
        }

        public void uploadQueueChanged() {
            StatusBar.this.updateStatusBar();
        }

        public void uploadFileRemoved(int n) {
            StatusBar.this.updateStatusBar();
        }

        public void downloadFileChanged(int n) {
            StatusBar.this.updateStatusBar();
        }

        public void downloadFileAdded(int n) {
            StatusBar.this.updateStatusBar();
        }

        public void downloadFileRemoved(int n) {
            StatusBar.this.updateStatusBar();
        }
    }
}

