/*
 * Decompiled with CFR 0.152.
 */
package phex.download.swarming;

import phex.download.swarming.SWDownloadCandidate;
import phex.download.swarming.SWDownloadConstants;
import phex.utils.Localizer;
import phex.utils.StrUtil;

public final class SWDownloadInfo
implements SWDownloadConstants {
    private SWDownloadInfo() {
    }

    public static String getDownloadFileStatusString(int n) {
        switch (n) {
            case 1: {
                return Localizer.getString("WaitingForDownload");
            }
            case 2: {
                return Localizer.getString("Downloading");
            }
            case 3: {
                return Localizer.getString("Completed");
            }
            case 4: {
                return Localizer.getString("Stopped");
            }
        }
        Object[] objectArray = new Object[]{new Integer(n)};
        return Localizer.getFormatedString("UnrecognizedStatus", objectArray);
    }

    public static String getDownloadCandidateStatusString(SWDownloadCandidate sWDownloadCandidate) {
        int n = sWDownloadCandidate.getStatus();
        switch (n) {
            case 10: {
                return Localizer.getString("WaitingForDownload");
            }
            case 13: {
                Object[] objectArray = new Object[]{new Long(sWDownloadCandidate.getStatusTimeLeft() / 1000L)};
                return Localizer.getFormatedString("HostBusy", objectArray);
            }
            case 11: {
                Object[] objectArray = new Object[]{new Long(sWDownloadCandidate.getStatusTimeLeft() / 1000L)};
                return Localizer.getFormatedString("Connecting", objectArray);
            }
            case 16: {
                Object[] objectArray = new Object[]{StrUtil.formatSignificantElapsedTime(sWDownloadCandidate.getStatusTimeLeft() / 1000L)};
                return Localizer.getFormatedString("RangeUnavailable", objectArray);
            }
            case 17: {
                Object[] objectArray = new Object[]{sWDownloadCandidate.getXQueueParameters().getPosition(), StrUtil.formatSignificantElapsedTime(sWDownloadCandidate.getStatusTimeLeft() / 1000L)};
                return Localizer.getFormatedString("RemotlyQueued", objectArray);
            }
            case 15: {
                Object[] objectArray = new Object[]{StrUtil.formatSignificantElapsedTime(sWDownloadCandidate.getStatusTimeLeft() / 1000L)};
                return Localizer.getFormatedString("ConnectionFailed", objectArray);
            }
            case 14: {
                Object[] objectArray = new Object[]{new Long(sWDownloadCandidate.getStatusTimeLeft() / 1000L)};
                return Localizer.getFormatedString("PushRequest", objectArray);
            }
            case 12: {
                return Localizer.getFormatedString("Downloading", null);
            }
        }
        Object[] objectArray = new Object[]{new Integer(n)};
        return Localizer.getFormatedString("UnrecognizedStatus", objectArray);
    }
}

