/*
 * Decompiled with CFR 0.152.
 */
package phex.download;

import java.io.Serializable;
import phex.common.URN;
import phex.host.HostAddress;
import phex.msg.GUID;
import phex.query.QueryHitHost;

public class RemoteFile
implements Serializable {
    private QueryHitHost qhHost;
    private int mFileIndex;
    private String mFilename;
    private String mShortname;
    private String mFileExt = null;
    private Long mFileSizeLong;
    private URN urn;
    private String metaData;
    private boolean isInDownloadQueue;
    private Short score;

    private RemoteFile() {
    }

    private RemoteFile(GUID gUID, int n, String string, long l, HostAddress hostAddress, int n2) {
        this(new QueryHitHost(gUID, hostAddress, n2), n, string, l, null, null, -1);
    }

    public RemoteFile(QueryHitHost queryHitHost, int n, String string, long l, URN uRN, String string2, short s) {
        this.qhHost = queryHitHost;
        this.mFileIndex = n;
        this.mShortname = this.mFilename = string;
        this.mFileSizeLong = new Long(l);
        this.urn = uRN;
        this.metaData = string2;
        this.isInDownloadQueue = false;
        this.score = new Short(s);
        int n2 = this.mFilename.lastIndexOf("/");
        if (n2 != -1) {
            this.mShortname = this.mFilename.substring(n2 + 1);
        } else {
            n2 = this.mFilename.lastIndexOf("\\");
            if (n2 != -1) {
                this.mShortname = this.mFilename.substring(n2 + 1);
            }
        }
    }

    public RemoteFile(RemoteFile remoteFile) {
        this.copy(remoteFile);
    }

    public void copy(RemoteFile remoteFile) {
        this.qhHost = remoteFile.qhHost;
        this.mFileIndex = remoteFile.getFileIndex();
        this.urn = remoteFile.urn;
        this.mFilename = remoteFile.getFilename();
        this.mShortname = remoteFile.getShortname();
        this.mFileSizeLong = remoteFile.getFileSizeObject();
        this.isInDownloadQueue = remoteFile.isInDownloadQueue();
        this.score = remoteFile.getScore();
    }

    public GUID getRemoteClientID() {
        return this.qhHost.getHostGUID();
    }

    public int getFileIndex() {
        return this.mFileIndex;
    }

    public String getFilename() {
        return this.mFilename;
    }

    public String getShortname() {
        return this.mShortname;
    }

    public String getFileExt() {
        if (this.mFileExt != null) {
            return this.mFileExt;
        }
        int n = this.mFilename.lastIndexOf(".");
        this.mFileExt = n > -1 ? this.mFilename.substring(n + 1, this.mFilename.length()) : "";
        return this.mFileExt;
    }

    public long getFileSize() {
        return this.mFileSizeLong;
    }

    public Long getFileSizeObject() {
        return this.mFileSizeLong;
    }

    public QueryHitHost getQueryHitHost() {
        return this.qhHost;
    }

    public void setQueryHitHost(QueryHitHost queryHitHost) {
        this.qhHost = queryHitHost;
    }

    public HostAddress getHostAddress() {
        return this.qhHost.getHostAddress();
    }

    public String getMetaData() {
        return this.metaData;
    }

    public void setMetaData(String string) {
        this.metaData = string;
    }

    public URN getURN() {
        return this.urn;
    }

    public String getSHA1() {
        if (this.urn == null || !this.urn.isSha1Nid()) {
            return "";
        }
        return this.urn.getNamespaceSpecificString();
    }

    public int getSpeed() {
        return this.qhHost.getHostSpeed();
    }

    public Integer getSpeedObject() {
        return this.qhHost.getHostSpeedObject();
    }

    public boolean isInDownloadQueue() {
        return this.isInDownloadQueue;
    }

    public void setInDownloadQueue(boolean bl) {
        this.isInDownloadQueue = bl;
    }

    public Short getScore() {
        return this.score;
    }

    public boolean equals(Object object) {
        if (!(object instanceof RemoteFile)) {
            return false;
        }
        RemoteFile remoteFile = (RemoteFile)object;
        return this.qhHost.getHostAddress().equals(remoteFile.qhHost.getHostAddress()) && this.mFileIndex == remoteFile.mFileIndex;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("  ");
        stringBuffer.append(this.qhHost.getHostAddress());
        stringBuffer.append("  ");
        stringBuffer.append(this.mFilename);
        stringBuffer.append("  ");
        stringBuffer.append(this.mFileIndex);
        return stringBuffer.toString();
    }
}

