/*
 * Decompiled with CFR 0.152.
 */
package phex.download;

import java.io.IOException;
import java.net.Socket;
import phex.common.ServiceManager;
import phex.download.PushHandler;
import phex.msg.GUID;
import phex.msg.MsgManager;

public class PushRequestSleeper {
    private GUID clientGUID;
    private long fileIndex;
    private Socket givenSocket;

    public PushRequestSleeper(GUID gUID, long l) {
        this.clientGUID = gUID;
        this.fileIndex = l;
    }

    public GUID getGUID() {
        return this.clientGUID;
    }

    public long getFileIndex() {
        return this.fileIndex;
    }

    public synchronized boolean acceptGIVConnection(Socket socket, GUID gUID) {
        if (!this.clientGUID.equals(gUID)) {
            return false;
        }
        this.givenSocket = socket;
        this.notify();
        return true;
    }

    public synchronized Socket requestSocketViaPush() {
        try {
            MsgManager.getInstance().sendPushRequest(this);
        }
        catch (IOException iOException) {
            PushHandler.unregisterPushRequestSleeper(this);
            return null;
        }
        try {
            this.wait(ServiceManager.sCfg.mPushTransferTimeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.givenSocket == null) {
            PushHandler.unregisterPushRequestSleeper(this);
            return null;
        }
        PushHandler.unregisterPushRequestSleeper(this);
        return this.givenSocket;
    }
}

