/*
 * Decompiled with CFR 0.152.
 */
package phex.download;

import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import phex.download.IDownloadCandidate;
import phex.download.PushRequestSleeper;
import phex.msg.GUID;
import phex.utils.Logger;

public class PushHandler {
    private static PushHandler singleton = new PushHandler();
    private ArrayList pushSleeperList = new ArrayList(5);

    private PushHandler() {
    }

    public static void handleIncommingGIV(Socket socket, GUID gUID, String string) {
        singleton.internalHandleIncommingGIV(socket, gUID, string);
    }

    public static Socket requestSocketViaPush(IDownloadCandidate iDownloadCandidate) {
        if (iDownloadCandidate.getGUID() == null) {
            return null;
        }
        return singleton.internalRequestSocketViaPush(iDownloadCandidate.getGUID(), iDownloadCandidate.getFileIndex(), iDownloadCandidate.getFileName());
    }

    public static Socket requestSocketViaPush(GUID gUID, long l, String string) {
        return singleton.internalRequestSocketViaPush(gUID, l, string);
    }

    public static void unregisterPushRequestSleeper(PushRequestSleeper pushRequestSleeper) {
        singleton.internalUnregisterPushRequestSleeper(pushRequestSleeper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalHandleIncommingGIV(Socket socket, GUID gUID, String string) {
        Logger.logMessage(Logger.FINER, (short)2, "Handle incomming GIV response:  - " + string);
        ArrayList arrayList = this.pushSleeperList;
        synchronized (arrayList) {
            Iterator iterator = this.pushSleeperList.iterator();
            while (iterator.hasNext()) {
                boolean bl = ((PushRequestSleeper)iterator.next()).acceptGIVConnection(socket, gUID);
                if (!bl) continue;
                Logger.logMessage(Logger.FINER, (short)2, "Accepted GIV response:  - " + string);
                return;
            }
        }
        Logger.logMessage(Logger.FINER, (short)2, "No Push request for GIV found: " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Socket internalRequestSocketViaPush(GUID gUID, long l, String string) {
        PushRequestSleeper pushRequestSleeper = new PushRequestSleeper(gUID, l);
        ArrayList arrayList = this.pushSleeperList;
        synchronized (arrayList) {
            this.pushSleeperList.add(pushRequestSleeper);
        }
        Socket socket = pushRequestSleeper.requestSocketViaPush();
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalUnregisterPushRequestSleeper(PushRequestSleeper pushRequestSleeper) {
        ArrayList arrayList = this.pushSleeperList;
        synchronized (arrayList) {
            this.pushSleeperList.remove(pushRequestSleeper);
        }
    }
}

