/*
 * Decompiled with CFR 0.152.
 */
package phex.connection;

import phex.msg.Message;
import phex.utils.CircularQueue;
import phex.utils.Logger;

public class FlowControlQueue {
    private int dropCount = 0;
    private int burstSize;
    private int currentBurstCount;
    private int msgTimeout;
    private boolean isLIFO;
    private CircularQueue msgQueue;

    public FlowControlQueue(int n, int n2, int n3, boolean bl) {
        this.msgQueue = new CircularQueue(n3);
        this.burstSize = n;
        this.msgTimeout = n2;
        this.isLIFO = bl;
    }

    public void addMessage(Message message) {
        Object object = this.msgQueue.addToTail(message);
        if (object != null) {
            Logger.logMessage(Logger.FINER, (short)16, "Dropping overflowing message: " + message);
            ++this.dropCount;
        }
    }

    public Message removeMessage() {
        Message message;
        if (this.currentBurstCount == this.burstSize) {
            return null;
        }
        long l = System.currentTimeMillis() - (long)this.msgTimeout;
        while (true) {
            if ((message = this.removeNextMessage()) == null) {
                return null;
            }
            if (message.getCreationTime() >= l) break;
            Logger.logMessage(Logger.FINER, (short)16, "Dropping expired message: " + message);
            ++this.dropCount;
        }
        ++this.currentBurstCount;
        return message;
    }

    public void initNewMessageBurst() {
        this.currentBurstCount = 0;
    }

    public int getAndResetDropCount() {
        int n = this.dropCount;
        this.dropCount = 0;
        return n;
    }

    private Message removeNextMessage() {
        if (this.msgQueue.isEmpty()) {
            return null;
        }
        if (this.isLIFO) {
            return (Message)this.msgQueue.removeFromTail();
        }
        return (Message)this.msgQueue.removeFromHead();
    }
}

