/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.zip.Inflater;
import phex.common.URN;
import phex.host.Host;
import phex.host.HostManager;
import phex.msg.InvalidMessageException;
import phex.msg.MsgQuery;
import phex.msg.QRPatchTableMsg;
import phex.msg.QRResetTableMsg;
import phex.msg.RouteTableUpdateMsg;
import phex.share.FileAdministration;
import phex.share.ShareFile;
import phex.share.ShareManager;
import phex.utils.IOUtil;
import phex.utils.Logger;

public class QueryRoutingTable {
    public static final byte DEFAULT_INFINITY_TTL = 7;
    public static final int DEFAULT_TABLE_SIZE = 65536;
    private BitSet qrTable;
    private BitSet resizedQRTable;
    private int tableSize;
    private byte tableBits;
    private byte infinity;
    private int entryCount;
    private byte sequenceSize;
    private byte sequenceNumber;
    private int patchPosition;
    private Inflater inflater;
    private static final int A_INT = 1327217884;

    public QueryRoutingTable() {
        this.init(65536, (byte)7);
    }

    private void init(int n, byte by) {
        this.tableSize = n;
        this.infinity = by;
        this.tableBits = IOUtil.calculateLog2(n);
        this.qrTable = new BitSet(n);
        this.resizedQRTable = null;
        this.entryCount = 0;
        this.sequenceSize = 0;
        this.sequenceNumber = 0;
        this.patchPosition = 0;
        this.inflater = null;
    }

    public void aggregateToRouteTable(QueryRoutingTable queryRoutingTable) {
        BitSet bitSet = this.tableSize != queryRoutingTable.tableSize ? queryRoutingTable.resizeRouteTable(this.tableSize) : queryRoutingTable.qrTable;
        this.qrTable.or(bitSet);
    }

    private void add(String string) {
        String[] stringArray = QueryRoutingTable.splitFilePath(string);
        int n = 0;
        while (n < stringArray.length) {
            int n2 = QueryRoutingTable.qrpHash(stringArray[n], 0, stringArray[n].length(), this.tableBits);
            if (!this.qrTable.get(n2)) {
                ++this.entryCount;
                this.qrTable.set(n2);
                this.resizedQRTable = null;
            }
            ++n;
        }
    }

    private void addWord(String string) {
        int n = QueryRoutingTable.qrpHash(string, 0, string.length(), this.tableBits);
        if (!this.qrTable.get(n)) {
            ++this.entryCount;
            this.qrTable.set(n);
            this.resizedQRTable = null;
        }
    }

    public boolean containsQuery(MsgQuery msgQuery) {
        if (msgQuery.hasQueryURNs()) {
            URN[] uRNArray = msgQuery.getQueryURNs();
            int n = 0;
            while (n < uRNArray.length) {
                String string = uRNArray[n].getAsString();
                int n2 = QueryRoutingTable.qrpHash(string, 0, string.length(), this.tableBits);
                if (this.qrTable.get(n2)) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        String string = msgQuery.getSearchString();
        if (string == null) {
            return false;
        }
        String[] stringArray = QueryRoutingTable.splitQueryString(string);
        int n = 0;
        while (n < stringArray.length) {
            int n3 = QueryRoutingTable.qrpHash(stringArray[n], 0, stringArray[n].length(), this.tableBits);
            if (!this.qrTable.get(n3)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void updateRouteTable(RouteTableUpdateMsg routeTableUpdateMsg) throws InvalidMessageException {
        if (routeTableUpdateMsg.getVariant() == 0) {
            int n = ((QRResetTableMsg)routeTableUpdateMsg).getTableSize();
            Logger.logMessage(Logger.FINER, (short)16, "Reseting QRT from: " + routeTableUpdateMsg.getHeader().getFromHost() + " Size: " + n);
            this.init(n, this.infinity);
        } else if (routeTableUpdateMsg.getVariant() == 1) {
            byte by;
            int n;
            byte by2;
            QRPatchTableMsg qRPatchTableMsg = (QRPatchTableMsg)routeTableUpdateMsg;
            byte by3 = qRPatchTableMsg.getSequenceSize();
            byte by4 = qRPatchTableMsg.getSequenceNumber();
            Logger.logMessage(Logger.FINER, (short)16, "Patching QRT from: " + routeTableUpdateMsg.getHeader().getFromHost() + " " + by4 + "/" + by3);
            if (this.sequenceSize == 0 && this.sequenceNumber == 0) {
                this.sequenceSize = by3;
                this.sequenceNumber = 1;
            }
            if (this.sequenceSize != by3 || by4 != this.sequenceNumber || by3 == 0) {
                throw new InvalidMessageException("QRTPatchMsg sequence size or number not valid.\nSize: (" + by3 + "/" + this.sequenceSize + ").\n" + "Number: (" + by4 + "/" + this.sequenceNumber + ").");
            }
            this.sequenceNumber = by4;
            byte[] byArray = qRPatchTableMsg.getPatchData();
            byte by5 = qRPatchTableMsg.getCompressor();
            if (by5 == 1) {
                if (this.sequenceNumber == 1) {
                    this.inflater = new Inflater();
                }
                if ((byArray = IOUtil.inflate(this.inflater, byArray)) == null) {
                    throw new InvalidMessageException("Can't inflate patch data");
                }
            } else if (by5 != 0) {
                throw new InvalidMessageException("QRTPatchMsg Unknown compression: " + by5);
            }
            if ((by2 = qRPatchTableMsg.getEntryBits()) == 4) {
                byte[] byArray2 = new byte[byArray.length * 2];
                n = 0;
                while (n < byArray.length) {
                    byArray2[n * 2] = (byte)(byArray[n] >> 4);
                    by = (byte)(byArray[n] & 0xF);
                    if ((by & 8) != 0) {
                        by = (byte)(0xF0 | by);
                    }
                    byArray2[n * 2 + 1] = by;
                    ++n;
                }
                byArray = byArray2;
            } else if (by2 != 8) {
                throw new InvalidMessageException("QRTPatchMsg Unknown ENTRY_BITS value: " + by2);
            }
            try {
                n = 0;
                while (n < byArray.length) {
                    boolean bl = this.qrTable.get(this.patchPosition);
                    if (byArray[n] == 1 - this.infinity) {
                        this.qrTable.set(this.patchPosition);
                        this.resizedQRTable = null;
                    } else if (byArray[n] == this.infinity - 1) {
                        this.qrTable.clear(this.patchPosition);
                        this.resizedQRTable = null;
                    }
                    by = (byte)(this.qrTable.get(this.patchPosition) ? 1 : 0);
                    if (bl && by == 0) {
                        --this.entryCount;
                    } else if (!bl && by != 0) {
                        ++this.entryCount;
                    }
                    ++this.patchPosition;
                    ++n;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new InvalidMessageException("QRTPatchMsg Wrong patch message data size.");
            }
            if (this.sequenceNumber == this.sequenceSize) {
                this.sequenceSize = 0;
                this.sequenceNumber = 0;
                this.patchPosition = 0;
                this.inflater = null;
            } else {
                this.sequenceNumber = (byte)(this.sequenceNumber + 1);
            }
        }
    }

    private BitSet resizeRouteTable(int n) {
        if (this.tableSize == n) {
            return this.qrTable;
        }
        if (this.resizedQRTable != null && this.resizedQRTable.size() == n) {
            return this.resizedQRTable;
        }
        this.resizedQRTable = new BitSet(n);
        double d = (double)n / (double)this.tableSize;
        int n2 = 0;
        while (n2 < this.tableSize) {
            if (this.qrTable.get(n2)) {
                int n3 = (int)Math.floor((double)n2 * d);
                int n4 = (int)Math.ceil((double)(n2 + 1) * d);
                int n5 = n3;
                while (n5 < n4) {
                    this.resizedQRTable.set(n5);
                    ++n5;
                }
            }
            ++n2;
        }
        return this.resizedQRTable;
    }

    private static String[] splitQueryString(String string) {
        String[] stringArray;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " -._+/*()[]\\");
        ArrayList<String[]> arrayList = new ArrayList<String[]>(10);
        while (stringTokenizer.hasMoreTokens()) {
            stringArray = stringTokenizer.nextToken();
            arrayList.add(stringArray);
        }
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    private static String[] splitFilePath(String string) {
        String[] stringArray;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " -._+/*()[]\\");
        ArrayList<Object> arrayList = new ArrayList<Object>(20);
        while (stringTokenizer.hasMoreTokens()) {
            stringArray = stringTokenizer.nextToken();
            arrayList.add(stringArray);
            int n = stringArray.length();
            int n2 = 1;
            while (n2 < 5 && n - n2 > 5) {
                arrayList.add(stringArray.substring(0, n - n2));
                ++n2;
            }
        }
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public static QueryRoutingTable createLocalQueryRoutingTable() {
        int n;
        String[] stringArray;
        long l = System.currentTimeMillis();
        QueryRoutingTable queryRoutingTable = new QueryRoutingTable();
        FileAdministration fileAdministration = ShareManager.getInstance().getFileAdministration();
        ShareFile[] shareFileArray = fileAdministration.getSharedFiles();
        HashSet<String> hashSet = new HashSet<String>();
        int n2 = 0;
        while (n2 < shareFileArray.length) {
            hashSet.add(shareFileArray[n2].getURN().getAsString());
            stringArray = QueryRoutingTable.splitFilePath(shareFileArray[n2].getFile().getAbsolutePath());
            n = 0;
            while (n < stringArray.length) {
                hashSet.add(stringArray[n]);
                ++n;
            }
            ++n2;
        }
        stringArray = QueryRoutingTable.splitFilePath("!`phex~~ping");
        n = 0;
        while (n < stringArray.length) {
            hashSet.add(stringArray[n]);
            ++n;
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            queryRoutingTable.addWord((String)iterator.next());
        }
        HostManager hostManager = HostManager.getInstance();
        if (hostManager.isUltrapeer()) {
            Host[] hostArray = hostManager.getNetworkHostsContainer().getLeafConnections();
            int n3 = 0;
            while (n3 < hostArray.length) {
                QueryRoutingTable queryRoutingTable2 = hostArray[n3].getLastReceivedRoutingTable();
                if (queryRoutingTable2 != null) {
                    queryRoutingTable.aggregateToRouteTable(queryRoutingTable2);
                }
                ++n3;
            }
        }
        long l2 = System.currentTimeMillis();
        Logger.logMessage(Logger.FINER, (short)4, "Created QRT: " + queryRoutingTable.entryCount + " / " + queryRoutingTable.tableSize + " time: " + (l2 - l));
        return queryRoutingTable;
    }

    public static Iterator buildRouteTableUpdateMsgIterator(QueryRoutingTable queryRoutingTable, QueryRoutingTable queryRoutingTable2) {
        int n;
        byte by;
        byte by2;
        ArrayList<RouteTableUpdateMsg> arrayList = new ArrayList<RouteTableUpdateMsg>();
        if (queryRoutingTable2 == null) {
            arrayList.add(new QRResetTableMsg(queryRoutingTable.tableSize, queryRoutingTable.infinity));
        }
        boolean bl = false;
        byte[] byArray = new byte[queryRoutingTable.tableSize / 2];
        int n2 = 0;
        while (n2 < byArray.length) {
            byte by3;
            if (queryRoutingTable2 == null) {
                by2 = queryRoutingTable.qrTable.get(n2 * 2) ? (byte)(1 - queryRoutingTable.infinity) : (byte)0;
                by3 = queryRoutingTable.qrTable.get(n2 * 2 + 1) ? (byte)(1 - queryRoutingTable.infinity) : (byte)0;
            } else {
                by = queryRoutingTable.qrTable.get(n2 * 2);
                by2 = by == queryRoutingTable2.qrTable.get(n2 * 2) ? (byte)0 : (by != 0 ? (byte)(1 - queryRoutingTable.infinity) : (byte)(queryRoutingTable.infinity - 1));
                by = (byte)(queryRoutingTable.qrTable.get(n2 * 2 + 1) ? 1 : 0);
                by3 = by == queryRoutingTable2.qrTable.get(n2 * 2 + 1) ? (byte)0 : (by != 0 ? (byte)(1 - queryRoutingTable.infinity) : (byte)(queryRoutingTable.infinity - 1));
            }
            byArray[n2] = (byte)(by2 << 4 | by3 & 0xF);
            if (byArray[n2] != 0) {
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            return arrayList.iterator();
        }
        by2 = 0;
        byte[] byArray2 = IOUtil.deflate(byArray);
        if (byArray2.length < byArray.length) {
            byArray = byArray2;
            by2 = 1;
        }
        by = (byte)Math.ceil((double)byArray.length / 4096.0);
        byte by4 = 1;
        int n3 = 0;
        do {
            n = Math.min(4096, byArray.length - n3);
            QRPatchTableMsg qRPatchTableMsg = new QRPatchTableMsg(by4, by, by2, 4, byArray, n3, n);
            arrayList.add(qRPatchTableMsg);
            by4 = (byte)(by4 + 1);
        } while ((n3 += n) < byArray.length);
        return arrayList.iterator();
    }

    private static int qrpHash(String string, int n, int n2, byte by) {
        int n3 = 0;
        int n4 = 0;
        int n5 = n;
        while (n5 < n2) {
            int n6 = Character.toLowerCase(string.charAt(n5)) & 0xFF;
            n3 ^= (n6 <<= n4 * 8);
            n4 = (n4 + 1) % 4;
            ++n5;
        }
        long l = (long)n3 * 1327217884L;
        long l2 = l << 32;
        return (int)(l2 >>>= 32 + (32 - by));
    }
}

