/*
 * Decompiled with CFR 0.152.
 */
package phex;

import phex.common.ServiceManager;
import phex.common.ThreadPool;
import phex.common.ThreadTracking;
import phex.common.TransferRateService;
import phex.connection.IncomingListener;
import phex.connection.NetworkManager;
import phex.gui.common.GUIRegistry;
import phex.gui.common.MainFrame;
import phex.host.GWebCacheContainer;
import phex.host.HostAddress;
import phex.host.HostManager;
import phex.msg.MsgManager;
import phex.query.QueryManager;
import phex.share.ShareManager;
import phex.upload.UploadManager;
import phex.utils.Logger;

public class JobsRunner
implements Runnable {
    private boolean mRequestToDie = false;
    private boolean mRunning = false;
    private boolean mShutdownCompleted = false;
    private HostManager hostMgr = HostManager.getInstance();
    private MsgManager msgMgr = MsgManager.getInstance();
    private ShareManager shareMgr = ShareManager.getInstance();
    private NetworkManager networkMgr = NetworkManager.getInstance();
    private TransferRateService transferRateService = ServiceManager.getTransferRateService();
    private boolean mInitScan = false;

    public synchronized void startup() {
        if (this.mRunning) {
            return;
        }
        Logger.logMessage(Logger.FINE, (short)255, "Background jobs runner starting...");
        this.mRequestToDie = false;
        this.mRunning = true;
        Thread thread = new Thread(ThreadTracking.rootThreadGroup, this, "JobsRunner-" + Integer.toHexString(this.hashCode()));
        thread.setDaemon(true);
        thread.start();
    }

    public boolean getRunning() {
        return this.mRunning;
    }

    public synchronized void shutdown(boolean bl) {
        if (this.mRequestToDie) {
            return;
        }
        Logger.logMessage(Logger.FINE, (short)255, "Background jobs runner shutting down...");
        this.mShutdownCompleted = false;
        this.mRequestToDie = true;
        if (bl) {
            while (!this.mShutdownCompleted) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }
    }

    public void run() {
        Logger.logMessage(Logger.FINE, (short)255, "Background jobs runner started.");
        MainFrame mainFrame = GUIRegistry.getInstance().getMainFrame();
        int n = 1000;
        int n2 = 0;
        QueryManager queryManager = QueryManager.getInstance();
        UploadManager uploadManager = UploadManager.getInstance();
        GUIRegistry gUIRegistry = GUIRegistry.getInstance();
        block4: while (true) {
            try {
                while (true) {
                    try {
                        Thread.sleep(n);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this.mRequestToDie) break block4;
                    gUIRegistry.getLazyEventQueue().fireLazyEvents();
                    if (n2 % 2 == 0) {
                        this.hostMgr.doAutoConnectCheck();
                        this.hostMgr.periodicallyCheckHosts();
                        gUIRegistry.getTableUpdateService().updateTables();
                    }
                    if (n2 % 5 == 0) {
                        if (ServiceManager.sCfg.mUploadAutoRemoveCompleted) {
                            uploadManager.cleanUploadStateList();
                        }
                        queryManager.stopExpiredSearches();
                    }
                    if (n2 % 10 == 0) {
                        this.transferRateService.setTransferRateTimestamp();
                    }
                    if (n2 % 30 == 0) {
                        queryManager.getResearchService().startResearchSequence();
                    }
                    if (n2 % 60 == 0) {
                        ThreadPool.trackThreadHandling();
                        this.hostMgr.saveHostsContainer();
                        if (n2 > 1) {
                            this.shareMgr.getFileAdministration().rescan(false, false);
                        }
                    }
                    if (n2 % 600 == 0 && (NetworkManager.getInstance().isConnected() || this.hostMgr.getNetworkHostsContainer().getTotalConnectionCount() > 0)) {
                        GWebCacheContainer.invokeQueryMoreGWebCachesRequest();
                        GWebCacheContainer.invokeQueryMoreHostsRequest();
                    }
                    if (n2 % 3600 == 0 && (NetworkManager.getInstance().isConnected() || this.hostMgr.getNetworkHostsContainer().getTotalConnectionCount() > 0) && n2 > 1) {
                        HostAddress hostAddress = null;
                        IncomingListener incomingListener = this.networkMgr.getIncomingListener();
                        if (incomingListener.hasConnectedIncoming() && !ServiceManager.sCfg.isBehindFirewall && (hostAddress = this.networkMgr.getLocalAddress()).isPrivateIP()) {
                            hostAddress = null;
                        }
                        GWebCacheContainer.invokeUpdateRemoteGWebCache(hostAddress);
                    }
                    if (!this.mInitScan) {
                        this.shareMgr.getFileAdministration().rescan(true, false);
                        this.mInitScan = true;
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            break;
        }
        this.shutdownCompleted();
    }

    private synchronized void shutdownCompleted() {
        this.mRunning = false;
        Logger.logMessage(Logger.FINE, (short)255, "Background jobs runner stopped.");
        this.mShutdownCompleted = true;
        this.notifyAll();
    }
}

