/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.CreationTimeCache;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.mp3.ID3Reader;
import com.limegroup.gnutella.util.NameValue;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLReplyCollection;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.limegroup.gnutella.xml.RichQueryHandler;
import com.limegroup.gnutella.xml.SchemaNotFoundException;
import com.limegroup.gnutella.xml.SchemaReplyCollectionMapper;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import java.io.File;
import java.io.IOException;

public class MetaFileManager
extends FileManager {
    private final Object META_LOCK = new Object();

    public synchronized Response[] query(QueryRequest request) {
        Response[] metas;
        LimeXMLDocument doc;
        Response[] result = super.query(request);
        if (this.shouldIncludeXMLInResponse(request) && (doc = request.getRichQuery()) != null && (metas = RichQueryHandler.instance().query(doc)) != null) {
            result = this.union(result, metas);
        }
        return result;
    }

    protected boolean shouldIncludeXMLInResponse(QueryRequest qr) {
        return qr.desiresXMLResponses() || qr.desiresOutOfBandReplies();
    }

    protected void addXMLToResponse(Response response, FileDesc fd) {
        List docs = fd.getLimeXMLDocuments();
        if (docs.size() == 0) {
            return;
        }
        if (docs.size() == 1) {
            response.setDocument((LimeXMLDocument)docs.get(0));
        }
    }

    public FileDesc fileChanged(File f) {
        FileDesc removed;
        FileDesc fd = this.getFileDescForFile(f);
        if (fd == null) {
            return null;
        }
        CreationTimeCache ctCache = CreationTimeCache.instance();
        Long cTime = ctCache.getCreationTime(fd.getSHA1Urn());
        List xmlDocs = fd.getLimeXMLDocuments();
        if (LimeXMLUtils.isMP3File(f)) {
            try {
                LimeXMLDocument diskID3Doc = ID3Reader.readDocument(f);
                xmlDocs = this.resolveAudioDocs(xmlDocs, diskID3Doc);
            }
            catch (IOException e) {
                return super.fileChanged(f);
            }
        }
        Assert.that(fd == (removed = this.removeFileIfShared(f)), "did not remove valid fd.");
        FileManager._needRebuild = true;
        fd = this.addFileIfShared(f, xmlDocs);
        if (fd != null && cTime != null) {
            CreationTimeCache creationTimeCache = ctCache;
            synchronized (creationTimeCache) {
                ctCache.removeTime(fd.getSHA1Urn());
                ctCache.addTime(fd.getSHA1Urn(), cTime);
                ctCache.commitTime(fd.getSHA1Urn());
            }
        }
        return fd;
    }

    private List resolveAudioDocs(List allDocs, LimeXMLDocument id3Doc) {
        LimeXMLDocument audioDoc = null;
        LimeXMLSchema audioSchema = LimeXMLSchemaRepository.instance().getSchema("http://www.limewire.com/schemas/audio.xsd");
        Iterator iter = allDocs.iterator();
        while (iter.hasNext()) {
            LimeXMLDocument doc = (LimeXMLDocument)iter.next();
            if (doc.getSchema() != audioSchema) continue;
            audioDoc = doc;
            break;
        }
        if (id3Doc.equals(audioDoc)) {
            return allDocs;
        }
        ArrayList retList = new ArrayList();
        retList.addAll(allDocs);
        if (audioDoc == null) {
            retList.add(id3Doc);
            return retList;
        }
        retList.remove(audioDoc);
        List audioList = null;
        List id3List = null;
        try {
            audioList = audioDoc.getOrderedNameValueList();
            id3List = id3Doc.getOrderedNameValueList();
        }
        catch (SchemaNotFoundException snfx) {
            ErrorService.error(snfx);
        }
        int i = 0;
        while (i < audioList.size()) {
            NameValue nameVal = (NameValue)audioList.get(i);
            if (ID3Reader.isNonID3Field(nameVal.getName())) {
                id3List.add(nameVal);
            }
            ++i;
        }
        audioDoc = new LimeXMLDocument(id3List, "http://www.limewire.com/schemas/audio.xsd");
        retList.add(audioDoc);
        return retList;
    }

    public FileDesc removeFileIfShared(File f) {
        FileDesc fd = super.removeFileIfShared(f);
        if (fd == null) {
            return null;
        }
        SchemaReplyCollectionMapper mapper = SchemaReplyCollectionMapper.instance();
        List xmlDocs = fd.getLimeXMLDocuments();
        LinkedList schemas = new LinkedList();
        Iterator i = xmlDocs.iterator();
        while (i.hasNext()) {
            schemas.add(((LimeXMLDocument)i.next()).getSchemaURI());
        }
        Iterator i2 = schemas.iterator();
        while (i2.hasNext()) {
            String uri = (String)i2.next();
            LimeXMLReplyCollection col = mapper.getReplyCollection(uri);
            if (col == null) continue;
            col.removeDoc(fd);
        }
        FileManager._needRebuild = true;
        return fd;
    }

    public FileDesc addFileIfShared(File file, List metadata) {
        FileDesc fd = super.addFileIfShared(file);
        if (fd == null) {
            return null;
        }
        if (metadata == null || metadata.size() == 0) {
            LimeXMLDocument doc;
            if (!LimeXMLUtils.isMP3File(file)) {
                return fd;
            }
            try {
                doc = ID3Reader.readDocument(file);
            }
            catch (IOException ioe) {
                return fd;
            }
            metadata = new LinkedList();
            metadata.add(doc);
        }
        SchemaReplyCollectionMapper mapper = SchemaReplyCollectionMapper.instance();
        LinkedList schemasAddedTo = new LinkedList();
        Iterator iter = metadata.iterator();
        while (iter.hasNext()) {
            LimeXMLDocument currDoc = (LimeXMLDocument)iter.next();
            String uri = currDoc.getSchemaURI();
            LimeXMLReplyCollection collection = mapper.getReplyCollection(uri);
            if (collection == null || schemasAddedTo.contains(uri)) continue;
            schemasAddedTo.add(uri);
            if (ID3Reader.isCorrupted(currDoc)) {
                currDoc = ID3Reader.fixCorruption(currDoc);
            }
            collection.addReplyWithCommit(file, fd, currDoc, true);
        }
        FileManager._needRebuild = true;
        return fd;
    }

    protected void loadSettingsBlocking(boolean notifyOnClear) {
        RouterService.getCallback().setAnnotateEnabled(false);
        super.loadSettingsBlocking(notifyOnClear);
        if (this.loadThreadInterrupted()) {
            return;
        }
        Object object = this.META_LOCK;
        synchronized (object) {
            SchemaReplyCollectionMapper mapper = SchemaReplyCollectionMapper.instance();
            LimeXMLSchemaRepository schemaRepository = LimeXMLSchemaRepository.instance();
            if (this.loadThreadInterrupted()) {
                return;
            }
            String[] schemas = schemaRepository.getAvailableSchemaURIs();
            int len = schemas.length;
            FileDesc[] fds = super.getAllSharedFileDescriptors();
            int i = 0;
            while (i < len && !this.loadThreadInterrupted()) {
                String s = LimeXMLSchema.getDisplayString(schemas[i]);
                LimeXMLReplyCollection collection = new LimeXMLReplyCollection(fds, schemas[i], s.equalsIgnoreCase("audio"));
                mapper.add(schemas[i], collection);
                ++i;
            }
        }
        RouterService.getCallback().setAnnotateEnabled(true);
    }

    private Response[] union(Response[] normals, Response[] metas) {
        if (normals == null) {
            return metas;
        }
        if (metas == null) {
            return normals;
        }
        HashSet unionSet = new HashSet();
        int i = 0;
        while (i < metas.length) {
            unionSet.add(metas[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < normals.length) {
            unionSet.add(normals[i2]);
            ++i2;
        }
        Object[] retArray = new Response[unionSet.size()];
        retArray = (Response[])unionSet.toArray(retArray);
        return retArray;
    }

    protected void buildQRT() {
        super.buildQRT();
        Iterator iter = this.getXMLKeyWords().iterator();
        while (iter.hasNext()) {
            FileManager._queryRouteTable.add((String)iter.next());
        }
        iter = this.getXMLIndivisibleKeyWords().iterator();
        while (iter.hasNext()) {
            FileManager._queryRouteTable.addIndivisible((String)iter.next());
        }
    }

    private List getXMLKeyWords() {
        ArrayList words = new ArrayList();
        SchemaReplyCollectionMapper map = SchemaReplyCollectionMapper.instance();
        LimeXMLSchemaRepository rep = LimeXMLSchemaRepository.instance();
        String[] schemas = rep.getAvailableSchemaURIs();
        int len = schemas.length;
        int i = 0;
        while (i < len) {
            LimeXMLReplyCollection collection = map.getReplyCollection(schemas[i]);
            if (collection != null) {
                words.addAll(collection.getKeyWords());
            }
            ++i;
        }
        return words;
    }

    private List getXMLIndivisibleKeyWords() {
        ArrayList words = new ArrayList();
        LimeXMLSchemaRepository rep = LimeXMLSchemaRepository.instance();
        String[] schemas = rep.getAvailableSchemaURIs();
        int i = 0;
        while (i < schemas.length) {
            if (schemas[i] != null) {
                words.add(schemas[i]);
            }
            ++i;
        }
        return words;
    }
}

