/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.util.I18NConvert;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.SchemaNotFoundException;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Set;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LimeXMLUtils {
    private static final double MATCHING_RATE = 0.9;
    private static final String C_HEADER_BEGIN = "{";
    private static final String C_HEADER_END = "}";
    private static final String C_HEADER_NONE_VAL = "plaintext";
    private static final String C_HEADER_ZLIB_VAL = "deflate";
    private static final String C_HEADER_GZIP_VAL = "gzip";
    private static final String COMPRESS_HEADER_ZLIB = "{deflate}";
    private static final String COMPRESS_HEADER_GZIP = "{gzip}";
    private static final String COMPRESS_HEADER_NONE = "{}";
    private static final int NONE = 0;
    private static final int GZIP = 1;
    private static final int ZLIB = 2;
    public static final String AUDIO_BITRATE_ATTR = "audios__audio__bitrate__";
    private static final int NUM_BYTES_TO_HASH = 100;
    private static final int NUM_TOTAL_HASH = 300;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InputSource getInputSource(File file) throws IOException {
        StringBuffer sb = new StringBuffer();
        String line = "";
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(file));
            while (line != null) {
                line = br.readLine();
                if (line == null) continue;
                sb.append(line + "\n");
            }
            Object var5_4 = null;
            if (br == null) return new InputSource(new StringReader(sb.toString()));
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (br == null) throw throwable;
            br.close();
            throw throwable;
        }
        br.close();
        return new InputSource(new StringReader(sb.toString()));
    }

    public static Document getDocument(File file) throws IOException, ParserConfigurationException, SAXException {
        InputSource inputSource = LimeXMLUtils.getInputSource(file);
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = documentBuilder.parse(inputSource);
        return document;
    }

    public static String getAttributeValue(NamedNodeMap attributes, String soughtAttribute) {
        Node requiredNode = attributes.getNamedItem(soughtAttribute);
        if (requiredNode == null) {
            return null;
        }
        return requiredNode.getNodeValue();
    }

    public static List getElements(NodeList nodeList) {
        ArrayList elements = new ArrayList(nodeList.getLength());
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1) {
                elements.add(node);
            }
            ++i;
        }
        return elements;
    }

    public static List getAttributes(NamedNodeMap nodeMap) {
        ArrayList attributes = new ArrayList(nodeMap.getLength());
        int i = 0;
        while (i < nodeMap.getLength()) {
            Node node = nodeMap.item(i);
            attributes.add(node);
            ++i;
        }
        return attributes;
    }

    public static String getText(NodeList nodeList) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            switch (node.getNodeType()) {
                case 3: 
                case 4: {
                    buffer.append(node.getNodeValue());
                    break;
                }
                case 5: {
                    if (node.getNodeName().equals("amp")) {
                        buffer.append('&');
                        break;
                    }
                    if (node.getNodeName().equals("lt")) {
                        buffer.append('<');
                        break;
                    }
                    if (node.getNodeName().equals("gt")) {
                        buffer.append('>');
                        break;
                    }
                    if (node.getNodeName().equals("apos")) {
                        buffer.append('\'');
                        break;
                    }
                    if (!node.getNodeName().equals("quot")) break;
                    buffer.append('\"');
                    break;
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    public static void writeEscapedString(Writer writer, String string) throws IOException {
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            if (c == '<') {
                writer.write("&lt;");
            } else if (c == '>') {
                writer.write("&gt;");
            } else if (c == '&') {
                writer.write("&amp;");
            } else if (c == '\'') {
                writer.write("&apos;");
            } else if (c == '\"') {
                writer.write("&quot;");
            } else {
                writer.write(c);
            }
            ++i;
        }
    }

    public static Response createResponse(String xml) {
        return new Response(0xFFFFFFFFL, (long)xml.length(), "xml result", xml);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] readFully(InputStream in) throws IOException {
        int bytesRead;
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((bytesRead = in.read(buffer)) != -1) {
            void var3_3;
            byteArray.write(buffer, 0, (int)var3_3);
        }
        return byteArray.toByteArray();
    }

    public static boolean match(LimeXMLDocument replyDoc, LimeXMLDocument queryDoc) {
        if (replyDoc == null) {
            return false;
        }
        if (queryDoc == null) {
            throw new NullPointerException("querying with null doc.");
        }
        Set queryNameValues = queryDoc.getNameValueSet();
        int size = queryNameValues.size();
        int matchCount = 0;
        int nullCount = 0;
        boolean matchedBitrate = false;
        Iterator i = queryNameValues.iterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            String currFieldName = (String)entry.getKey();
            String queryValue = (String)entry.getValue();
            Assert.that(queryValue != null, "null value");
            if (queryValue.equals("")) continue;
            String replyDocValue = replyDoc.getValue(currFieldName);
            if (replyDocValue == null || replyDocValue.equals("")) {
                ++nullCount;
                continue;
            }
            try {
                double rDVD = new Double(replyDocValue);
                double qVD = new Double(queryValue);
                if (rDVD != qVD) continue;
                ++matchCount;
                if (!currFieldName.equals(AUDIO_BITRATE_ATTR)) continue;
                matchedBitrate = true;
            }
            catch (NumberFormatException nfe) {
                String queryValueLC = queryValue.toLowerCase(Locale.US);
                String replyDocValueLC = I18NConvert.instance().getNorm(replyDocValue);
                if (!replyDocValueLC.startsWith(queryValueLC)) continue;
                ++matchCount;
            }
        }
        double sizeD = size;
        double matchCountD = matchCount;
        double nullCountD = nullCount;
        if (size > 1) {
            if (matchedBitrate) {
                sizeD -= 1.0;
                matchCountD -= 1.0;
                --matchCount;
            }
            if ((nullCountD + matchCountD) / sizeD < 0.9) {
                return false;
            }
            return matchCount > 0;
        }
        if (size == 1) {
            return !(matchCountD / sizeD < 1.0);
        }
        return false;
    }

    public static boolean isMP3File(String in) {
        boolean retVal = false;
        if ((in = in.toLowerCase(Locale.US)).endsWith(".mp3")) {
            retVal = true;
        }
        return retVal;
    }

    public static boolean isMP3File(File in) {
        boolean retVal = LimeXMLUtils.isMP3File(in.getName());
        return retVal;
    }

    public static Response[] getResponseArray(List xmlDocuments) {
        Response[] responseArray = new Response[xmlDocuments.size()];
        int i = 0;
        Iterator iterator = xmlDocuments.iterator();
        while (iterator.hasNext() && i < responseArray.length) {
            String responseString = "";
            try {
                responseString = ((LimeXMLDocument)iterator.next()).getXMLString();
            }
            catch (SchemaNotFoundException snfe) {
                ErrorService.error(snfe);
            }
            responseArray[i] = LimeXMLUtils.createResponse(responseString);
            ++i;
        }
        return responseArray;
    }

    public static String encodeXML(String inData) {
        if (inData == null) {
            return null;
        }
        if (inData.indexOf(38) == -1 && inData.indexOf(60) == -1 && inData.indexOf(62) == -1 && inData.indexOf(39) == -1 && inData.indexOf(34) == -1) {
            return inData;
        }
        int length = inData.length();
        StringBuffer buffer = new StringBuffer(2 * length);
        int i = 0;
        while (i < length) {
            char charToCompare = inData.charAt(i);
            if (charToCompare == '&') {
                buffer.append("&amp;");
            } else if (charToCompare == '<') {
                buffer.append("&lt;");
            } else if (charToCompare == '>') {
                buffer.append("&gt;");
            } else if (charToCompare == '\"') {
                buffer.append("&quot;");
            } else if (charToCompare == '\'') {
                buffer.append("&apos;");
            } else {
                buffer.append(charToCompare);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String capitalizeFirst(String str) {
        String first = str.substring(0, 1).toUpperCase(Locale.US);
        String last = str.substring(1);
        String retStr = first + last;
        return retStr.replace('_', ' ');
    }

    public static String processColName(String colName) {
        int index;
        if (colName.endsWith("__")) {
            colName = colName.substring(0, colName.lastIndexOf("__"));
        }
        if ((index = colName.lastIndexOf("__")) == -1) {
            return colName;
        }
        return LimeXMLUtils.capitalizeFirst(colName.substring(index += "__".length()));
    }

    public static byte[] compress(byte[] data) {
        byte[] compressedData = null;
        if (LimeXMLUtils.shouldCompress(data)) {
            compressedData = LimeXMLUtils.compressZLIB(data);
        }
        byte[] retBytes = null;
        if (compressedData != null) {
            retBytes = new byte[COMPRESS_HEADER_ZLIB.length() + compressedData.length];
            System.arraycopy(COMPRESS_HEADER_ZLIB.getBytes(), 0, retBytes, 0, COMPRESS_HEADER_ZLIB.length());
            System.arraycopy(compressedData, 0, retBytes, COMPRESS_HEADER_ZLIB.length(), compressedData.length);
        } else {
            retBytes = new byte[COMPRESS_HEADER_NONE.length() + data.length];
            System.arraycopy(COMPRESS_HEADER_NONE.getBytes(), 0, retBytes, 0, COMPRESS_HEADER_NONE.length());
            System.arraycopy(data, 0, retBytes, COMPRESS_HEADER_NONE.length(), data.length);
        }
        return retBytes;
    }

    private static boolean shouldCompress(byte[] data) {
        return data.length >= 1000;
    }

    private static byte[] compressZLIB(byte[] data) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DeflaterOutputStream gos = new DeflaterOutputStream(baos);
            gos.write(data, 0, data.length);
            ((FilterOutputStream)gos).flush();
            gos.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            Assert.that(false, "Couldn't write to byte stream");
            return null;
        }
    }

    public static byte[] uncompress(byte[] data) throws IOException {
        byte[] retBytes = new byte[]{};
        String headerFragment = new String(data, 0, C_HEADER_BEGIN.length());
        if (headerFragment.equals(C_HEADER_BEGIN)) {
            boolean found = false;
            int i = 0;
            while (i < data.length && !found) {
                if (data[i] == 125) {
                    found = true;
                }
                ++i;
            }
            headerFragment = new String(data, 1, i - 1 - 1);
            int comp = LimeXMLUtils.getCompressionType(headerFragment);
            if (comp == 0) {
                retBytes = new byte[data.length - (headerFragment.length() + 2)];
                System.arraycopy(data, i, retBytes, 0, data.length - (headerFragment.length() + 2));
            } else if (comp == 1) {
                retBytes = new byte[data.length - COMPRESS_HEADER_GZIP.length()];
                System.arraycopy(data, COMPRESS_HEADER_GZIP.length(), retBytes, 0, data.length - COMPRESS_HEADER_GZIP.length());
                retBytes = LimeXMLUtils.uncompressGZIP(retBytes);
            } else if (comp == 2) {
                retBytes = new byte[data.length - COMPRESS_HEADER_ZLIB.length()];
                System.arraycopy(data, COMPRESS_HEADER_ZLIB.length(), retBytes, 0, data.length - COMPRESS_HEADER_ZLIB.length());
                retBytes = LimeXMLUtils.uncompressZLIB(retBytes);
            }
        } else {
            return data;
        }
        return retBytes;
    }

    private static int getCompressionType(String header) {
        String s = header.trim();
        if (s.equals("") || s.equalsIgnoreCase(C_HEADER_NONE_VAL)) {
            return 0;
        }
        if (s.equalsIgnoreCase(C_HEADER_GZIP_VAL)) {
            return 1;
        }
        if (s.equalsIgnoreCase(C_HEADER_ZLIB_VAL)) {
            return 2;
        }
        return -1;
    }

    private static byte[] uncompressGZIP(byte[] data) throws IOException {
        int b;
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        GZIPInputStream gis = new GZIPInputStream(bais);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((b = gis.read()) != -1) {
            baos.write(b);
        }
        return baos.toByteArray();
    }

    private static byte[] uncompressZLIB(byte[] data) throws IOException {
        int b;
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        InflaterInputStream gis = new InflaterInputStream(bais);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((b = gis.read()) != -1) {
            baos.write(b);
        }
        return baos.toByteArray();
    }

    private static void clearHashBytes(byte[] hashBytes) {
        int i = 0;
        while (i < 100) {
            hashBytes[i] = 0;
            ++i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] hashFile(File toHash) throws IOException {
        byte[] retBytes = null;
        FileInputStream fis = null;
        byte[] hashBytes = new byte[100];
        try {
            fis = new FileInputStream(toHash);
            MessageDigest md = null;
            try {
                md = MessageDigest.getInstance("SHA");
            }
            catch (NoSuchAlgorithmException nsae) {
                Assert.that(false, "no sha algorithm.");
            }
            long fileLength = toHash.length();
            if (fileLength < 300L) {
                int numRead = 0;
                do {
                    LimeXMLUtils.clearHashBytes(hashBytes);
                    numRead = fis.read(hashBytes);
                    md.update(hashBytes);
                    if (toHash.length() == fileLength) continue;
                    throw new IOException("invalid length");
                } while (numRead == 100);
            } else {
                long thirds = fileLength / 3L;
                LimeXMLUtils.clearHashBytes(hashBytes);
                fis.read(hashBytes);
                md.update(hashBytes);
                if (toHash.length() != fileLength) {
                    throw new IOException("invalid length");
                }
                LimeXMLUtils.clearHashBytes(hashBytes);
                fis.skip(thirds - 100L);
                fis.read(hashBytes);
                md.update(hashBytes);
                if (toHash.length() != fileLength) {
                    throw new IOException("invalid length");
                }
                LimeXMLUtils.clearHashBytes(hashBytes);
                fis.skip(toHash.length() - (thirds + 100L) - 100L);
                fis.read(hashBytes);
                md.update(hashBytes);
                if (toHash.length() != fileLength) {
                    throw new IOException("invalid length");
                }
            }
            retBytes = md.digest();
            Object var10_9 = null;
            if (fis == null) return retBytes;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (fis == null) throw throwable;
            fis.close();
            throw throwable;
        }
        fis.close();
        return retBytes;
    }

    public static boolean notValidXML(String inputStr) {
        return inputStr == null || inputStr.trim().equals("") || !inputStr.startsWith("<?xml version=\"1.0\"?>");
    }
}

