/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.xml.LimeXMLSchemaFieldExtractor;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.limegroup.gnutella.xml.SchemaFieldInfo;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LimeXMLSchema {
    private final List _canonicalizedFields;
    private final String _schemaURI;
    private final String _description;

    public LimeXMLSchema(File schemaFile) throws IOException {
        this(LimeXMLUtils.getInputSource(schemaFile));
    }

    public LimeXMLSchema(InputSource inputSource) throws IOException {
        Document document = this.getDocument(inputSource);
        this._canonicalizedFields = new LimeXMLSchemaFieldExtractor().getFields(document);
        this._schemaURI = LimeXMLSchema.retrieveSchemaURI(document);
        this._description = LimeXMLSchema.getDisplayString(this._schemaURI);
    }

    private Document getDocument(InputSource schemaInputSource) throws IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IOException("" + e);
        }
        documentBuilder.setEntityResolver(new Resolver(schemaInputSource));
        Document document = null;
        try {
            document = documentBuilder.parse(schemaInputSource);
        }
        catch (SAXException e) {
            throw new IOException("" + e);
        }
        return document;
    }

    private static String retrieveSchemaURI(Document document) {
        Element root = document.getDocumentElement();
        NamedNodeMap nnm = root.getAttributes();
        Node targetNameSpaceAttribute = nnm.getNamedItem("targetNamespace");
        if (targetNameSpaceAttribute != null) {
            return targetNameSpaceAttribute.getNodeValue();
        }
        return "";
    }

    private void printNode(Node n) {
        if (n.getNodeType() == 1) {
            System.out.print("node = " + n.getNodeName() + " ");
            NamedNodeMap nnm = n.getAttributes();
            Node name = nnm.getNamedItem("name");
            if (name != null) {
                System.out.print(name + "");
            }
            System.out.println("");
            NodeList children = n.getChildNodes();
            int numChildren = children.getLength();
            int i = 0;
            while (i < numChildren) {
                Node child = children.item(i);
                this.printNode(child);
                ++i;
            }
        }
    }

    public String getSchemaURI() {
        return this._schemaURI;
    }

    public List getCanonicalizedFields() {
        return Collections.unmodifiableList(this._canonicalizedFields);
    }

    public List getEnumerationFields() {
        LinkedList enumerationFields = new LinkedList();
        Iterator iterator = this._canonicalizedFields.iterator();
        while (iterator.hasNext()) {
            SchemaFieldInfo schemaFieldInfo = (SchemaFieldInfo)iterator.next();
            if (schemaFieldInfo.getEnumerationList() == null) continue;
            enumerationFields.add(schemaFieldInfo);
        }
        return enumerationFields;
    }

    public Map getDefaultFieldEnumerativeValueMap() {
        HashMap fieldEnumerativeValueMap = new HashMap();
        Iterator iterator = this._canonicalizedFields.iterator();
        while (iterator.hasNext()) {
            SchemaFieldInfo schemaFieldInfo = (SchemaFieldInfo)iterator.next();
            Map enumerativeValueMap = schemaFieldInfo.getDefaultEnumerativeValueMap();
            if (enumerativeValueMap == null) continue;
            fieldEnumerativeValueMap.put(schemaFieldInfo.getCanonicalizedFieldName(), enumerativeValueMap);
        }
        return fieldEnumerativeValueMap;
    }

    public String[] getCanonicalizedFieldNames() {
        List canonicalizedFields = this.getCanonicalizedFields();
        String[] fieldNames = new String[canonicalizedFields.size()];
        Iterator iterator = canonicalizedFields.iterator();
        int i = 0;
        while (i < fieldNames.length) {
            fieldNames[i] = ((SchemaFieldInfo)iterator.next()).getCanonicalizedFieldName();
            ++i;
        }
        return fieldNames;
    }

    public String getDescription() {
        return this._description;
    }

    public static String getDisplayString(String schemaURI) {
        int start = schemaURI.lastIndexOf("/");
        int end = schemaURI.lastIndexOf(".");
        String schemaStr = start == -1 || end == -1 ? schemaURI : schemaURI.substring(start + 1, end);
        return schemaStr;
    }

    private static final class Resolver
    implements EntityResolver {
        private InputSource schema;

        public Resolver(InputSource s) {
            this.schema = s;
        }

        public InputSource resolveEntity(String publicId, String systemId) {
            return this.schema;
        }
    }
}

