/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.util.CommonUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Properties;

public class LimeXMLProperties {
    public static final long DEFAULT_NONFILE_INDEX = 0xFFFFFFFFL;
    private Properties _properties = new Properties();
    private static LimeXMLProperties _instance = new LimeXMLProperties();
    private static final String XML_PROPS_FILENAME = "xml.props";
    private static final String XML_SCHEMA_DIR = "XML_SCHEMA_DIR";
    private static final String XML_IMAGES_DIR = "XML_IMAGES_DIR";
    private static final String XML_DOCS_DIR = "XML_DOCS_DIR";
    private static final String XML_DISPLAY_PROPS_DIR = "XML_DISPLAY_PROPS_DIR";
    private static final String XML_SCHEMA_DIR_DEF = "xml" + File.separator + "schemas" + File.separator;
    private static final String XML_IMAGES_DIR_DEF = "xml" + File.separator + "misc" + File.separator;
    private static final String XML_DOCS_DIR_DEF = "xml" + File.separator + "data" + File.separator;
    private static final String XML_DISPLAY_PROPS_DIR_DEF = "xml" + File.separator + "display" + File.separator;
    private static final String USER_MAP_FILE = "USER_MAP_FILE";
    private static final String USER_MAP_FILE_DEF = "UserMap.dat";

    private LimeXMLProperties() {
        this.loadProperties();
    }

    protected void loadProperties() {
        try {
            this._properties.load(new FileInputStream(this.getPath() + XML_PROPS_FILENAME));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static LimeXMLProperties instance() {
        return _instance;
    }

    public String getXMLSchemaDir() {
        String xmlSchemaDirRel = this._properties.getProperty(XML_SCHEMA_DIR, XML_SCHEMA_DIR_DEF);
        return this.getPath() + xmlSchemaDirRel;
    }

    public String getXMLImagesDir() {
        String xmlImagesDirRel = this._properties.getProperty(XML_IMAGES_DIR, XML_IMAGES_DIR_DEF);
        return this.getPath() + xmlImagesDirRel;
    }

    public String getXMLDocsDir() {
        String xmlDocsDirRel = this._properties.getProperty(XML_DOCS_DIR, XML_DOCS_DIR_DEF);
        return this.getPath() + xmlDocsDirRel;
    }

    public String getXMLDisplayPropsDir() {
        String xmlDisplayPropsDirRel = this._properties.getProperty(XML_DISPLAY_PROPS_DIR, XML_DISPLAY_PROPS_DIR_DEF);
        return this.getPath() + xmlDisplayPropsDirRel;
    }

    public File[] getAllXMLSchemaFiles() {
        File dir = new File(this.getXMLSchemaDir());
        String[] fileNames = dir.list(new FilenameFilter(){

            public boolean accept(File directory, String name) {
                return name.endsWith(".xsd");
            }
        });
        if (fileNames == null || fileNames.length == 0) {
            return new File[0];
        }
        int z = fileNames.length;
        File[] files = new File[z];
        int i = 0;
        while (i < z) {
            files[i] = new File(dir, fileNames[i]);
            ++i;
        }
        return files;
    }

    public String getUserMapFile() {
        String userMapFile = this._properties.getProperty(USER_MAP_FILE, USER_MAP_FILE_DEF);
        return this.getPath() + userMapFile;
    }

    public String getPath() {
        String limeHome = System.getProperty("LIME_HOME");
        if (limeHome == null || limeHome.trim().equals("")) {
            File libDir = CommonUtils.getUserSettingsDir();
            String stringPath = libDir.getAbsolutePath();
            if (!stringPath.endsWith(File.separator)) {
                stringPath = stringPath + File.separator;
            }
            return stringPath;
        }
        if (!limeHome.endsWith("/") && !limeHome.endsWith("\\")) {
            limeHome = limeHome + File.separator;
        }
        return limeHome + "lib" + File.separator;
    }
}

