/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.util.ManagedThread;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Vector;

public class ProcessingQueue {
    private final List QUEUE = new Vector();
    private final String NAME;
    private final boolean MANAGED;
    private Thread _runner = null;

    public ProcessingQueue(String name) {
        this(name, true);
    }

    public ProcessingQueue(String name, boolean managed) {
        this.NAME = name;
        this.MANAGED = managed;
    }

    public synchronized void add(Runnable r) {
        this.QUEUE.add(r);
        this.notify();
        if (this._runner == null) {
            this.startRunner();
        }
    }

    private synchronized void startRunner() {
        this._runner = this.MANAGED ? new ManagedThread(new Processor(), this.NAME) : new Thread((Runnable)new Processor(), this.NAME);
        this._runner.setDaemon(true);
        this._runner.start();
    }

    private class Processor
    implements Runnable {
        private Processor() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            ProcessingQueue processingQueue;
            try {
                while (true) {
                    if (ProcessingQueue.this.QUEUE.size() <= 0) {
                        ProcessingQueue processingQueue2 = ProcessingQueue.this;
                        synchronized (processingQueue2) {
                            if (!ProcessingQueue.this.QUEUE.isEmpty()) {
                                continue;
                            }
                        }
                    } else {
                        Runnable next = (Runnable)ProcessingQueue.this.QUEUE.remove(0);
                        next.run();
                        continue;
                    }
                    {
                        try {
                            ProcessingQueue.this.wait(5000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (ProcessingQueue.this.QUEUE.isEmpty()) break;
                    }
                }
                {
                }
                Object var5_3 = null;
                processingQueue = ProcessingQueue.this;
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                ProcessingQueue processingQueue3 = ProcessingQueue.this;
                synchronized (processingQueue3) {
                    if (!ProcessingQueue.this.QUEUE.isEmpty()) {
                        ProcessingQueue.this.startRunner();
                    } else {
                        ProcessingQueue.this._runner = null;
                    }
                    throw throwable;
                }
            }
            synchronized (processingQueue) {
                if (!ProcessingQueue.this.QUEUE.isEmpty()) {
                    ProcessingQueue.this.startRunner();
                } else {
                    ProcessingQueue.this._runner = null;
                }
                return;
            }
        }
    }
}

