/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Map;

public class ForgetfulHashMap
extends HashMap {
    private Object[] queue;
    private int next;
    private int n;

    public ForgetfulHashMap(int size) {
        if (size < 1) {
            throw new IllegalArgumentException();
        }
        this.queue = new Object[size];
        this.next = 0;
        this.n = size;
    }

    public Object put(Object key, Object value) {
        Object ret = super.put(key, value);
        if (this.queue[this.next] != null) {
            super.remove(this.queue[this.next]);
        }
        this.queue[this.next] = key;
        ++this.next;
        if (this.next >= this.n) {
            this.next = 0;
        }
        return ret;
    }

    public void putAll(Map t) {
        Iterator iter = t.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            this.put(key, t.get(key));
        }
    }
}

