/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.Assert;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Comparator;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.SortedSet;
import com.sun.java.util.collections.TreeSet;

public class FixedSizeSortedSet {
    private SortedSet _sortedSet;
    private Map _map;
    private int _maxSize;

    public FixedSizeSortedSet() {
        this(50);
    }

    public FixedSizeSortedSet(int size) {
        this._maxSize = size;
        this._sortedSet = new TreeSet();
        this._map = new HashMap();
    }

    public FixedSizeSortedSet(Comparator c) {
        this(c, 50);
    }

    public FixedSizeSortedSet(Comparator c, int maxSize) {
        this._maxSize = maxSize;
        this._sortedSet = new TreeSet(c);
        this._map = new HashMap();
    }

    public Object clone() {
        FixedSizeSortedSet ret = new FixedSizeSortedSet(this._maxSize);
        ret._sortedSet = (SortedSet)((TreeSet)this._sortedSet).clone();
        ret._map = (Map)((HashMap)this._map).clone();
        return ret;
    }

    public boolean add(Object o) {
        if (o == null) {
            return false;
        }
        Object val = this._map.get(o);
        if (val != null) {
            boolean removed = this._sortedSet.remove(val);
            if (!removed) {
                this.invariantsBroken(o, val);
            }
            this._sortedSet.add(o);
            this._map.put(o, o);
            return false;
        }
        if (this._map.size() >= this._maxSize) {
            boolean removed;
            Object highest = this._sortedSet.last();
            boolean bl = removed = this._map.remove(highest) != null;
            if (!removed) {
                this.invariantsBroken(highest, highest);
            }
            if (!(removed = this._sortedSet.remove(highest))) {
                this.invariantsBroken(highest, highest);
            }
        }
        this._map.put(o, o);
        boolean added = this._sortedSet.add(o);
        if (!added) {
            this.invariantsBroken(o, o);
        }
        return true;
    }

    public boolean addAll(Collection c) {
        boolean ret = false;
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            ret |= this.add(iter.next());
        }
        return ret;
    }

    public Object get(Object o) {
        return this._map.get(o);
    }

    public Object last() {
        return this._sortedSet.last();
    }

    public Object first() {
        return this._sortedSet.first();
    }

    public boolean remove(Object o) {
        boolean b2;
        Object obj = this._map.remove(o);
        boolean b1 = obj != null;
        if (b1 != (b2 = this._sortedSet.remove(obj))) {
            this.invariantsBroken(o, obj);
        }
        return b1;
    }

    public void clear() {
        this._sortedSet.clear();
        this._map.clear();
    }

    public boolean contains(Object o) {
        return this._map.get(o) != null;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof FixedSizeSortedSet)) {
            return false;
        }
        FixedSizeSortedSet other = (FixedSizeSortedSet)o;
        return this._sortedSet.equals(other._sortedSet) && this._map.equals(other._map);
    }

    public int hashCode() {
        return this._sortedSet.hashCode() + 37 * this._map.hashCode();
    }

    public boolean isEmpty() {
        Assert.that(this._sortedSet.isEmpty() == this._map.isEmpty());
        return this._sortedSet.isEmpty();
    }

    public Iterator iterator() {
        return this._sortedSet.iterator();
    }

    public int size() {
        if (this._sortedSet.size() != this._map.size()) {
            this.invariantsBroken(null, null);
        }
        return this._sortedSet.size();
    }

    private void invariantsBroken(Object key, Object value) {
        String mapBefore = this._map.toString();
        String setBefore = this._sortedSet.toString();
        String mapSizeBefore = "" + this._map.size();
        String setSizeBefore = "" + this._sortedSet.size();
        this.stabilize();
        String mapAfter = this._map.toString();
        String setAfter = this._sortedSet.toString();
        String mapSizeAfter = "" + this._map.size();
        String setSizeAfter = "" + this._sortedSet.size();
        Assert.silent(false, "key: " + key + ", value: " + value + "\nbefore stabilization: " + "\nsize of map: " + mapSizeBefore + ", set: " + setSizeBefore + "\nmap: " + mapBefore + "\nset: " + setBefore + "\nafter stabilization: " + "\nsize of map " + mapSizeAfter + ", set: " + setSizeAfter + "\nmap: " + mapAfter + "\nset: " + setAfter);
    }

    private void stabilize() {
        Iterator iter = this._map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            if (this._sortedSet.contains(entry.getValue())) continue;
            iter.remove();
        }
        Collection values = this._map.values();
        Iterator iter2 = this._sortedSet.iterator();
        while (iter2.hasNext()) {
            Object o = iter2.next();
            if (values.contains(o)) continue;
            iter2.remove();
        }
    }
}

