/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.util.UnmodifiableIterator;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.NoSuchElementException;

public class DoublyLinkedList {
    private ListElement start = new ListElement(null);
    private ListElement last;

    public DoublyLinkedList() {
        this.start.next = this.last = new ListElement(null);
        this.last.prev = this.start;
    }

    public ListElement addLast(Object value) {
        ListElement element = new ListElement(value);
        element.prev = this.last.prev;
        element.next = this.last;
        element.prev.next = element;
        this.last.prev = element;
        return element;
    }

    public ListElement removeFirst() {
        if (this.start.next == this.last) {
            return null;
        }
        ListElement removed = this.start.next;
        this.start.next = this.start.next.next;
        this.start.next.prev = this.start;
        return removed;
    }

    public void remove(ListElement element) {
        if (element == null || element.prev == null || element.next == null) {
            return;
        }
        if (element == this.start || element == this.last) {
            return;
        }
        element.prev.next = element.next;
        element.next.prev = element.prev;
    }

    public void clear() {
        this.start.next = this.last;
        this.last.prev = this.start;
    }

    public Iterator iterator() {
        return new DoublyLinkedListIterator();
    }

    public boolean contains(ListElement e) {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            ListElement e2 = (ListElement)iter.next();
            if (!e.equals(e2)) continue;
            return true;
        }
        return false;
    }

    public static class ListElement {
        Object key;
        ListElement prev;
        ListElement next;

        ListElement(Object key) {
            this.key = key;
            this.prev = null;
            this.next = null;
        }

        public Object getKey() {
            return this.key;
        }
    }

    private class DoublyLinkedListIterator
    extends UnmodifiableIterator {
        private ListElement next;

        private DoublyLinkedListIterator() {
            this.next = ((DoublyLinkedList)DoublyLinkedList.this).start.next;
        }

        public boolean hasNext() {
            return this.next != DoublyLinkedList.this.last;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ListElement ret = this.next;
            this.next = this.next.next;
            return ret;
        }
    }
}

