/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.util.UnmodifiableIterator;
import com.sun.java.util.collections.Comparable;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.NoSuchElementException;

public class BinaryHeap {
    private int currentSize;
    private Comparable[] array;
    private int maxSize;
    private boolean resizable = false;

    public BinaryHeap(int maxSize) {
        this(maxSize, false);
    }

    public BinaryHeap(int maxSize, boolean resizable) {
        this.resizable = resizable;
        this.currentSize = 0;
        this.maxSize = maxSize;
        this.array = new Comparable[maxSize + 1];
    }

    public void clear() {
        this.currentSize = 0;
    }

    public BinaryHeap(Comparable[] array) {
        this.array = array;
        this.maxSize = this.currentSize = array.length - 1;
        this.buildHeap();
    }

    private boolean resize() {
        if (!this.isFull()) {
            return false;
        }
        if (!this.resizable) {
            return false;
        }
        this.maxSize = this.currentSize * 2;
        Comparable[] newArray = new Comparable[1 + this.maxSize];
        System.arraycopy(this.array, 1, newArray, 1, this.currentSize);
        this.array = newArray;
        return true;
    }

    private void heapify(int i) {
        int l = 2 * i;
        int r = 2 * i + 1;
        int largest = l <= this.currentSize && this.array[l].compareTo(this.array[i]) > 0 ? l : i;
        if (r <= this.currentSize && this.array[r].compareTo(this.array[largest]) > 0) {
            largest = r;
        }
        if (largest != i) {
            this.swap(i, largest);
            this.heapify(largest);
        }
    }

    private void buildHeap() {
        int i = this.currentSize / 2;
        while (i >= 1) {
            this.heapify(i);
            --i;
        }
    }

    private void swap(int i, int j) {
        Comparable temp = this.array[i];
        this.array[i] = this.array[j];
        this.array[j] = temp;
    }

    public Comparable insert(Comparable x) {
        this.resize();
        Comparable ret = null;
        if (this.currentSize < this.maxSize) {
            ++this.currentSize;
        } else {
            ret = this.array[this.currentSize];
        }
        int i = this.currentSize;
        while (i > 1 && x.compareTo(this.array[i / 2]) > 0) {
            this.array[i] = this.array[i / 2];
            i /= 2;
        }
        this.array[i] = x;
        return ret;
    }

    public Comparable getMax() throws NoSuchElementException {
        if (this.currentSize < 1) {
            throw new NoSuchElementException();
        }
        return this.array[1];
    }

    public Comparable extractMax() throws NoSuchElementException {
        if (this.currentSize < 1) {
            throw new NoSuchElementException();
        }
        Comparable max = this.array[1];
        this.array[1] = this.array[this.currentSize--];
        this.heapify(1);
        return max;
    }

    public Iterator iterator() {
        return new BinaryHeapIterator();
    }

    public int size() {
        return this.currentSize;
    }

    public int capacity() {
        return this.maxSize;
    }

    public boolean isFull() {
        return this.currentSize == this.maxSize;
    }

    public boolean isEmpty() {
        return this.currentSize == 0;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer("[");
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            ret.append(iter.next().toString());
            ret.append(", ");
        }
        ret.append("]");
        return ret.toString();
    }

    class BinaryHeapIterator
    extends UnmodifiableIterator {
        int next = 1;

        BinaryHeapIterator() {
        }

        public boolean hasNext() {
            return this.next <= BinaryHeap.this.currentSize;
        }

        public Object next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return BinaryHeap.this.array[this.next++];
        }
    }
}

