/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderValueCollection;
import com.limegroup.gnutella.http.HTTPMessage;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.util.CommonUtils;
import com.sun.java.util.collections.Set;
import java.io.IOException;
import java.io.OutputStream;

public class UnavailableRangeUploadState
implements HTTPMessage {
    private final FileDesc FILE_DESC;
    private final HTTPUploader UPLOADER;
    private static final String INACTIVE_RETRY_AFTER = "3600";

    public UnavailableRangeUploadState(HTTPUploader uploader) {
        this.UPLOADER = uploader;
        this.FILE_DESC = this.UPLOADER.getFileDesc();
    }

    public void writeMessageHeaders(OutputStream ostream) throws IOException {
        String str = "HTTP/1.1 416 Requested Range Unavailable\r\n";
        ostream.write(str.getBytes());
        str = "Server: " + CommonUtils.getHttpServer() + "\r\n";
        ostream.write(str.getBytes());
        str = "Content-Type: text/plain\r\n";
        ostream.write(str.getBytes());
        str = "Content-Length: 0\r\n";
        ostream.write(str.getBytes());
        if (this.FILE_DESC != null) {
            URN sha1 = this.FILE_DESC.getSHA1Urn();
            if (sha1 != null) {
                HTTPUtils.writeHeader(HTTPHeaderName.GNUTELLA_CONTENT_URN, (HTTPHeaderValue)sha1, ostream);
                Set alts = this.UPLOADER.getNextSetOfAltsToSend();
                if (alts.size() > 0) {
                    HTTPUtils.writeHeader(HTTPHeaderName.ALT_LOCATION, (HTTPHeaderValue)new HTTPHeaderValueCollection(alts), ostream);
                }
            }
            if (this.FILE_DESC instanceof IncompleteFileDesc) {
                IncompleteFileDesc ifd = (IncompleteFileDesc)this.FILE_DESC;
                HTTPUtils.writeHeader(HTTPHeaderName.AVAILABLE_RANGES, (HTTPHeaderValue)ifd, ostream);
                if (!ifd.isActivelyDownloading()) {
                    HTTPUtils.writeHeader(HTTPHeaderName.RETRY_AFTER, INACTIVE_RETRY_AFTER, ostream);
                }
            }
        }
        str = "\r\n";
        ostream.write(str.getBytes());
    }

    public void writeMessageBody(OutputStream ostream) throws IOException {
    }

    public boolean getCloseConnection() {
        return false;
    }
}

