/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.updates;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HttpClientManager;
import com.limegroup.gnutella.updates.UpdateFileParser;
import com.limegroup.gnutella.updates.UpdateMessageVerifier;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.ManagedThread;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Random;
import java.util.StringTokenizer;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public class UpdateManager {
    private static final Log LOG = LogFactory.getLog(class$com$limegroup$gnutella$updates$UpdateManager == null ? (class$com$limegroup$gnutella$updates$UpdateManager = UpdateManager.class$("com.limegroup.gnutella.updates.UpdateManager")) : class$com$limegroup$gnutella$updates$UpdateManager);
    private String latestVersion;
    private String message;
    private boolean usesLocale;
    private static long DELAY = 25200000L;
    private static UpdateManager INSTANCE = null;
    public static final String SPECIAL_VERSION = "@version@";
    private boolean isValid;
    static /* synthetic */ Class class$com$limegroup$gnutella$updates$UpdateManager;

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private UpdateManager() {
        block18: {
            block17: {
                super();
                this.message = "";
                raf = null;
                try {
                    try {
                        file = new File(CommonUtils.getUserSettingsDir(), "update.xml");
                        raf = new RandomAccessFile(file, "r");
                        content = new byte[(int)raf.length()];
                        raf.readFully(content);
                        verifier = new UpdateMessageVerifier(content, true);
                        verified = false;
                        try {
                            verified = verifier.verifySource();
                        }
                        catch (ClassCastException ccx) {
                            verified = false;
                        }
                        if (!verified) {
                            this.latestVersion = CommonUtils.getLimeWireVersion();
                            var9_11 = null;
                            if (raf == null) return;
                            break block17;
                        }
                        xml = new String(verifier.getMessageBytes(), "UTF-8");
                        parser = new UpdateFileParser(xml);
                        this.latestVersion = parser.getVersion();
                        this.message = parser.getMessage();
                        this.usesLocale = parser.usesLocale();
                        this.isValid = true;
                        break block18;
                    }
                    catch (SAXException sax) {
                        this.latestVersion = CommonUtils.getLimeWireVersion();
                        this.isValid = false;
                        var9_13 = null;
                        if (raf == null) return;
                        try {
                            raf.close();
                            return;
                        }
                        catch (IOException ignored) {
                            return;
                        }
                    }
                    catch (IOException iox) {
                        this.latestVersion = CommonUtils.getLimeWireVersion();
                        this.isValid = false;
                        var9_14 = null;
                        if (raf == null) return;
                        try {}
                        catch (IOException ignored) {
                            return;
                        }
                        raf.close();
                        return;
                    }
                    catch (VerifyError error) {
                        this.latestVersion = CommonUtils.getLimeWireVersion();
                        this.isValid = false;
                        ErrorService.error(error);
                        var9_15 = null;
                        if (raf == null) return;
                        try {}
                        catch (IOException ignored) {
                            return;
                        }
                        raf.close();
                        return;
                    }
                }
                catch (Throwable var8_24) {
                    var9_16 = null;
                    if (raf == null) throw var8_24;
                    ** try [egrp 3[TRYBLOCK] [5 : 236->243)] { 
lbl69:
                    // 1 sources

                    raf.close();
                    throw var8_24;
lbl71:
                    // 1 sources

                    catch (IOException ignored) {
                        // empty catch block
                    }
                    throw var8_24;
                }
            }
            ** try [egrp 3[TRYBLOCK] [5 : 236->243)] { 
lbl76:
            // 1 sources

            raf.close();
            return;
lbl78:
            // 1 sources

            catch (IOException ignored) {
                // empty catch block
            }
            return;
        }
        var9_12 = null;
        if (raf == null) return;
        try {}
        catch (IOException ignored) {}
        raf.close();
        return;
    }

    public static synchronized UpdateManager instance() {
        if (INSTANCE == null) {
            INSTANCE = new UpdateManager();
        }
        return INSTANCE;
    }

    public synchronized String getVersion() {
        Assert.that(this.latestVersion != null, "version not initilaized");
        return this.latestVersion;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public boolean displayUpdate() {
        String myVersion = CommonUtils.getLimeWireVersion();
        if (this.latestVersion.equals(SPECIAL_VERSION)) {
            return false;
        }
        if (myVersion.equalsIgnoreCase(this.latestVersion)) {
            return false;
        }
        if (!UpdateManager.isGreaterVersion(this.latestVersion, myVersion)) {
            return false;
        }
        String guiMessage = this.latestVersion + ". " + this.message;
        RouterService.getCallback().notifyUserAboutUpdate(guiMessage, CommonUtils.isPro(), this.usesLocale);
        return true;
    }

    public void checkAndUpdate(Connection connection) {
        String nv = connection.getVersion();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Update check: myVersion: " + this.latestVersion + ", theirs: " + nv);
        }
        String myVersion = null;
        myVersion = this.latestVersion.equals(SPECIAL_VERSION) ? CommonUtils.getLimeWireVersion() : this.latestVersion;
        if (!UpdateManager.isGreaterVersion(nv, myVersion)) {
            return;
        }
        if (nv.equals(SPECIAL_VERSION)) {
            return;
        }
        final Connection c = connection;
        final String myversion = myVersion;
        ManagedThread checker = new ManagedThread("UpdateFileRequestor"){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void managedRun() {
                GetMethod get;
                block24: {
                    block25: {
                        block23: {
                            block22: {
                                LOG.trace("Getting update file");
                                String UPDATE = "/update.xml";
                                String ip = c.getAddress();
                                int port = c.getPort();
                                String connectTo = "http://" + ip + ":" + port + "/update.xml";
                                get = new GetMethod(connectTo);
                                get.addRequestHeader("Cache-Control", "no-cache");
                                get.addRequestHeader("User-Agent", CommonUtils.getHttpServer());
                                get.addRequestHeader(HTTPHeaderName.CONNECTION.httpStringValue(), "close");
                                HttpClient client = HttpClientManager.getNewClient();
                                try {
                                    try {
                                        String newVersion;
                                        client.executeMethod(get);
                                        byte[] data = get.getResponseBody();
                                        if (data == null) {
                                            Object var22_9 = null;
                                            if (get == null) return;
                                            get.releaseConnection();
                                            return;
                                        }
                                        UpdateMessageVerifier verifier = new UpdateMessageVerifier(data, false);
                                        boolean verified = false;
                                        try {
                                            verified = verifier.verifySource();
                                        }
                                        catch (ClassCastException ccx) {
                                            verified = false;
                                        }
                                        if (!verified) {
                                            break block22;
                                        }
                                        LOG.trace("Verified file contents");
                                        String xml = new String(verifier.getMessageBytes(), "UTF-8");
                                        UpdateFileParser parser = new UpdateFileParser(xml);
                                        if (LOG.isTraceEnabled()) {
                                            LOG.trace("New version: " + parser.getVersion());
                                        }
                                        if ((newVersion = parser.getVersion()) == null) {
                                            break block23;
                                        }
                                        if (!UpdateManager.isGreaterVersion(newVersion, myversion)) break block24;
                                        LOG.trace("committing new update file");
                                        UpdateManager updateManager = UpdateManager.this;
                                        synchronized (updateManager) {
                                            UpdateManager.this.commitVersionFile(data);
                                            UpdateManager.this.latestVersion = newVersion;
                                            if (LOG.isTraceEnabled()) {
                                                LOG.trace("commited file. Latest is:" + UpdateManager.this.latestVersion);
                                            }
                                        }
                                        String runningVersion = CommonUtils.getLimeWireVersion();
                                        if (!UpdateManager.isGreaterVersion(newVersion, runningVersion)) {
                                            break block25;
                                        }
                                        long makeTime = parser.getTimestamp();
                                        if (makeTime == -1L) {
                                            makeTime = System.currentTimeMillis();
                                        }
                                        if (System.currentTimeMillis() < makeTime + DELAY) {
                                            Random rand = new Random();
                                            long sleep = rand.nextLong() % DELAY;
                                            if (sleep < 0L) {
                                                sleep = -1L * sleep;
                                            }
                                            try {
                                                Thread.sleep(sleep);
                                            }
                                            catch (InterruptedException ignored) {
                                                // empty catch block
                                            }
                                        }
                                        RouterService.getCallback().indicateNewVersion();
                                        break block24;
                                    }
                                    catch (IOException iox) {
                                        Object var22_14 = null;
                                        if (get == null) return;
                                        get.releaseConnection();
                                        return;
                                    }
                                    catch (SAXException sx) {
                                        Object var22_15 = null;
                                        if (get == null) return;
                                        get.releaseConnection();
                                        return;
                                    }
                                    catch (Throwable t) {
                                        ErrorService.error(t);
                                        Object var22_16 = null;
                                        if (get == null) return;
                                        get.releaseConnection();
                                        return;
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var22_17 = null;
                                    if (get == null) throw throwable;
                                    get.releaseConnection();
                                    throw throwable;
                                }
                            }
                            Object var22_10 = null;
                            if (get == null) return;
                            get.releaseConnection();
                            return;
                        }
                        Object var22_11 = null;
                        if (get == null) return;
                        get.releaseConnection();
                        return;
                    }
                    Object var22_12 = null;
                    if (get == null) return;
                    get.releaseConnection();
                    return;
                }
                Object var22_13 = null;
                if (get == null) return;
                get.releaseConnection();
            }
        };
        checker.setDaemon(true);
        checker.start();
    }

    public static boolean isGreaterVersion(String newVer, String oldVer) {
        int n1;
        int o1;
        if (newVer == null && oldVer == null) {
            return false;
        }
        if (newVer == null) {
            return false;
        }
        if (oldVer == null) {
            return true;
        }
        if (newVer.equals(oldVer)) {
            return false;
        }
        if (newVer.equals(SPECIAL_VERSION)) {
            return true;
        }
        if (oldVer.equals(SPECIAL_VERSION)) {
            return false;
        }
        int o2 = -1;
        int n2 = -1;
        try {
            StringTokenizer tokenizer = new StringTokenizer(oldVer, ".");
            if (tokenizer.countTokens() < 2) {
                return false;
            }
            o1 = new Integer(tokenizer.nextToken());
            o2 = new Integer(tokenizer.nextToken());
            tokenizer = new StringTokenizer(newVer, ".");
            if (tokenizer.countTokens() < 2) {
                return false;
            }
            n1 = new Integer(tokenizer.nextToken());
            n2 = new Integer(tokenizer.nextToken());
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        if (n1 > o1) {
            return true;
        }
        return n1 == o1 && n2 > o2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void commitVersionFile(byte[] data) throws IOException {
        boolean deleteOld;
        File nf;
        File f;
        block7: {
            f = new File(CommonUtils.getUserSettingsDir(), "update.xml");
            nf = new File(CommonUtils.getUserSettingsDir(), "update.new");
            RandomAccessFile raf = null;
            try {
                raf = new RandomAccessFile(nf, "rw");
                raf.write(data);
                Object var6_5 = null;
                if (raf == null) break block7;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (raf == null) throw throwable;
                try {
                    raf.close();
                    throw throwable;
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException ignored) {}
            raf.close();
        }
        if (!(deleteOld = f.delete())) {
            nf.delete();
            throw new IOException();
        }
        boolean renamed = nf.renameTo(f);
        if (!renamed) {
            this.isValid = false;
            nf.delete();
            throw new IOException();
        }
        this.isValid = true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

