/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.updates;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import java.io.IOException;
import java.io.StringReader;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class UpdateFileParser {
    private static DOMParser parser = new DOMParser();
    private String newVersion = null;
    private String updateMessage = null;
    private boolean usingLocale = true;
    private long timestamp;

    public UpdateFileParser(String xml) throws SAXException, IOException {
        if (xml == null || xml.equals("")) {
            throw new SAXException("xml is null or empty string");
        }
        this.timestamp = -1L;
        InputSource inputSource = new InputSource(new StringReader(xml));
        Document d = null;
        DOMParser dOMParser = parser;
        synchronized (dOMParser) {
            parser.parse(inputSource);
            d = parser.getDocument();
        }
        if (d == null) {
            throw new SAXException("document is null");
        }
        this.populateValues(d);
    }

    private void populateValues(Document doc) throws IOException {
        Element docElement = doc.getDocumentElement();
        NodeList children = docElement.getChildNodes();
        int len = children.getLength();
        int i = 0;
        while (i < len) {
            Node node = children.item(i);
            String name = node.getNodeName().toLowerCase().trim();
            if (name.equals("version")) {
                this.newVersion = LimeXMLUtils.getText(node.getChildNodes());
            } else if (name.equals("message")) {
                this.updateMessage = this.getLocaleSpecificMessage(node);
            } else if (name.equals("timestamp")) {
                try {
                    this.timestamp = Long.parseLong(LimeXMLUtils.getText(node.getChildNodes()));
                }
                catch (NumberFormatException nfx) {
                    throw new IOException();
                }
            }
            ++i;
        }
    }

    private String getLocaleSpecificMessage(Node node) {
        String locale = ApplicationSettings.LANGUAGE.getValue().toLowerCase();
        String defaultMessage = null;
        String localeMessage = null;
        NodeList children = node.getChildNodes();
        int len = children.getLength();
        int i = 0;
        while (i < len) {
            Node n = children.item(i);
            String name = n.getNodeName().toLowerCase().trim();
            if (name.equals("en")) {
                defaultMessage = LimeXMLUtils.getText(n.getChildNodes());
            } else if (name.equals(locale)) {
                localeMessage = LimeXMLUtils.getText(n.getChildNodes());
            }
            ++i;
        }
        Assert.that(defaultMessage != null, "bad xml file signed by LimeWire");
        if (locale.equals("en")) {
            return defaultMessage;
        }
        if (localeMessage != null) {
            return localeMessage;
        }
        this.usingLocale = false;
        return defaultMessage;
    }

    public String getVersion() {
        return this.newVersion;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean usesLocale() {
        return this.usingLocale;
    }

    public String getMessage() {
        return this.updateMessage;
    }
}

