/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.update.gui;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.update.UpdateManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.Border;

final class ProgressWindow
extends JDialog
implements Runnable {
    private final JProgressBar PROGRESS_BAR = new JProgressBar();
    private final JLabel LABEL = new JLabel();
    private double _downloadSize;
    private double _amountRead;

    public ProgressWindow() {
        ((Component)this).setSize(460, 140);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ProgressWindow.this.cancelUpdate();
            }
        });
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation((screenSize.width - 350) / 2, (screenSize.height - 140) / 2);
        JPanel panel = new JPanel();
        JPanel labelPanel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        labelPanel.setLayout(new BoxLayout(labelPanel, 0));
        Border border = BorderFactory.createEmptyBorder(12, 12, 12, 12);
        panel.setBorder(border);
        this.PROGRESS_BAR.setStringPainted(true);
        this.PROGRESS_BAR.setString("0%");
        this.LABEL.setText("Contacting the LimeWire server...");
        labelPanel.add(this.LABEL);
        labelPanel.add(Box.createHorizontalGlue());
        this._downloadSize = 1000.0;
        this._amountRead = 0.0;
        String[] buttonLabelKeys = new String[]{"UPDATE_CANCEL_BUTTON_LABEL"};
        String[] toolTipKeys = new String[]{"UPDATE_CANCEL_BUTTON_TIP"};
        ActionListener buttonListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    ProgressWindow.this.cancelUpdate();
                }
                catch (Throwable t) {
                    ErrorService.error(t);
                }
            }
        };
        ActionListener[] listeners = new ActionListener[]{buttonListener};
        ButtonRow br = new ButtonRow(buttonLabelKeys, toolTipKeys, listeners);
        panel.add(labelPanel);
        panel.add(Box.createVerticalStrut(6));
        panel.add(this.PROGRESS_BAR);
        panel.add(Box.createVerticalStrut(6));
        panel.add(br);
        this.getContentPane().add(panel);
    }

    public void run() {
        int percent = (int)(100.0 * (this._amountRead / this._downloadSize));
        this.PROGRESS_BAR.setValue(percent);
        this.PROGRESS_BAR.setString(Integer.toString(percent) + "%");
    }

    void setDownloadFile(String fileName) {
        this.LABEL.setText("Downloading: " + fileName + "...");
    }

    void setAmountRead(int amountRead) {
        this._amountRead = amountRead;
    }

    void setDownloadSize(int size) {
        this._downloadSize = size;
    }

    void cancelUpdate() {
        UpdateManager.instance().cancelUpdate();
    }
}

