/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.settings;

import com.limegroup.gnutella.settings.BooleanSetting;
import com.limegroup.gnutella.settings.FileArraySetting;
import com.limegroup.gnutella.settings.FileSetting;
import com.limegroup.gnutella.settings.IntSetting;
import com.limegroup.gnutella.settings.LimeProps;
import com.limegroup.gnutella.settings.StringSetting;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.FileUtils;
import com.sun.java.util.collections.HashSet;
import java.io.File;
import java.io.IOException;

public class SharingSettings
extends LimeProps {
    public static final File DEFAULT_SAVE_DIR = new File(CommonUtils.getUserHomeDir(), "Shared");
    public static final FileSetting DIRECTORY_FOR_SAVING_FILES = (FileSetting)LimeProps.FACTORY.createFileSetting("DIRECTORY_FOR_SAVING_FILES", DEFAULT_SAVE_DIR).setAlwaysSave(true);
    public static final FileSetting INCOMPLETE_DIRECTORY = LimeProps.FACTORY.createFileSetting("INCOMPLETE_DIRECTORY", new File(DIRECTORY_FOR_SAVING_FILES.getValue().getParent(), "Incomplete"));
    public static final FileSetting DOWNLOAD_SNAPSHOT_FILE = LimeProps.FACTORY.createFileSetting("DOWNLOAD_SNAPSHOT_FILE", new File(INCOMPLETE_DIRECTORY.getValue(), "downloads.dat"));
    public static final FileSetting DOWNLOAD_SNAPSHOT_BACKUP_FILE = LimeProps.FACTORY.createFileSetting("DOWNLOAD_SNAPSHOT_BACKUP_FILE", new File(INCOMPLETE_DIRECTORY.getValue(), "downloads.bak"));
    public static final IntSetting INCOMPLETE_PURGE_TIME = LimeProps.FACTORY.createIntSetting("INCOMPLETE_PURGE_TIME", 7);
    public static final BooleanSetting CLEAR_DOWNLOAD = LimeProps.FACTORY.createBooleanSetting("CLEAR_DOWNLOAD", false);
    private static final String DEFAULT_EXTENSIONS_TO_SHARE = "asx;html;htm;xml;txt;pdf;ps;rtf;doc;tex;mp3;mp4;wav;wax;au;aif;aiff;ra;ram;wma;wm;wmv;mp2v;mlv;mpa;mpv2;mid;midi;rmi;aifc;snd;mpg;mpeg;asf;qt;mov;avi;mpe;swf;dcr;gif;jpg;jpeg;jpe;png;tif;tiff;exe;zip;gz;gzip;hqx;tar;tgz;z;rmj;lqt;rar;ace;sit;smi;img;ogg;rm;bin;dmg;jve;nsv;med;mod;7z;iso;lwtp;pmf;m4a;idx;bz2;sea;pf;arc;arj;bz;tbz;mime;taz;ua;toast;lit;rpm;sxw";
    public static final FileArraySetting DIRECTORIES_TO_SHARE = LimeProps.FACTORY.createFileArraySetting("DIRECTORIES_TO_SEARCH_FOR_FILES", new File[0]);
    public static final StringSetting EXTENSIONS_TO_SHARE = LimeProps.FACTORY.createStringSetting("EXTENSIONS_TO_SEARCH_FOR", "asx;html;htm;xml;txt;pdf;ps;rtf;doc;tex;mp3;mp4;wav;wax;au;aif;aiff;ra;ram;wma;wm;wmv;mp2v;mlv;mpa;mpv2;mid;midi;rmi;aifc;snd;mpg;mpeg;asf;qt;mov;avi;mpe;swf;dcr;gif;jpg;jpeg;jpe;png;tif;tiff;exe;zip;gz;gzip;hqx;tar;tgz;z;rmj;lqt;rar;ace;sit;smi;img;ogg;rm;bin;dmg;jve;nsv;med;mod;7z;iso;lwtp;pmf;m4a;idx;bz2;sea;pf;arc;arj;bz;tbz;mime;taz;ua;toast;lit;rpm;sxw");
    public static final IntSetting FREELOADER_ALLOWED = LimeProps.FACTORY.createIntSetting("FREELOADER_ALLOWED", 100);
    public static final IntSetting FREELOADER_FILES = LimeProps.FACTORY.createIntSetting("FREELOADER_FILES", 1);
    public static final IntSetting PERSISTENT_HTTP_CONNECTION_TIMEOUT = LimeProps.FACTORY.createIntSetting("PERSISTENT_HTTP_CONNECTION_TIMEOUT", 15000);
    public static final BooleanSetting CLEAR_UPLOAD = LimeProps.FACTORY.createBooleanSetting("CLEAR_UPLOAD", true);
    public static final BooleanSetting ALLOW_BROWSER = LimeProps.FACTORY.createBooleanSetting("ALLOW_BROWSER", false);

    private SharingSettings() {
    }

    public static final void setSaveDirectory(File saveDir) throws IOException {
        if (saveDir == null) {
            throw new NullPointerException();
        }
        if (!saveDir.isDirectory() && !saveDir.mkdirs()) {
            throw new IOException("could not create save dir");
        }
        String parentDir = saveDir.getParent();
        File incDir = new File(parentDir, "Incomplete");
        if (!incDir.isDirectory() && !incDir.mkdirs()) {
            throw new IOException("could not create incomplete dir");
        }
        FileUtils.setWriteable(saveDir);
        FileUtils.setWriteable(incDir);
        if (!(saveDir.canRead() && saveDir.canWrite() && incDir.canRead() && incDir.canWrite())) {
            throw new IOException("could not write to selected directory");
        }
        try {
            saveDir = FileUtils.getCanonicalFile(saveDir);
        }
        catch (IOException ignored) {
            // empty catch block
        }
        try {
            incDir = FileUtils.getCanonicalFile(incDir);
        }
        catch (IOException ignored) {
            // empty catch block
        }
        File snapFile = new File(incDir, "downloads.dat");
        try {
            snapFile = FileUtils.getCanonicalFile(snapFile);
        }
        catch (IOException ignored) {
            // empty catch block
        }
        File snapBackup = new File(incDir, "downloads.bak");
        try {
            snapBackup = FileUtils.getCanonicalFile(snapBackup);
        }
        catch (IOException ignored) {
            // empty catch block
        }
        DIRECTORY_FOR_SAVING_FILES.setValue(saveDir);
        INCOMPLETE_DIRECTORY.setValue(incDir);
        DOWNLOAD_SNAPSHOT_FILE.setValue(snapFile);
        DOWNLOAD_SNAPSHOT_BACKUP_FILE.setValue(snapBackup);
    }

    public static final File getSaveDirectory() {
        return DIRECTORY_FOR_SAVING_FILES.getValue();
    }

    public static final void addDirectory(File dir) throws IOException {
        if (dir == null || !dir.isDirectory() || !dir.exists()) {
            throw new IOException();
        }
        File[] shared = DIRECTORIES_TO_SHARE.getValue();
        HashSet set = new HashSet();
        int i = 0;
        while (i < shared.length) {
            set.add(shared[i]);
            ++i;
        }
        set.add(dir);
        DIRECTORIES_TO_SHARE.setValue((File[])set.toArray(new File[0]));
    }

    public static final void setDirectories(File[] files) throws IOException {
        HashSet set = new HashSet();
        int i = 0;
        while (i < files.length) {
            if (files[i] == null || !files[i].isDirectory() || !files[i].exists()) {
                throw new IOException();
            }
            set.add(files[i]);
            ++i;
        }
        DIRECTORIES_TO_SHARE.setValue((File[])set.toArray(new File[0]));
    }
}

