/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.settings;

import com.limegroup.gnutella.settings.Setting;
import java.io.File;
import java.util.Properties;
import java.util.StringTokenizer;

public class FileArraySetting
extends Setting {
    private File[] value;

    FileArraySetting(Properties defaultProps, Properties props, String key, File[] defaultValue) {
        super(defaultProps, props, key, FileArraySetting.decode(defaultValue));
    }

    public File[] getValue() {
        return this.value;
    }

    public void setValue(File[] value) {
        super.setValue(FileArraySetting.decode(value));
    }

    protected void loadValue(String sValue) {
        this.value = FileArraySetting.encode(sValue);
    }

    private static final File[] encode(String src) {
        if (src == null || src.length() == 0) {
            return new File[0];
        }
        StringTokenizer tokenizer = new StringTokenizer(src, ";");
        File[] dirs = new File[tokenizer.countTokens()];
        int i = 0;
        while (i < dirs.length) {
            dirs[i] = new File(tokenizer.nextToken());
            ++i;
        }
        return dirs;
    }

    private static final String decode(File[] src) {
        if (src == null || src.length == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < src.length) {
            buffer.append(src[i].getAbsolutePath());
            if (i < src.length - 1) {
                buffer.append(';');
            }
            ++i;
        }
        return buffer.toString();
    }
}

