/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.routing;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.routing.RouteTableMessage;
import com.limegroup.gnutella.statistics.DroppedSentMessageStatHandler;
import com.limegroup.gnutella.statistics.SentMessageStatHandler;
import java.io.IOException;
import java.io.OutputStream;

public class ResetTableMessage
extends RouteTableMessage {
    private int tableSize;
    private byte infinity;

    public ResetTableMessage(int tableSize, byte infinity) {
        super((byte)1, 6, (byte)0);
        if (tableSize < 1 || infinity < 1) {
            throw new IllegalArgumentException("Argument too small: " + tableSize + ", " + infinity);
        }
        this.tableSize = tableSize;
        this.infinity = infinity;
    }

    protected void writePayloadData(OutputStream out) throws IOException {
        byte[] buf = new byte[5];
        ByteOrder.int2leb(this.tableSize, buf, 0);
        buf[4] = this.infinity;
        out.write(buf);
        if (Message.RECORD_STATS) {
            SentMessageStatHandler.TCP_RESET_ROUTE_TABLE_MESSAGES.addMessage(this);
        }
    }

    protected ResetTableMessage(byte[] guid, byte ttl, byte hops, byte[] payload) throws BadPacketException {
        super(guid, ttl, hops, payload.length, (byte)0);
        this.tableSize = ByteOrder.leb2int(payload, 1);
        this.infinity = payload[5];
    }

    public byte getInfinity() {
        return this.infinity;
    }

    public int getTableSize() {
        return this.tableSize;
    }

    public void recordDrop() {
        if (Message.RECORD_STATS) {
            DroppedSentMessageStatHandler.TCP_RESET_ROUTE_TABLE_MESSAGES.addMessage(this);
        }
    }

    public String toString() {
        return "{RESET, tableSize: " + this.getTableSize() + ", Infinity: " + this.getInfinity() + "}";
    }
}

