/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.mp3;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.mp3.MP3Info;
import com.limegroup.gnutella.util.NameValue;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Set;
import com.sun.java.util.collections.Vector;
import de.vdheide.mp3.ID3v2;
import de.vdheide.mp3.ID3v2BadParsingException;
import de.vdheide.mp3.ID3v2Exception;
import de.vdheide.mp3.ID3v2Frame;
import de.vdheide.mp3.NoID3v2TagException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;

public final class ID3Reader {
    public static final String schemaURI = "http://www.limewire.com/schemas/audio.xsd";
    private static final String ISO_LATIN_1 = "8859_1";
    private static final String UNICODE = "Unicode";
    private static final String KEY_PREFIX = "audios__audio__";
    private static final String TRACK_KEY = "audios__audio__track__";
    private static final String ARTIST_KEY = "audios__audio__artist__";
    private static final String ALBUM_KEY = "audios__audio__album__";
    private static final String TITLE_KEY = "audios__audio__title__";
    private static final String GENRE_KEY = "audios__audio__genre__";
    private static final String YEAR_KEY = "audios__audio__year__";
    private static final String COMMENTS_KEY = "audios__audio__comments__";
    private static final String BITRATE_KEY = "audios__audio__bitrate__";
    private static final String SECONDS_KEY = "audios__audio__seconds__";

    private ID3Reader() {
    }

    public static boolean isCorrupted(LimeXMLDocument doc) {
        if (!schemaURI.equals(doc.getSchemaURI())) {
            return false;
        }
        Set existing = doc.getNameValueSet();
        Iterator i = existing.iterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!name.equals(ALBUM_KEY) && !name.equals(ARTIST_KEY) || value.length() != 30 || value.charAt(29) == ' ' || value.charAt(28) != ' ') continue;
            return true;
        }
        return false;
    }

    public static LimeXMLDocument fixCorruption(LimeXMLDocument oldDoc) {
        Set existing = oldDoc.getNameValueSet();
        ArrayList info = new ArrayList(existing.size());
        Iterator i = existing.iterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            if ((name.equals(ALBUM_KEY) || name.equals(ARTIST_KEY)) && value.length() == 30 && value.charAt(29) != ' ' && value.charAt(28) == ' ') {
                value = value.substring(0, 29).trim();
            }
            info.add(new NameValue(name, value));
        }
        return new LimeXMLDocument(info, oldDoc.getSchemaURI());
    }

    public static String readDocument(File file, boolean id3Only) throws IOException {
        ID3Data data = ID3Reader.parseFile(file);
        return data.toXML(file.getCanonicalPath(), id3Only);
    }

    public static LimeXMLDocument readDocument(File file) throws IOException {
        ID3Data data = ID3Reader.parseFile(file);
        List nameValList = data.toNameValueList();
        if (nameValList.isEmpty()) {
            throw new IOException("invalid/no data.");
        }
        return new LimeXMLDocument(nameValList, schemaURI);
    }

    private static ID3Data parseFile(File file) throws IOException {
        ID3Data data = ID3Reader.parseID3v2Data(file);
        MP3Info mp3Info = new MP3Info(file.getCanonicalPath());
        data.setBitrate(mp3Info.getBitRate());
        data.setLength((int)mp3Info.getLengthInSeconds());
        if (data.isComplete()) {
            return data;
        }
        ID3Data v1 = ID3Reader.parseID3v1Data(file);
        data.mergeID3Data(v1);
        return data;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ID3Data parseID3v1Data(File file) {
        block15: {
            block14: {
                data = new ID3Data();
                if (file.length() < 128L) {
                    return data;
                }
                randomAccessFile = null;
                try {
                    try {
                        randomAccessFile = new RandomAccessFile(file, "r");
                        length = randomAccessFile.length();
                        randomAccessFile.seek(length - 128L);
                        buffer = new byte[30];
                        randomAccessFile.readFully(buffer, 0, 3);
                        tag = new String(buffer, 0, 3);
                        if (!tag.equals("TAG")) {
                            var7_7 = data;
                            var10_8 = null;
                            if (randomAccessFile == null) return var7_7;
                            break block14;
                        }
                        randomAccessFile.readFully(buffer, 0, 30);
                        data.setTitle(ID3Reader.getString(buffer, 30));
                        randomAccessFile.readFully(buffer, 0, 30);
                        data.setArtist(ID3Reader.getString(buffer, 30));
                        randomAccessFile.readFully(buffer, 0, 30);
                        data.setAlbum(ID3Reader.getString(buffer, 30));
                        randomAccessFile.readFully(buffer, 0, 4);
                        data.setYear(ID3Reader.getString(buffer, 4));
                        randomAccessFile.readFully(buffer, 0, 30);
                        if (buffer[28] == 0) {
                            data.setTrack((short)ByteOrder.ubyte2int(buffer[29]));
                            commentLength = 28;
                        } else {
                            data.setTrack((short)0);
                            commentLength = 3;
                        }
                        data.setComment(ID3Reader.getString(buffer, commentLength));
                        randomAccessFile.readFully(buffer, 0, 1);
                        data.setGenre(ID3Reader.getGenreString((short)ByteOrder.ubyte2int(buffer[0])));
                        break block15;
                    }
                    catch (IOException ignored) {
                        var10_10 = null;
                        if (randomAccessFile == null) return data;
                        try {
                            randomAccessFile.close();
                            return data;
                        }
                        catch (IOException ignored) {
                            return data;
                        }
                    }
                }
                catch (Throwable var9_17) {
                    var10_11 = null;
                    if (randomAccessFile == null) throw var9_17;
                    ** try [egrp 2[TRYBLOCK] [2 : 278->285)] { 
lbl52:
                    // 1 sources

                    randomAccessFile.close();
                    throw var9_17;
lbl54:
                    // 1 sources

                    catch (IOException ignored) {
                        // empty catch block
                    }
                    throw var9_17;
                }
            }
            ** try [egrp 2[TRYBLOCK] [2 : 278->285)] { 
lbl59:
            // 1 sources

            randomAccessFile.close();
            return var7_7;
lbl61:
            // 1 sources

            catch (IOException ignored) {
                // empty catch block
            }
            return var7_7;
        }
        var10_9 = null;
        if (randomAccessFile == null) return data;
        try {}
        catch (IOException ignored) {}
        randomAccessFile.close();
        return data;
        return data;
    }

    private static String getString(byte[] buffer, int length) {
        try {
            return new String(buffer, 0, ID3Reader.getTrimmedLength(buffer, length), ISO_LATIN_1);
        }
        catch (UnsupportedEncodingException err) {
            return null;
        }
    }

    private static ID3Data parseID3v2Data(File file) {
        ID3Data data = new ID3Data();
        ID3v2 id3v2Parser = null;
        try {
            id3v2Parser = new ID3v2(file);
        }
        catch (ID3v2Exception idvx) {
            if (idvx instanceof ID3v2BadParsingException) {
                ErrorService.error(idvx);
            }
            return data;
        }
        catch (IOException iox) {
            return data;
        }
        Vector frames = null;
        try {
            frames = id3v2Parser.getFrames();
        }
        catch (NoID3v2TagException ntx) {
            return data;
        }
        Iterator iter = frames.iterator();
        while (iter.hasNext()) {
            ID3v2Frame frame = (ID3v2Frame)iter.next();
            String frameID = frame.getID();
            byte[] contentBytes = frame.getContent();
            String frameContent = null;
            if (contentBytes.length > 0) {
                try {
                    String enc = frame.isISOLatin1() ? ISO_LATIN_1 : UNICODE;
                    frameContent = new String(contentBytes, enc).trim();
                }
                catch (UnsupportedEncodingException err) {
                    // empty catch block
                }
            }
            if (frameContent == null || frameContent.trim().equals("")) continue;
            if ("TIT2".equals(frameID)) {
                data.setTitle(frameContent);
                continue;
            }
            if ("TPE1".equals(frameID)) {
                data.setArtist(frameContent);
                continue;
            }
            if ("TALB".equals(frameID)) {
                data.setAlbum(frameContent);
                continue;
            }
            if ("TYER".equals(frameID)) {
                data.setYear(frameContent);
                continue;
            }
            if ("COMM".equals(frameID)) {
                byte[] bytes = frame.getContent();
                int startIndex = 0;
                int i = bytes.length - 1;
                while (i >= 0) {
                    if (bytes[i] == 0) {
                        startIndex = i;
                        break;
                    }
                    --i;
                }
                frameContent = new String(bytes, startIndex, bytes.length - startIndex).trim();
                data.setComment(frameContent);
                continue;
            }
            if ("TRCK".equals(frameID)) {
                try {
                    data.setTrack(Short.parseShort(frameContent));
                }
                catch (NumberFormatException ignored) {}
                continue;
            }
            if (!"TCON".equals(frameID)) continue;
            int startIndex = frameContent.indexOf("(");
            int endIndex = frameContent.indexOf(")");
            int genreCode = -1;
            if (startIndex > -1 && endIndex > -1) {
                String genreByte = frameContent.substring(startIndex + 1, endIndex);
                try {
                    genreCode = Integer.parseInt(genreByte);
                }
                catch (NumberFormatException nfx) {
                    genreCode = -1;
                }
            }
            if (genreCode >= 0 && genreCode <= 127) {
                data.setGenre(ID3Reader.getGenreString((short)genreCode));
                continue;
            }
            data.setGenre(frameContent);
        }
        return data;
    }

    private static void appendStrings(String key, String value, StringBuffer appendTo) {
        appendTo.append(key);
        appendTo.append(value);
        appendTo.append("\"");
    }

    private static int getTrimmedLength(byte[] bytes, int includedLength) {
        int i = includedLength - 1;
        while (i >= 0 && (bytes[i] == 0 || bytes[i] == 32)) {
            --i;
        }
        int j = 0;
        while (j <= i) {
            if (bytes[j] == 0) {
                bytes[j] = 32;
            }
            ++j;
        }
        return i + 1;
    }

    public static boolean isNonID3Field(String fieldName) {
        return !fieldName.equals(TRACK_KEY) && !fieldName.equals(ARTIST_KEY) && !fieldName.equals(ALBUM_KEY) && !fieldName.equals(TITLE_KEY) && !fieldName.equals(GENRE_KEY) && !fieldName.equals(YEAR_KEY) && !fieldName.equals(COMMENTS_KEY) && !fieldName.equals(BITRATE_KEY) && !fieldName.equals(SECONDS_KEY);
    }

    public static String getGenreString(short genre) {
        switch (genre) {
            case 0: {
                return "Blues";
            }
            case 1: {
                return "Classic Rock";
            }
            case 2: {
                return "Country";
            }
            case 3: {
                return "Dance";
            }
            case 4: {
                return "Disco";
            }
            case 5: {
                return "Funk";
            }
            case 6: {
                return "Grunge";
            }
            case 7: {
                return "Hip-Hop";
            }
            case 8: {
                return "Jazz";
            }
            case 9: {
                return "Metal";
            }
            case 10: {
                return "New Age";
            }
            case 11: {
                return "Oldies";
            }
            case 12: {
                return "Other";
            }
            case 13: {
                return "Pop";
            }
            case 14: {
                return "R &amp; B";
            }
            case 15: {
                return "Rap";
            }
            case 16: {
                return "Reggae";
            }
            case 17: {
                return "Rock";
            }
            case 18: {
                return "Techno";
            }
            case 19: {
                return "Industrial";
            }
            case 20: {
                return "Alternative";
            }
            case 21: {
                return "Ska";
            }
            case 22: {
                return "Death Metal";
            }
            case 23: {
                return "Pranks";
            }
            case 24: {
                return "Soundtrack";
            }
            case 25: {
                return "Euro-Techno";
            }
            case 26: {
                return "Ambient";
            }
            case 27: {
                return "Trip-Hop";
            }
            case 28: {
                return "Vocal";
            }
            case 29: {
                return "Jazz+Funk";
            }
            case 30: {
                return "Fusion";
            }
            case 31: {
                return "Trance";
            }
            case 32: {
                return "Classical";
            }
            case 33: {
                return "Instrumental";
            }
            case 34: {
                return "Acid";
            }
            case 35: {
                return "House";
            }
            case 36: {
                return "Game";
            }
            case 37: {
                return "Sound Clip";
            }
            case 38: {
                return "Gospel";
            }
            case 39: {
                return "Noise";
            }
            case 40: {
                return "AlternRock";
            }
            case 41: {
                return "Bass";
            }
            case 42: {
                return "Soul";
            }
            case 43: {
                return "Punk";
            }
            case 44: {
                return "Space";
            }
            case 45: {
                return "Meditative";
            }
            case 46: {
                return "Instrumental Pop";
            }
            case 47: {
                return "Instrumental Rock";
            }
            case 48: {
                return "Ethnic";
            }
            case 49: {
                return "Gothic";
            }
            case 50: {
                return "Darkwave";
            }
            case 51: {
                return "Techno-Industrial";
            }
            case 52: {
                return "Electronic";
            }
            case 53: {
                return "Pop-Folk";
            }
            case 54: {
                return "Eurodance";
            }
            case 55: {
                return "Dream";
            }
            case 56: {
                return "Southern Rock";
            }
            case 57: {
                return "Comedy";
            }
            case 58: {
                return "Cult";
            }
            case 59: {
                return "Gangsta";
            }
            case 60: {
                return "Top 40";
            }
            case 61: {
                return "Christian Rap";
            }
            case 62: {
                return "Pop/Funk";
            }
            case 63: {
                return "Jungle";
            }
            case 64: {
                return "Native American";
            }
            case 65: {
                return "Cabaret";
            }
            case 66: {
                return "New Wave";
            }
            case 67: {
                return "Psychadelic";
            }
            case 68: {
                return "Rave";
            }
            case 69: {
                return "Showtunes";
            }
            case 70: {
                return "Trailer";
            }
            case 71: {
                return "Lo-Fi";
            }
            case 72: {
                return "Tribal";
            }
            case 73: {
                return "Acid Punk";
            }
            case 74: {
                return "Acid Jazz";
            }
            case 75: {
                return "Polka";
            }
            case 76: {
                return "Retro";
            }
            case 77: {
                return "Musical";
            }
            case 78: {
                return "Rock &amp; Roll";
            }
            case 79: {
                return "Hard Rock";
            }
            case 80: {
                return "Folk";
            }
            case 81: {
                return "Folk-Rock";
            }
            case 82: {
                return "National Folk";
            }
            case 83: {
                return "Swing";
            }
            case 84: {
                return "Fast Fusion";
            }
            case 85: {
                return "Bebob";
            }
            case 86: {
                return "Latin";
            }
            case 87: {
                return "Revival";
            }
            case 88: {
                return "Celtic";
            }
            case 89: {
                return "Bluegrass";
            }
            case 90: {
                return "Avantgarde";
            }
            case 91: {
                return "Gothic Rock";
            }
            case 92: {
                return "Progressive Rock";
            }
            case 93: {
                return "Psychedelic Rock";
            }
            case 94: {
                return "Symphonic Rock";
            }
            case 95: {
                return "Slow Rock";
            }
            case 96: {
                return "Big Band";
            }
            case 97: {
                return "Chorus";
            }
            case 98: {
                return "Easy Listening";
            }
            case 99: {
                return "Acoustic";
            }
            case 100: {
                return "Humour";
            }
            case 101: {
                return "Speech";
            }
            case 102: {
                return "Chanson";
            }
            case 103: {
                return "Opera";
            }
            case 104: {
                return "Chamber Music";
            }
            case 105: {
                return "Sonata";
            }
            case 106: {
                return "Symphony";
            }
            case 107: {
                return "Booty Bass";
            }
            case 108: {
                return "Primus";
            }
            case 109: {
                return "Porn Groove";
            }
            case 110: {
                return "Satire";
            }
            case 111: {
                return "Slow Jam";
            }
            case 112: {
                return "Club";
            }
            case 113: {
                return "Tango";
            }
            case 114: {
                return "Samba";
            }
            case 115: {
                return "Folklore";
            }
            case 116: {
                return "Ballad";
            }
            case 117: {
                return "Power Ballad";
            }
            case 118: {
                return "Rhythmic Soul";
            }
            case 119: {
                return "Freestyle";
            }
            case 120: {
                return "Duet";
            }
            case 121: {
                return "Punk Rock";
            }
            case 122: {
                return "Drum Solo";
            }
            case 123: {
                return "A capella";
            }
            case 124: {
                return "Euro-House";
            }
            case 125: {
                return "Dance Hall";
            }
        }
        return "";
    }

    static class ID3Data {
        private String title;
        private String artist;
        private String album;
        private String year;
        private String comment;
        private short track = (short)-1;
        private String genre;
        private int bitrate = -1;
        private int length = -1;

        ID3Data() {
        }

        public String toString() {
            return "ID3Data: title[" + this.title + "], artist[" + this.artist + "], album[" + this.album + "], year[" + this.year + "], comment[" + this.comment + "], track[" + this.track + "], genre[" + this.genre + "], bitrate[" + this.bitrate + "], length[" + this.length + "]";
        }

        String getTitle() {
            return this.title;
        }

        String getArtist() {
            return this.artist;
        }

        String getAlbum() {
            return this.album;
        }

        String getYear() {
            return this.year;
        }

        String getComment() {
            return this.comment;
        }

        short getTrack() {
            return this.track;
        }

        String getGenre() {
            return this.genre;
        }

        int getBitrate() {
            return this.bitrate;
        }

        int getLength() {
            return this.length;
        }

        void setTitle(String title) {
            this.title = title;
        }

        void setArtist(String artist) {
            this.artist = artist;
        }

        void setAlbum(String album) {
            this.album = album;
        }

        void setYear(String year) {
            this.year = year;
        }

        void setComment(String comment) {
            this.comment = comment;
        }

        void setTrack(short track) {
            this.track = track;
        }

        void setGenre(String genre) {
            this.genre = genre;
        }

        void setBitrate(int bitrate) {
            this.bitrate = bitrate;
        }

        void setLength(int length) {
            this.length = length;
        }

        void mergeID3Data(ID3Data data) {
            if (!this.isValid(this.title)) {
                this.title = data.title;
            }
            if (!this.isValid(this.artist)) {
                this.artist = data.artist;
            }
            if (!this.isValid(this.album)) {
                this.album = data.album;
            }
            if (!this.isValid(this.year)) {
                this.year = data.year;
            }
            if (!this.isValid(this.comment)) {
                this.comment = data.comment;
            }
            if (!this.isValid(this.track)) {
                this.track = data.track;
            }
            if (!this.isValid(this.genre)) {
                this.genre = data.genre;
            }
            if (!this.isValid(this.bitrate)) {
                this.bitrate = data.bitrate;
            }
            if (!this.isValid(this.length)) {
                this.length = data.length;
            }
        }

        boolean isComplete() {
            return this.isValid(this.title) && this.isValid(this.artist) && this.isValid(this.album) && this.isValid(this.year) && this.isValid(this.comment) && this.isValid(this.track) && this.isValid(this.genre) && this.isValid(this.bitrate) && this.isValid(this.length);
        }

        List toNameValueList() {
            ArrayList list = new ArrayList();
            this.add((List)list, this.title, ID3Reader.TITLE_KEY);
            this.add((List)list, this.artist, ID3Reader.ARTIST_KEY);
            this.add((List)list, this.album, ID3Reader.ALBUM_KEY);
            this.add((List)list, this.year, ID3Reader.YEAR_KEY);
            this.add((List)list, this.comment, ID3Reader.COMMENTS_KEY);
            this.add((List)list, this.track, ID3Reader.TRACK_KEY);
            this.add((List)list, this.genre, ID3Reader.GENRE_KEY);
            this.add((List)list, this.bitrate, ID3Reader.BITRATE_KEY);
            this.add((List)list, this.length, ID3Reader.SECONDS_KEY);
            return list;
        }

        String toXML(String path, boolean id3Only) {
            StringBuffer strB = new StringBuffer();
            if (id3Only) {
                ID3Reader.appendStrings("<audios noNamespaceSchemaLocation=\"", ID3Reader.schemaURI, strB);
                strB.append("><audio ");
                ID3Reader.appendStrings(" identifier=\"", path, strB);
            }
            if (this.isValid(this.title)) {
                ID3Reader.appendStrings(" title=\"", this.title, strB);
            }
            if (this.isValid(this.artist)) {
                ID3Reader.appendStrings(" artist=\"", this.artist, strB);
            }
            if (this.isValid(this.album)) {
                ID3Reader.appendStrings(" album=\"", this.album, strB);
            }
            if (this.isValid(this.track)) {
                ID3Reader.appendStrings(" track=\"", "" + this.track, strB);
            }
            if (this.isValid(this.genre)) {
                ID3Reader.appendStrings(" genre=\"", this.genre, strB);
            }
            if (this.isValid(this.year)) {
                ID3Reader.appendStrings(" year=\"", this.year, strB);
            }
            if (this.isValid(this.comment)) {
                ID3Reader.appendStrings(" comments=\"", this.comment, strB);
            }
            if (this.isValid(this.bitrate)) {
                ID3Reader.appendStrings(" bitrate=\"", "" + this.bitrate, strB);
            }
            if (this.isValid(this.length)) {
                ID3Reader.appendStrings(" seconds=\"", "" + this.length, strB);
            }
            if (id3Only) {
                strB.append("/>");
                strB.append("</audios>");
            }
            return strB.toString();
        }

        private void add(List list, String value, String key) {
            if (this.isValid(value)) {
                list.add(new NameValue(key, value.trim()));
            }
        }

        private void add(List list, int value, String key) {
            if (this.isValid(value)) {
                list.add(new NameValue(key, "" + value));
            }
        }

        private boolean isValid(String s) {
            return s != null && !s.trim().equals("");
        }

        private boolean isValid(int i) {
            return i >= 0;
        }
    }
}

