/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.Constants;
import com.limegroup.gnutella.ExtendedEndpoint;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.vendor.UDPCrawlerPing;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class UDPCrawlerPong
extends VendorMessage {
    public static final int VERSION = 1;
    List _ultrapeers;
    List _leaves;
    final boolean _connectionTime;
    final boolean _localeInfo;
    final boolean _newOnly;
    private final byte _format;

    public UDPCrawlerPong(UDPCrawlerPing request) {
        super(VendorMessage.F_LIME_VENDOR_ID, 6, 1, UDPCrawlerPong.derivePayload(request));
        this.setGUID(new GUID(request.getGUID()));
        this._format = (byte)(request.getFormat() & 7);
        this._localeInfo = request.hasLocaleInfo();
        this._connectionTime = request.hasConnectionTime();
        this._newOnly = request.hasNewOnly();
    }

    private static byte[] derivePayload(UDPCrawlerPing request) {
        Connection c;
        byte format = (byte)(request.getFormat() & 7);
        List endpointsUP = new LinkedList();
        List endpointsLeaf = new LinkedList();
        Iterator iter = RouterService.getConnectionManager().getInitializedConnections().iterator();
        boolean newOnly = request.hasNewOnly();
        while (iter.hasNext()) {
            c = (Connection)iter.next();
            if (newOnly) {
                if (c.remoteHostSupportsUDPCrawling() < 1) continue;
                endpointsUP.add(c);
                continue;
            }
            if (!c.isGoodUltrapeer()) continue;
            endpointsUP.add(c);
        }
        iter = RouterService.getConnectionManager().getInitializedClientConnections().iterator();
        while (iter.hasNext()) {
            c = (Connection)iter.next();
            endpointsLeaf.add(c);
        }
        if (!request.hasLocaleInfo()) {
            if (request.getNumberUP() != -1 && request.getNumberUP() < endpointsUP.size()) {
                int index = (int)Math.floor(Math.random() * (double)(endpointsUP.size() - request.getNumberUP()));
                endpointsUP = endpointsUP.subList(index, index + request.getNumberUP());
            }
            if (request.getNumberLeaves() != -1 && request.getNumberLeaves() < endpointsLeaf.size()) {
                int index = (int)Math.floor(Math.random() * (double)(endpointsLeaf.size() - request.getNumberLeaves()));
                endpointsLeaf = endpointsLeaf.subList(index, index + request.getNumberLeaves());
            }
        } else {
            String myLocale = ApplicationSettings.LANGUAGE.getValue();
            List prefedcons = RouterService.getConnectionManager().getInitializedConnectionsMatchLocale(myLocale);
            endpointsUP.removeAll(prefedcons);
            prefedcons.addAll(endpointsUP);
            endpointsUP = prefedcons;
            prefedcons = RouterService.getConnectionManager().getInitializedClientConnectionsMatchLocale(myLocale);
            endpointsLeaf.removeAll(prefedcons);
            prefedcons.addAll(endpointsLeaf);
            endpointsLeaf = prefedcons;
            if (request.getNumberUP() != -1 && request.getNumberUP() < endpointsUP.size()) {
                endpointsUP = endpointsUP.subList(0, request.getNumberUP());
            }
            if (request.getNumberLeaves() != -1 && request.getNumberLeaves() < endpointsLeaf.size()) {
                endpointsLeaf = endpointsLeaf.subList(0, request.getNumberLeaves());
            }
        }
        int bytesPerResult = 6;
        if (request.hasConnectionTime()) {
            bytesPerResult += 2;
        }
        if (request.hasLocaleInfo()) {
            bytesPerResult += 2;
        }
        byte[] result = new byte[(endpointsUP.size() + endpointsLeaf.size()) * bytesPerResult + 3];
        result[0] = (byte)endpointsUP.size();
        result[1] = (byte)endpointsLeaf.size();
        result[2] = format;
        endpointsUP.addAll(endpointsLeaf);
        long now = System.currentTimeMillis();
        int index = 3;
        iter = endpointsUP.iterator();
        while (iter.hasNext()) {
            Connection c2 = (Connection)iter.next();
            System.arraycopy(UDPCrawlerPong.packIPAddress(c2.getInetAddress(), c2.getPort()), 0, result, index, 6);
            index += 6;
            if (request.hasConnectionTime()) {
                long uptime = now - c2.getConnectionTime();
                short packed = (short)(uptime / Constants.MINUTE);
                ByteOrder.short2leb(packed, result, index);
                index += 2;
            }
            if (!request.hasLocaleInfo()) continue;
            System.arraycopy(c2.getLocalePref().getBytes(), 0, result, index, 2);
            index += 2;
        }
        return result;
    }

    private static byte[] packIPAddress(InetAddress addr, int port) {
        try {
            QueryReply.IPPortCombo combo = new QueryReply.IPPortCombo(addr.getHostAddress(), port);
            return combo.toBytes();
        }
        catch (UnknownHostException uhe) {
            throw new IllegalArgumentException(uhe.getMessage());
        }
    }

    protected UDPCrawlerPong(byte[] guid, byte ttl, byte hops, int version, byte[] payload) throws BadPacketException {
        super(guid, ttl, hops, VendorMessage.F_LIME_VENDOR_ID, 6, version, payload);
        this._ultrapeers = new LinkedList();
        this._leaves = new LinkedList();
        if (this.getVersion() == 1 && (payload == null || payload.length < 3)) {
            throw new BadPacketException();
        }
        byte numberUP = payload[0];
        byte numberLeaves = payload[1];
        this._format = (byte)(payload[2] & 7);
        this._connectionTime = (this._format & 1) == 1;
        this._localeInfo = (this._format & 2) == 2;
        this._newOnly = (this._format & 4) == 4;
        int bytesPerResult = 6;
        if (this._connectionTime) {
            bytesPerResult += 2;
        }
        if (this._localeInfo) {
            bytesPerResult += 2;
        }
        if (this.getVersion() == 1 && payload.length != (numberUP + numberLeaves) * bytesPerResult + 3) {
            throw new BadPacketException("size is " + payload.length + " but should have been " + (numberUP + numberLeaves) * bytesPerResult + 3);
        }
        int i = 3;
        while (i < numberUP * bytesPerResult) {
            int index = i;
            byte[] current = new byte[6];
            System.arraycopy(payload, index, current, 0, 6);
            index += 6;
            QueryReply.IPPortCombo combo = QueryReply.IPPortCombo.getCombo(current);
            if (combo == null || combo.getInetAddress() == null) {
                throw new BadPacketException("parsing of ip:port failed.  dump of current byte block: " + current);
            }
            ExtendedEndpoint result = new ExtendedEndpoint(combo.getAddress(), combo.getPort());
            if (this._connectionTime) {
                result.setDailyUptime(ByteOrder.leb2short(payload, index));
                index += 2;
            }
            if (this._localeInfo) {
                String langCode = new String(payload, index, 2);
                result.setClientLocale(langCode);
                index += 2;
            }
            this._ultrapeers.add(result);
            i += bytesPerResult;
        }
        int i2 = numberUP * bytesPerResult + 3;
        while (i2 < payload.length) {
            int index = i2;
            byte[] current = new byte[6];
            System.arraycopy(payload, index, current, 0, 6);
            index += 6;
            QueryReply.IPPortCombo combo = QueryReply.IPPortCombo.getCombo(current);
            if (combo == null || combo.getInetAddress() == null) {
                throw new BadPacketException("parsing of ip:port failed.  dump of current byte block: " + current);
            }
            ExtendedEndpoint result = new ExtendedEndpoint(combo.getAddress(), combo.getPort());
            if (this._connectionTime) {
                result.setDailyUptime(ByteOrder.leb2short(payload, index));
                index += 2;
            }
            if (this._localeInfo) {
                String langCode = new String(payload, index, 2);
                result.setClientLocale(langCode);
                index += 2;
            }
            this._leaves.add(result);
            i2 += bytesPerResult;
        }
    }

    public List getUltrapeers() {
        return this._ultrapeers;
    }

    public List getLeaves() {
        return this._leaves;
    }

    public boolean hasConnectionTime() {
        return this._connectionTime;
    }

    public boolean hasLocaleInfo() {
        return this._localeInfo;
    }
}

