/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.util.NetworkUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;

public final class TCPConnectBackRedirect
extends VendorMessage {
    public static final int VERSION = 1;
    private final int _port;
    private final InetAddress _addr;

    TCPConnectBackRedirect(byte[] guid, byte ttl, byte hops, int version, byte[] payload) throws BadPacketException {
        super(guid, ttl, hops, VendorMessage.F_LIME_VENDOR_ID, 7, version, payload);
        if (this.getVersion() == 1 && this.getPayload().length != 6) {
            throw new BadPacketException("UNSUPPORTED PAYLOAD LENGTH: " + payload.length);
        }
        byte[] ip = new byte[4];
        System.arraycopy(this.getPayload(), 0, ip, 0, ip.length);
        if (!NetworkUtils.isValidAddress(ip)) {
            throw new BadPacketException("Bad Host!!");
        }
        try {
            this._addr = InetAddress.getByName(NetworkUtils.ip2string(ip));
        }
        catch (UnknownHostException uhe) {
            throw new BadPacketException("Bad InetAddress!!");
        }
        this._port = ByteOrder.ubytes2int(ByteOrder.leb2short(this.getPayload(), ip.length));
        if (!NetworkUtils.isValidPort(this._port)) {
            throw new BadPacketException("invalid port");
        }
    }

    public TCPConnectBackRedirect(InetAddress addr, int port) {
        super(VendorMessage.F_LIME_VENDOR_ID, 7, 1, TCPConnectBackRedirect.derivePayload(addr, port));
        this._addr = addr;
        this._port = port;
    }

    public InetAddress getConnectBackAddress() {
        return this._addr;
    }

    public int getConnectBackPort() {
        return this._port;
    }

    private static byte[] derivePayload(InetAddress addr, int port) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] ip = addr.getAddress();
            if (!NetworkUtils.isValidAddress(ip)) {
                throw new IllegalArgumentException("invalid ip: " + addr);
            }
            baos.write(ip);
            ByteOrder.short2leb((short)port, baos);
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            ErrorService.error(ioe);
            return null;
        }
    }

    protected void writePayload(OutputStream out) throws IOException {
        super.writePayload(out);
        if (Message.RECORD_STATS) {
            // empty if block
        }
    }

    public void recordDrop() {
        super.recordDrop();
    }
}

