/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.statistics.SentMessageStatHandler;
import java.io.IOException;
import java.io.OutputStream;

public final class HopsFlowVendorMessage
extends VendorMessage {
    public static final int VERSION = 1;

    HopsFlowVendorMessage(byte[] guid, byte ttl, byte hops, int version, byte[] payload) throws BadPacketException {
        super(guid, ttl, hops, VendorMessage.F_BEAR_VENDOR_ID, 4, version, payload);
        if (this.getVersion() > 1) {
            throw new BadPacketException("UNSUPPORTED VERSION");
        }
        if (this.getPayload().length != 1) {
            throw new BadPacketException("UNSUPPORTED PAYLOAD LENGTH: " + this.getPayload().length);
        }
    }

    public HopsFlowVendorMessage(byte hopVal) {
        super(VendorMessage.F_BEAR_VENDOR_ID, 4, 1, HopsFlowVendorMessage.derivePayload(hopVal));
    }

    public int getHopValue() {
        return ByteOrder.ubyte2int(this.getPayload()[0]);
    }

    private static byte[] derivePayload(byte hopVal) {
        byte[] payload = new byte[]{hopVal};
        return payload;
    }

    protected void writePayload(OutputStream out) throws IOException {
        super.writePayload(out);
        if (Message.RECORD_STATS) {
            SentMessageStatHandler.TCP_HOPS_FLOW.addMessage(this);
        }
    }

    public void recordDrop() {
        super.recordDrop();
    }
}

