/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnType;
import com.limegroup.gnutella.guess.QueryKey;
import com.limegroup.gnutella.messages.BadGGEPBlockException;
import com.limegroup.gnutella.messages.BadGGEPPropertyException;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.GGEP;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.statistics.DroppedSentMessageStatHandler;
import com.limegroup.gnutella.statistics.ReceivedErrorStat;
import com.limegroup.gnutella.statistics.SentMessageStatHandler;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.I18NConvert;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.SchemaNotFoundException;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Set;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import org.xml.sax.SAXException;

public class QueryRequest
extends Message
implements Serializable {
    public static final int SPECIAL_MINSPEED_MASK = 128;
    public static final int SPECIAL_FIREWALL_MASK = 64;
    public static final int SPECIAL_XML_MASK = 32;
    public static final int SPECIAL_OUTOFBAND_MASK = 4;
    public static final int AUDIO_MASK = 4;
    public static final int VIDEO_MASK = 8;
    public static final int DOC_MASK = 16;
    public static final int IMAGE_MASK = 32;
    public static final int WIN_PROG_MASK = 64;
    public static final int LIN_PROG_MASK = 128;
    public static final String WHAT_IS_NEW_QUERY_STRING = "WhatIsNewXOXO";
    public static int WHAT_IS_NEW_GGEP_VALUE = 1;
    private final byte[] PAYLOAD;
    private final int MIN_SPEED;
    private final String QUERY;
    private final LimeXMLDocument XML_DOC;
    private int _capabilitySelector = 0;
    private boolean _doNotProxy = false;
    private final Set REQUESTED_URN_TYPES;
    private final Set QUERY_URNS;
    private final QueryKey QUERY_KEY;
    private Integer _metaMask = null;
    private volatile int _hashCode = 0;
    private static final Set EMPTY_SET = Collections.unmodifiableSet(new HashSet());
    private static final byte DEFAULT_TTL = 6;
    private static final char[] ILLEGAL_CHARS = SearchSettings.ILLEGAL_CHARS.getValue();
    private static final int MAX_QUERY_LENGTH = SearchSettings.MAX_QUERY_LENGTH.getValue();
    private static final int MAX_XML_QUERY_LENGTH = SearchSettings.MAX_XML_QUERY_LENGTH.getValue();
    private static final String DEFAULT_URN_QUERY = "\\";

    public static QueryRequest createRequery(URN sha1) {
        if (sha1 == null) {
            throw new NullPointerException("null sha1");
        }
        HashSet sha1Set = new HashSet();
        sha1Set.add(sha1);
        return new QueryRequest(QueryRequest.newQueryGUID(true), 6, DEFAULT_URN_QUERY, "", UrnType.SHA1_SET, sha1Set, null, !RouterService.acceptedIncomingConnection(), -1, false, 0, false, 0);
    }

    public static QueryRequest createQuery(URN sha1) {
        if (sha1 == null) {
            throw new NullPointerException("null sha1");
        }
        HashSet sha1Set = new HashSet();
        sha1Set.add(sha1);
        return new QueryRequest(QueryRequest.newQueryGUID(false), 6, DEFAULT_URN_QUERY, "", UrnType.SHA1_SET, sha1Set, null, !RouterService.acceptedIncomingConnection(), -1, false, 0, false, 0);
    }

    public static QueryRequest createRequery(URN sha1, String filename) {
        if (sha1 == null) {
            throw new NullPointerException("null sha1");
        }
        if (filename == null) {
            throw new NullPointerException("null query");
        }
        if (filename.length() == 0) {
            filename = DEFAULT_URN_QUERY;
        }
        HashSet sha1Set = new HashSet();
        sha1Set.add(sha1);
        return new QueryRequest(QueryRequest.newQueryGUID(true), 6, filename, "", UrnType.SHA1_SET, sha1Set, null, !RouterService.acceptedIncomingConnection(), -1, false, 0, false, 0);
    }

    public static QueryRequest createQuery(URN sha1, String filename) {
        if (sha1 == null) {
            throw new NullPointerException("null sha1");
        }
        if (filename == null) {
            throw new NullPointerException("null query");
        }
        if (filename.length() == 0) {
            filename = DEFAULT_URN_QUERY;
        }
        HashSet sha1Set = new HashSet();
        sha1Set.add(sha1);
        return new QueryRequest(QueryRequest.newQueryGUID(false), 6, filename, "", UrnType.SHA1_SET, sha1Set, null, !RouterService.acceptedIncomingConnection(), -1, false, 0, false, 0);
    }

    public static QueryRequest createRequery(URN sha1, byte ttl) {
        if (sha1 == null) {
            throw new NullPointerException("null sha1");
        }
        if (ttl <= 0 || ttl > 6) {
            throw new IllegalArgumentException("invalid TTL: " + ttl);
        }
        HashSet sha1Set = new HashSet();
        sha1Set.add(sha1);
        return new QueryRequest(QueryRequest.newQueryGUID(true), ttl, DEFAULT_URN_QUERY, "", UrnType.SHA1_SET, sha1Set, null, !RouterService.acceptedIncomingConnection(), -1, false, 0, false, 0);
    }

    public static QueryRequest createQuery(Set urnTypeSet, Set urnSet) {
        if (urnSet == null) {
            throw new NullPointerException("null urnSet");
        }
        if (urnTypeSet == null) {
            throw new NullPointerException("null urnTypeSet");
        }
        return new QueryRequest(QueryRequest.newQueryGUID(false), 6, DEFAULT_URN_QUERY, "", urnTypeSet, urnSet, null, !RouterService.acceptedIncomingConnection(), -1, false, 0, false, 0);
    }

    public static QueryRequest createRequery(String query) {
        if (query == null) {
            throw new NullPointerException("null query");
        }
        if (query.length() == 0) {
            throw new IllegalArgumentException("empty query");
        }
        return new QueryRequest(QueryRequest.newQueryGUID(true), query);
    }

    public static QueryRequest createQuery(String query) {
        if (query == null) {
            throw new NullPointerException("null query");
        }
        if (query.length() == 0) {
            throw new IllegalArgumentException("empty query");
        }
        return new QueryRequest(QueryRequest.newQueryGUID(false), query);
    }

    public static QueryRequest createOutOfBandQuery(byte[] guid, String query, String xmlQuery) {
        query = I18NConvert.instance().getNorm(query);
        if (query == null) {
            throw new NullPointerException("null query");
        }
        if (xmlQuery == null) {
            throw new NullPointerException("null xml query");
        }
        if (query.length() == 0 && xmlQuery.length() == 0) {
            throw new IllegalArgumentException("empty query");
        }
        if (xmlQuery.length() != 0 && !xmlQuery.startsWith("<?xml")) {
            throw new IllegalArgumentException("invalid XML");
        }
        return new QueryRequest(guid, 6, query, xmlQuery, true);
    }

    public static QueryRequest createOutOfBandQuery(byte[] guid, String query, String xmlQuery, MediaType type) {
        query = I18NConvert.instance().getNorm(query);
        if (query == null) {
            throw new NullPointerException("null query");
        }
        if (xmlQuery == null) {
            throw new NullPointerException("null xml query");
        }
        if (query.length() == 0 && xmlQuery.length() == 0) {
            throw new IllegalArgumentException("empty query");
        }
        if (xmlQuery.length() != 0 && !xmlQuery.startsWith("<?xml")) {
            throw new IllegalArgumentException("invalid XML");
        }
        return new QueryRequest(guid, 6, query, xmlQuery, true, type);
    }

    public static QueryRequest createOutOfBandQuery(String query, byte[] ip, int port) {
        byte[] guid = GUID.makeAddressEncodedGuid(ip, port);
        return QueryRequest.createOutOfBandQuery(guid, query, "");
    }

    public static QueryRequest createWhatIsNewQuery(byte[] guid, byte ttl) {
        return QueryRequest.createWhatIsNewQuery(guid, ttl, null);
    }

    public static QueryRequest createWhatIsNewQuery(byte[] guid, byte ttl, MediaType type) {
        if (ttl < 1) {
            throw new IllegalArgumentException("Bad TTL.");
        }
        return new QueryRequest(guid, ttl, WHAT_IS_NEW_QUERY_STRING, "", null, null, null, !RouterService.acceptedIncomingConnection(), -1, false, WHAT_IS_NEW_GGEP_VALUE, false, QueryRequest.getMetaFlag(type));
    }

    public static QueryRequest createWhatIsNewOOBQuery(byte[] guid, byte ttl) {
        return QueryRequest.createWhatIsNewOOBQuery(guid, ttl, null);
    }

    public static QueryRequest createWhatIsNewOOBQuery(byte[] guid, byte ttl, MediaType type) {
        if (ttl < 1) {
            throw new IllegalArgumentException("Bad TTL.");
        }
        return new QueryRequest(guid, ttl, WHAT_IS_NEW_QUERY_STRING, "", null, null, null, !RouterService.acceptedIncomingConnection(), -1, true, WHAT_IS_NEW_GGEP_VALUE, false, QueryRequest.getMetaFlag(type));
    }

    public static QueryRequest createQuery(String query, String xmlQuery) {
        if (query == null) {
            throw new NullPointerException("null query");
        }
        if (xmlQuery == null) {
            throw new NullPointerException("null xml query");
        }
        if (query.length() == 0 && xmlQuery.length() == 0) {
            throw new IllegalArgumentException("empty query");
        }
        if (xmlQuery.length() != 0 && !xmlQuery.startsWith("<?xml")) {
            throw new IllegalArgumentException("invalid XML");
        }
        return new QueryRequest(QueryRequest.newQueryGUID(false), query, xmlQuery);
    }

    public static QueryRequest createQuery(String query, byte ttl) {
        if (query == null) {
            throw new NullPointerException("null query");
        }
        if (query.length() == 0) {
            throw new IllegalArgumentException("empty query");
        }
        if (ttl <= 0 || ttl > 6) {
            throw new IllegalArgumentException("invalid TTL: " + ttl);
        }
        return new QueryRequest(QueryRequest.newQueryGUID(false), ttl, query);
    }

    public static QueryRequest createQuery(byte[] guid, String query, String xmlQuery) {
        query = I18NConvert.instance().getNorm(query);
        if (guid == null) {
            throw new NullPointerException("null guid");
        }
        if (guid.length != 16) {
            throw new IllegalArgumentException("invalid guid length");
        }
        if (query == null) {
            throw new NullPointerException("null query");
        }
        if (xmlQuery == null) {
            throw new NullPointerException("null xml query");
        }
        if (query.length() == 0 && xmlQuery.length() == 0) {
            throw new IllegalArgumentException("empty query");
        }
        if (xmlQuery.length() != 0 && !xmlQuery.startsWith("<?xml")) {
            throw new IllegalArgumentException("invalid XML");
        }
        return new QueryRequest(guid, query, xmlQuery);
    }

    public static QueryRequest createQuery(byte[] guid, String query, String xmlQuery, MediaType type) {
        query = I18NConvert.instance().getNorm(query);
        if (guid == null) {
            throw new NullPointerException("null guid");
        }
        if (guid.length != 16) {
            throw new IllegalArgumentException("invalid guid length");
        }
        if (query == null) {
            throw new NullPointerException("null query");
        }
        if (xmlQuery == null) {
            throw new NullPointerException("null xml query");
        }
        if (query.length() == 0 && xmlQuery.length() == 0) {
            throw new IllegalArgumentException("empty query");
        }
        if (xmlQuery.length() != 0 && !xmlQuery.startsWith("<?xml")) {
            throw new IllegalArgumentException("invalid XML");
        }
        return new QueryRequest(guid, 6, query, xmlQuery, type);
    }

    public static QueryRequest createQuery(QueryRequest qr, byte ttl) {
        return new QueryRequest(qr.getGUID(), ttl, qr.getQuery(), qr.getRichQueryString(), qr.getRequestedUrnTypes(), qr.getQueryUrns(), qr.getQueryKey(), qr.isFirewalledSource(), qr.getNetwork(), qr.desiresOutOfBandReplies(), qr.getCapabilitySelector(), qr.doNotProxy(), qr.getMetaMask());
    }

    public static QueryRequest createProxyQuery(QueryRequest qr, byte[] guid) {
        return new QueryRequest(guid, qr.getTTL(), qr.getQuery(), qr.getRichQueryString(), qr.getRequestedUrnTypes(), qr.getQueryUrns(), qr.getQueryKey(), qr.isFirewalledSource(), qr.getNetwork(), true, qr.getCapabilitySelector(), qr.doNotProxy(), qr.getMetaMask());
    }

    public static QueryRequest unmarkOOBQuery(QueryRequest qr) {
        return new QueryRequest(qr.getGUID(), qr.getTTL(), qr.getQuery(), qr.getRichQueryString(), qr.getRequestedUrnTypes(), qr.getQueryUrns(), qr.getQueryKey(), qr.isFirewalledSource(), qr.getNetwork(), false, qr.getCapabilitySelector(), qr.doNotProxy(), qr.getMetaMask());
    }

    public static QueryRequest createQueryKeyQuery(String query, QueryKey key) {
        if (query == null) {
            throw new NullPointerException("null query");
        }
        if (query.length() == 0) {
            throw new IllegalArgumentException("empty query");
        }
        if (key == null) {
            throw new NullPointerException("null query key");
        }
        return new QueryRequest(QueryRequest.newQueryGUID(false), 1, query, "", UrnType.ANY_TYPE_SET, EMPTY_SET, key, !RouterService.acceptedIncomingConnection(), -1, false, 0, false, 0);
    }

    public static QueryRequest createQueryKeyQuery(URN sha1, QueryKey key) {
        if (sha1 == null) {
            throw new NullPointerException("null sha1");
        }
        if (key == null) {
            throw new NullPointerException("null query key");
        }
        HashSet sha1Set = new HashSet();
        sha1Set.add(sha1);
        return new QueryRequest(QueryRequest.newQueryGUID(false), 1, DEFAULT_URN_QUERY, "", UrnType.SHA1_SET, sha1Set, key, !RouterService.acceptedIncomingConnection(), -1, false, 0, false, 0);
    }

    public static QueryRequest createMulticastQuery(QueryRequest qr) {
        if (qr == null) {
            throw new NullPointerException("null query");
        }
        QueryRequest mQr = new QueryRequest(qr.getGUID(), 1, qr.getQuery(), qr.getRichQueryString(), qr.getRequestedUrnTypes(), qr.getQueryUrns(), qr.getQueryKey(), false, 3, false, qr.getCapabilitySelector(), false, 0);
        mQr.setHops(qr.getHops());
        return mQr;
    }

    public static QueryRequest createQueryKeyQuery(QueryRequest qr, QueryKey key) {
        return new QueryRequest(qr.getGUID(), qr.getTTL(), qr.getQuery(), qr.getRichQueryString(), qr.getRequestedUrnTypes(), qr.getQueryUrns(), key, qr.isFirewalledSource(), -1, qr.desiresOutOfBandReplies(), qr.getCapabilitySelector(), false, qr.getMetaMask());
    }

    public static QueryRequest createBrowseHostQuery() {
        return new QueryRequest(QueryRequest.newQueryGUID(false), 1, "    ", "", UrnType.ANY_TYPE_SET, EMPTY_SET, null, false, -1, false, 0, false, 0);
    }

    public static QueryRequest createNonFirewalledQuery(String query, byte ttl) {
        return new QueryRequest(QueryRequest.newQueryGUID(false), ttl, query, "", UrnType.ANY_TYPE_SET, EMPTY_SET, null, false, -1, false, 0, false, 0);
    }

    public static QueryRequest createNetworkQuery(byte[] guid, byte ttl, byte hops, byte[] payload, int network) throws BadPacketException {
        return new QueryRequest(guid, ttl, hops, payload, network);
    }

    private QueryRequest(byte[] guid, String query) {
        this(guid, query, "");
    }

    private QueryRequest(byte[] guid, byte ttl, String query) {
        this(guid, ttl, query, "");
    }

    private QueryRequest(byte[] guid, String query, String xmlQuery) {
        this(guid, 6, query, xmlQuery);
    }

    private QueryRequest(byte[] guid, byte ttl, String query, String richQuery) {
        this(guid, ttl, query, richQuery, UrnType.ANY_TYPE_SET, EMPTY_SET, null, !RouterService.acceptedIncomingConnection(), -1, false, 0, false, 0);
    }

    private QueryRequest(byte[] guid, byte ttl, String query, String richQuery, MediaType type) {
        this(guid, ttl, query, richQuery, UrnType.ANY_TYPE_SET, EMPTY_SET, null, !RouterService.acceptedIncomingConnection(), -1, false, 0, false, QueryRequest.getMetaFlag(type));
    }

    private QueryRequest(byte[] guid, byte ttl, String query, String richQuery, boolean canReceiveOutOfBandReplies) {
        this(guid, ttl, query, richQuery, UrnType.ANY_TYPE_SET, EMPTY_SET, null, !RouterService.acceptedIncomingConnection(), -1, canReceiveOutOfBandReplies, 0, false, 0);
    }

    private QueryRequest(byte[] guid, byte ttl, String query, String richQuery, boolean canReceiveOutOfBandReplies, MediaType type) {
        this(guid, ttl, query, richQuery, UrnType.ANY_TYPE_SET, EMPTY_SET, null, !RouterService.acceptedIncomingConnection(), -1, canReceiveOutOfBandReplies, 0, false, QueryRequest.getMetaFlag(type));
    }

    private static int getMetaFlag(MediaType type) {
        int metaFlag = 0;
        if (type != null) {
            if (type.getDescriptionKey() == "MEDIA_AUDIO") {
                metaFlag |= 4;
            } else if (type.getDescriptionKey() == "MEDIA_VIDEO") {
                metaFlag |= 8;
            } else if (type.getDescriptionKey() == "MEDIA_IMAGES") {
                metaFlag |= 0x20;
            } else if (type.getDescriptionKey() == "MEDIA_DOCUMENTS") {
                metaFlag |= 0x10;
            } else if (type.getDescriptionKey() == "MEDIA_PROGRAMS") {
                if (CommonUtils.isLinux() || CommonUtils.isAnyMac()) {
                    metaFlag |= 0x80;
                } else if (CommonUtils.isWindows()) {
                    metaFlag |= 0x40;
                }
            }
        }
        return metaFlag;
    }

    public QueryRequest(byte[] guid, byte ttl, String query, String richQuery, Set requestedUrnTypes, Set queryUrns, QueryKey queryKey, boolean isFirewalled, int network, boolean canReceiveOutOfBandReplies, int capabilitySelector) {
        this(guid, ttl, query, richQuery, requestedUrnTypes, queryUrns, queryKey, isFirewalled, network, canReceiveOutOfBandReplies, capabilitySelector, false, 0);
    }

    public QueryRequest(byte[] guid, byte ttl, String query, String richQuery, Set requestedUrnTypes, Set queryUrns, QueryKey queryKey, boolean isFirewalled, int network, boolean canReceiveOutOfBandReplies, int capabilitySelector, boolean doNotProxy, int metaFlagMask) {
        super(guid, (byte)-128, ttl, (byte)0, 0, network);
        if (!(query != null && query.length() != 0 || richQuery != null && richQuery.length() != 0 || queryUrns != null && queryUrns.size() != 0)) {
            throw new IllegalArgumentException("cannot create empty query");
        }
        if (capabilitySelector < 0) {
            throw new IllegalArgumentException("Bad capability = " + capabilitySelector);
        }
        this._capabilitySelector = capabilitySelector;
        if (metaFlagMask > 0 && metaFlagMask < 4 || metaFlagMask > 248) {
            throw new IllegalArgumentException("Bad Meta Flag = " + metaFlagMask);
        }
        if (metaFlagMask > 0) {
            this._metaMask = new Integer(metaFlagMask);
        }
        int minSpeed = 128;
        if (isFirewalled && !this.isMulticast()) {
            minSpeed |= 0x40;
        }
        minSpeed = !canReceiveOutOfBandReplies ? (minSpeed |= 0x20) : (minSpeed |= 4);
        this.MIN_SPEED = minSpeed;
        this.QUERY = query == null ? "" : query;
        if (richQuery == null || richQuery.equals("")) {
            this.XML_DOC = null;
        } else {
            LimeXMLDocument doc = null;
            try {
                doc = new LimeXMLDocument(richQuery);
            }
            catch (SAXException ignored) {
            }
            catch (SchemaNotFoundException ignored) {
            }
            catch (IOException ignored) {
                // empty catch block
            }
            this.XML_DOC = doc;
        }
        Set tempRequestedUrnTypes = null;
        Set tempQueryUrns = null;
        tempRequestedUrnTypes = requestedUrnTypes != null ? new HashSet(requestedUrnTypes) : EMPTY_SET;
        tempQueryUrns = queryUrns != null ? new HashSet(queryUrns) : EMPTY_SET;
        this.QUERY_KEY = queryKey;
        this._doNotProxy = doNotProxy;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ByteOrder.short2leb((short)this.MIN_SPEED, baos);
            baos.write(this.QUERY.getBytes("UTF-8"));
            baos.write(0);
            boolean addDelimiterBefore = false;
            byte[] richQueryBytes = null;
            if (this.XML_DOC != null) {
                richQueryBytes = richQuery.getBytes("UTF-8");
            }
            addDelimiterBefore = this.writeGemExtension((OutputStream)baos, addDelimiterBefore, richQueryBytes);
            addDelimiterBefore = this.writeGemExtensions(baos, addDelimiterBefore, tempQueryUrns == null ? null : tempQueryUrns.iterator());
            addDelimiterBefore = this.writeGemExtensions(baos, addDelimiterBefore, tempRequestedUrnTypes == null ? null : tempRequestedUrnTypes.iterator());
            GGEP ggepBlock = new GGEP(false);
            if (this.QUERY_KEY != null) {
                ByteArrayOutputStream qkBytes = new ByteArrayOutputStream();
                this.QUERY_KEY.write(qkBytes);
                ggepBlock.put("QK", qkBytes.toByteArray());
            }
            if (this._capabilitySelector > 0) {
                ggepBlock.put("WH", this._capabilitySelector);
            }
            if (doNotProxy) {
                ggepBlock.put("NP");
            }
            if (this._metaMask != null) {
                ggepBlock.put("M", this._metaMask);
            }
            if (this.QUERY_KEY != null || this._capabilitySelector > 0 || this._doNotProxy || this._metaMask != null) {
                ByteArrayOutputStream ggepBytes = new ByteArrayOutputStream();
                ggepBlock.write(ggepBytes);
                addDelimiterBefore = this.writeGemExtension((OutputStream)baos, addDelimiterBefore, ggepBytes.toByteArray());
            }
            baos.write(0);
        }
        catch (UnsupportedEncodingException uee) {
            throw new IllegalArgumentException("could not get UTF-8 bytes for query :" + this.QUERY + " with richquery :" + richQuery);
        }
        catch (IOException e) {
            ErrorService.error(e);
        }
        this.PAYLOAD = baos.toByteArray();
        this.updateLength(this.PAYLOAD.length);
        this.QUERY_URNS = Collections.unmodifiableSet(tempQueryUrns);
        this.REQUESTED_URN_TYPES = Collections.unmodifiableSet(tempRequestedUrnTypes);
    }

    private QueryRequest(byte[] guid, byte ttl, byte hops, byte[] payload, int network) throws BadPacketException {
        super(guid, (byte)-128, ttl, hops, payload.length, network);
        if (payload == null) {
            throw new BadPacketException("no payload");
        }
        this.PAYLOAD = payload;
        String tempQuery = "";
        String tempRichQuery = "";
        int tempMinSpeed = 0;
        Set tempQueryUrns = null;
        HashSet tempRequestedUrnTypes = null;
        QueryKey tempQueryKey = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.PAYLOAD);
            short sp = ByteOrder.leb2short(bais);
            tempMinSpeed = ByteOrder.ubytes2int(sp);
            tempQuery = new String(super.readNullTerminatedBytes(bais), "UTF-8");
            byte[] extsBytes = super.readNullTerminatedBytes(bais);
            int currIndex = 0;
            while (currIndex < extsBytes.length && extsBytes[currIndex] != 0) {
                if (extsBytes[currIndex] == -61) {
                    int[] endIndex = new int[]{currIndex + 1};
                    String QK_SUPP = "QK";
                    try {
                        GGEP ggep = new GGEP(extsBytes, currIndex, endIndex);
                        if (ggep.hasKey("QK")) {
                            byte[] qkBytes = ggep.getBytes("QK");
                            tempQueryKey = QueryKey.getQueryKey(qkBytes, false);
                        }
                        if (ggep.hasKey("WH")) {
                            this._capabilitySelector = ggep.getInt("WH");
                        }
                        if (ggep.hasKey("NP")) {
                            this._doNotProxy = true;
                        }
                        if (ggep.hasKey("M")) {
                            this._metaMask = new Integer(ggep.getInt("M"));
                            if (this._metaMask < 4 || this._metaMask > 248) {
                                this._metaMask = null;
                            }
                        }
                    }
                    catch (BadGGEPBlockException ignored) {
                    }
                    catch (BadGGEPPropertyException ignored) {
                        // empty catch block
                    }
                    currIndex = endIndex[0];
                    continue;
                }
                int delimIndex = currIndex;
                while (delimIndex < extsBytes.length && extsBytes[delimIndex] != 28) {
                    ++delimIndex;
                }
                if (delimIndex <= extsBytes.length) {
                    String curExtStr = new String(extsBytes, currIndex, delimIndex - currIndex, "UTF-8");
                    if (URN.isUrn(curExtStr)) {
                        URN urn = null;
                        try {
                            urn = URN.createSHA1Urn(curExtStr);
                        }
                        catch (IOException e) {
                            continue;
                        }
                        if (tempQueryUrns == null) {
                            tempQueryUrns = new HashSet();
                        }
                        tempQueryUrns.add(urn);
                    } else if (UrnType.isSupportedUrnType(curExtStr)) {
                        if (tempRequestedUrnTypes == null) {
                            tempRequestedUrnTypes = new HashSet();
                        }
                        if (UrnType.isSupportedUrnType(curExtStr)) {
                            tempRequestedUrnTypes.add(UrnType.createUrnType(curExtStr));
                        }
                    } else if (curExtStr.startsWith("<?xml")) {
                        tempRichQuery = curExtStr;
                    }
                }
                currIndex = delimIndex + 1;
            }
        }
        catch (UnsupportedEncodingException uee) {
            throw new BadPacketException("encountered UnsupportedEncodingException with data snatched from network");
        }
        catch (IOException ioe) {
            ErrorService.error(ioe);
        }
        this.QUERY = tempQuery;
        LimeXMLDocument tempDoc = null;
        try {
            tempDoc = new LimeXMLDocument(tempRichQuery);
        }
        catch (SAXException ignored) {
        }
        catch (SchemaNotFoundException ignored) {
        }
        catch (IOException ignored) {
            // empty catch block
        }
        this.XML_DOC = tempDoc;
        this.MIN_SPEED = tempMinSpeed;
        this.QUERY_URNS = tempQueryUrns == null ? EMPTY_SET : Collections.unmodifiableSet(tempQueryUrns);
        this.REQUESTED_URN_TYPES = tempRequestedUrnTypes == null ? EMPTY_SET : Collections.unmodifiableSet(tempRequestedUrnTypes);
        this.QUERY_KEY = tempQueryKey;
        if (this.QUERY.length() == 0 && tempRichQuery.length() == 0 && this.QUERY_URNS.size() == 0) {
            if (Message.RECORD_STATS) {
                ReceivedErrorStat.QUERY_EMPTY.incrementStat();
            }
            throw new BadPacketException("empty query");
        }
        if (this.QUERY.length() > MAX_QUERY_LENGTH) {
            if (Message.RECORD_STATS) {
                ReceivedErrorStat.QUERY_TOO_LARGE.incrementStat();
            }
            throw BadPacketException.QUERY_TOO_BIG;
        }
        if (tempRichQuery.length() > MAX_XML_QUERY_LENGTH) {
            if (Message.RECORD_STATS) {
                ReceivedErrorStat.QUERY_XML_TOO_LARGE.incrementStat();
            }
            throw BadPacketException.XML_QUERY_TOO_BIG;
        }
        if ((this.QUERY_URNS.size() <= 0 || !this.QUERY.equals(DEFAULT_URN_QUERY)) && QueryRequest.hasIllegalChars(this.QUERY)) {
            if (Message.RECORD_STATS) {
                ReceivedErrorStat.QUERY_ILLEGAL_CHARS.incrementStat();
            }
            throw BadPacketException.ILLEGAL_CHAR_IN_QUERY;
        }
    }

    private static boolean hasIllegalChars(String query) {
        char[] chars = query.toCharArray();
        Arrays.sort(chars);
        int i = 0;
        while (i < ILLEGAL_CHARS.length) {
            if (Arrays.binarySearch(chars, ILLEGAL_CHARS[i]) >= 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static byte[] newQueryGUID(boolean isRequery) {
        return isRequery ? GUID.makeGuidRequery() : GUID.makeGuid();
    }

    protected void writePayload(OutputStream out) throws IOException {
        out.write(this.PAYLOAD);
        if (Message.RECORD_STATS) {
            SentMessageStatHandler.TCP_QUERY_REQUESTS.addMessage(this);
        }
    }

    public byte[] getPayload() {
        return this.PAYLOAD;
    }

    public String getQuery() {
        return this.QUERY;
    }

    public LimeXMLDocument getRichQuery() {
        return this.XML_DOC;
    }

    private String getRichQueryString() {
        if (this.XML_DOC == null) {
            return null;
        }
        try {
            return this.XML_DOC.getXMLString();
        }
        catch (SchemaNotFoundException snfe) {
            return null;
        }
    }

    public Set getRequestedUrnTypes() {
        return this.REQUESTED_URN_TYPES;
    }

    public Set getQueryUrns() {
        return this.QUERY_URNS;
    }

    public boolean hasQueryUrns() {
        return !this.QUERY_URNS.isEmpty();
    }

    public int getMinSpeed() {
        return this.MIN_SPEED;
    }

    public boolean isFirewalledSource() {
        return !this.isMulticast() && (this.MIN_SPEED & 0x80) > 0 && (this.MIN_SPEED & 0x40) > 0;
    }

    public boolean desiresXMLResponses() {
        return (this.MIN_SPEED & 0x80) > 0 && (this.MIN_SPEED & 0x20) > 0;
    }

    public boolean desiresOutOfBandReplies() {
        return (this.MIN_SPEED & 0x80) > 0 && (this.MIN_SPEED & 4) > 0;
    }

    public boolean doNotProxy() {
        return this._doNotProxy;
    }

    public boolean isWhatIsNewRequest() {
        return this._capabilitySelector == WHAT_IS_NEW_GGEP_VALUE;
    }

    public int getCapabilitySelector() {
        return this._capabilitySelector;
    }

    public String getReplyAddress() {
        return new GUID(this.getGUID()).getIP();
    }

    public boolean matchesReplyAddress(byte[] ip) {
        return new GUID(this.getGUID()).matchesIP(ip);
    }

    public int getReplyPort() {
        return new GUID(this.getGUID()).getPort();
    }

    public boolean isLimeRequery() {
        return GUID.isLimeRequeryGUID(this.getGUID());
    }

    public QueryKey getQueryKey() {
        return this.QUERY_KEY;
    }

    public boolean desiresAll() {
        return this._metaMask == null;
    }

    public boolean desiresAudio() {
        if (this._metaMask != null) {
            return (this._metaMask & 4) > 0;
        }
        return true;
    }

    public boolean desiresVideo() {
        if (this._metaMask != null) {
            return (this._metaMask & 8) > 0;
        }
        return true;
    }

    public boolean desiresDocuments() {
        if (this._metaMask != null) {
            return (this._metaMask & 0x10) > 0;
        }
        return true;
    }

    public boolean desiresImages() {
        if (this._metaMask != null) {
            return (this._metaMask & 0x20) > 0;
        }
        return true;
    }

    public boolean desiresWindowsPrograms() {
        if (this._metaMask != null) {
            return (this._metaMask & 0x40) > 0;
        }
        return true;
    }

    public boolean desiresLinuxOSXPrograms() {
        if (this._metaMask != null) {
            return (this._metaMask & 0x80) > 0;
        }
        return true;
    }

    private int getMetaMask() {
        if (this._metaMask != null) {
            return this._metaMask;
        }
        return 0;
    }

    public void recordDrop() {
        if (Message.RECORD_STATS) {
            DroppedSentMessageStatHandler.TCP_QUERY_REQUESTS.addMessage(this);
        }
    }

    public Message stripExtendedPayload() {
        return this;
    }

    public int hashCode() {
        if (this._hashCode == 0) {
            int result = 17;
            result = 37 * result + this.QUERY.hashCode();
            if (this.XML_DOC != null) {
                result = 37 * result + this.XML_DOC.hashCode();
            }
            result = 37 * result + this.REQUESTED_URN_TYPES.hashCode();
            result = 37 * result + this.QUERY_URNS.hashCode();
            if (this.QUERY_KEY != null) {
                result = 37 * result + this.QUERY_KEY.hashCode();
            }
            this._hashCode = result;
        }
        return this._hashCode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        boolean bl;
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryRequest)) {
            return false;
        }
        QueryRequest qr = (QueryRequest)o;
        if (this.MIN_SPEED != qr.MIN_SPEED) return false;
        if (!this.QUERY.equals(qr.QUERY)) return false;
        if (this.XML_DOC == null) {
            if (qr.XML_DOC != null) return false;
            bl = true;
        } else {
            bl = this.XML_DOC.equals(qr.XML_DOC);
        }
        if (!bl) return false;
        if (!this.REQUESTED_URN_TYPES.equals(qr.REQUESTED_URN_TYPES)) return false;
        if (!this.QUERY_URNS.equals(qr.QUERY_URNS)) return false;
        if (!Arrays.equals(this.getGUID(), qr.getGUID())) return false;
        if (!Arrays.equals(this.PAYLOAD, qr.PAYLOAD)) return false;
        return true;
    }

    public String toString() {
        return "<query: \"" + this.getQuery() + "\", " + "ttl: " + this.getTTL() + ", " + "hops: " + this.getHops() + ", " + "meta: \"" + this.getRichQueryString() + "\", " + "types: " + this.getRequestedUrnTypes().size() + "," + "urns: " + this.getQueryUrns().size() + ">";
    }
}

