/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.handshaking;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.handshaking.AuthenticationHandshakeResponder;
import com.limegroup.gnutella.handshaking.HandshakeResponse;
import com.limegroup.gnutella.handshaking.HeaderNames;
import com.limegroup.gnutella.handshaking.UltrapeerHeaders;
import com.limegroup.gnutella.statistics.HandshakingStat;
import com.limegroup.gnutella.util.NetworkUtils;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;

public class UltrapeerHandshakeResponder
extends AuthenticationHandshakeResponder {
    public UltrapeerHandshakeResponder(String host) {
        super(RouterService.getConnectionManager(), host);
    }

    protected HandshakeResponse respondUnauthenticated(HandshakeResponse response, boolean outgoing) throws IOException {
        if (outgoing) {
            return this.respondToOutgoing(response);
        }
        return this.respondToIncoming(response);
    }

    private HandshakeResponse respondToOutgoing(HandshakeResponse response) {
        if (!this._manager.allowConnection(response)) {
            if (AuthenticationHandshakeResponder.RECORD_STATS) {
                HandshakingStat.UP_OUTGOING_REJECT_FULL.incrementStat();
            }
            return HandshakeResponse.createRejectOutgoingResponse();
        }
        Properties ret = new Properties();
        if (response.hasLeafGuidance()) {
            if (this._manager.allowLeafDemotion() && response.isGoodUltrapeer()) {
                if (AuthenticationHandshakeResponder.RECORD_STATS) {
                    HandshakingStat.UP_OUTGOING_GUIDANCE_FOLLOWED.incrementStat();
                }
                ((Hashtable)ret).put("X-Ultrapeer", "False");
            } else if (AuthenticationHandshakeResponder.RECORD_STATS) {
                HandshakingStat.UP_OUTGOING_GUIDANCE_IGNORED.incrementStat();
            }
        } else if (AuthenticationHandshakeResponder.RECORD_STATS) {
            HandshakingStat.UP_OUTGOING_ACCEPT.incrementStat();
        }
        if (response.isDeflateAccepted()) {
            ((Hashtable)ret).put(HeaderNames.CONTENT_ENCODING, HeaderNames.DEFLATE_VALUE);
        }
        return HandshakeResponse.createAcceptOutgoingResponse(ret);
    }

    private HandshakeResponse respondToIncoming(HandshakeResponse response) {
        if (response.isCrawler()) {
            if (AuthenticationHandshakeResponder.RECORD_STATS) {
                HandshakingStat.INCOMING_CRAWLER.incrementStat();
            }
            return HandshakeResponse.createCrawlerResponse();
        }
        UltrapeerHeaders ret = new UltrapeerHeaders(this.getRemoteIP());
        ((Hashtable)ret).put("Listen-IP", NetworkUtils.ip2string(RouterService.getAddress()) + ":" + RouterService.getPort());
        if (this.reject(response, ret)) {
            return HandshakeResponse.createUltrapeerRejectIncomingResponse(response);
        }
        if (response.isDeflateAccepted()) {
            ((Hashtable)ret).put(HeaderNames.CONTENT_ENCODING, HeaderNames.DEFLATE_VALUE);
        }
        return HandshakeResponse.createAcceptIncomingResponse(response, ret);
    }

    private boolean reject(HandshakeResponse response, Properties ret) {
        boolean allowedAsLeaf = this._manager.allowConnectionAsLeaf(response);
        if (response.isLeaf()) {
            if (AuthenticationHandshakeResponder.RECORD_STATS) {
                if (!allowedAsLeaf) {
                    HandshakingStat.UP_INCOMING_REJECT_LEAF.incrementStat();
                } else {
                    HandshakingStat.UP_INCOMING_ACCEPT_LEAF.incrementStat();
                }
            }
            return !allowedAsLeaf;
        }
        boolean supernodeNeeded = this._manager.supernodeNeeded();
        if (allowedAsLeaf && !supernodeNeeded) {
            if (AuthenticationHandshakeResponder.RECORD_STATS) {
                HandshakingStat.UP_INCOMING_GUIDED.incrementStat();
            }
            ((Hashtable)ret).put("X-Ultrapeer-Needed", Boolean.FALSE.toString());
            return false;
        }
        boolean allowedAsUltrapeer = this._manager.allowConnection(response);
        if (allowedAsUltrapeer) {
            if (AuthenticationHandshakeResponder.RECORD_STATS) {
                HandshakingStat.UP_INCOMING_ACCEPT_UP.incrementStat();
            }
            ((Hashtable)ret).put("X-Ultrapeer-Needed", Boolean.TRUE.toString());
            return false;
        }
        if (AuthenticationHandshakeResponder.RECORD_STATS) {
            if (!allowedAsLeaf) {
                HandshakingStat.UP_INCOMING_REJECT_NO_ROOM_LEAF.incrementStat();
            } else {
                HandshakingStat.UP_INCOMING_REJECT_NO_ROOM_UP.incrementStat();
            }
        }
        return true;
    }
}

