/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.upload;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.tables.AbstractTableMediator;
import com.limegroup.gnutella.gui.tables.DataLine;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.tables.TableSettings;
import com.limegroup.gnutella.gui.upload.BrowseListener;
import com.limegroup.gnutella.gui.upload.ChatListener;
import com.limegroup.gnutella.gui.upload.ClearListener;
import com.limegroup.gnutella.gui.upload.UploadButtons;
import com.limegroup.gnutella.gui.upload.UploadDataLine;
import com.limegroup.gnutella.gui.upload.UploadModel;
import com.limegroup.gnutella.gui.upload.UploadPopupMenu;
import com.limegroup.gnutella.settings.SharingSettings;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.HashSet;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;

public final class UploadMediator
extends AbstractTableMediator {
    private static int _totalUploads = 0;
    ActionListener CHAT_LISTENER;
    ActionListener CLEAR_LISTENER;
    ActionListener BROWSE_LISTENER;
    private static final String UPLOAD_TITLE = GUIMediator.getStringResource("UPLOAD_TITLE");
    private static final String ACTIVE = GUIMediator.getStringResource("UPLOAD_ACTIVE");
    private static final String QUEUED = GUIMediator.getStringResource("UPLOAD_QUEUED");
    private static UploadMediator _instance = new UploadMediator();
    private static boolean _chatEnabled;
    private static boolean _browseEnabled;

    public static UploadMediator instance() {
        return _instance;
    }

    protected void buildSettings() {
        this.SETTINGS = new TableSettings(this.ID){

            public boolean getDefaultTooltips() {
                return false;
            }
        };
    }

    protected void buildListeners() {
        super.buildListeners();
        this.CHAT_LISTENER = new ChatListener(this);
        this.CLEAR_LISTENER = new ClearListener(this);
        this.BROWSE_LISTENER = new BrowseListener(this);
    }

    protected void setupConstants() {
        this.MAIN_PANEL = new PaddedPanel(UPLOAD_TITLE);
        this.DATA_MODEL = new UploadModel();
        this.TABLE = new LimeJTable(this.DATA_MODEL);
        this.BUTTON_ROW = new UploadButtons(this).getComponent();
    }

    protected void updateSplashScreen() {
        GUIMediator.setSplashScreenString(GUIMediator.getStringResource("SPLASH_STATUS_UPLOAD_WINDOW"));
    }

    public UploadMediator() {
        super("UPLOAD_MEDIATOR");
        GUIMediator.addRefreshListener(this);
        GUIMediator.addThemeObserver(this);
    }

    public void doRefresh() {
        boolean inactivePresent = (Boolean)this.DATA_MODEL.refresh();
        this.setButtonEnabled(3, inactivePresent);
        RouterService rs = GUIMediator.instance().getRouter();
        this.MAIN_PANEL.setTitle(UPLOAD_TITLE + " (" + RouterService.getUploadManager().uploadsInProgress() + " " + ACTIVE + ", " + RouterService.getUploadManager().getNumQueuedUploads() + " " + QUEUED + ")");
    }

    public int getTotalUploads() {
        return _totalUploads;
    }

    public int getCurrentUploads() {
        return ((UploadModel)this.DATA_MODEL).getCurrentUploads();
    }

    public int getActiveUploads() {
        return ((UploadModel)this.DATA_MODEL).getRowCount();
    }

    public void add(Object uploader) {
        int idx;
        if (!this.DATA_MODEL.contains(uploader) && (idx = this.DATA_MODEL.update(uploader)) == -1) {
            ++_totalUploads;
            super.add(uploader);
        }
    }

    public void remove(Object uploader) {
        if (SharingSettings.CLEAR_UPLOAD.getValue() && ((Uploader)uploader).isInactive()) {
            int i = this.DATA_MODEL.getRow(uploader);
            if (i != -1) {
                ((UploadDataLine)this.DATA_MODEL.get(i)).setPersistConnection(true);
                super.removeRow(i);
            }
        } else {
            UploadDataLine udl = (UploadDataLine)this.DATA_MODEL.get(uploader);
            if (udl != null) {
                udl.setEndTime(System.currentTimeMillis());
            }
        }
    }

    public void removeSelection() {
        int[] sel = this.TABLE.getSelectedRows();
        Arrays.sort(sel);
        int counter = sel.length - 1;
        while (counter >= 0) {
            int i = sel[counter];
            this.DATA_MODEL.get(i).cleanup();
            --counter;
        }
    }

    void chatWithSelectedUploads() {
        RouterService backend = GUIMediator.instance().getRouter();
        int[] sel = this.TABLE.getSelectedRows();
        int i = 0;
        while (i < sel.length) {
            DataLine dl = this.DATA_MODEL.get(sel[i]);
            Uploader uploader = (Uploader)dl.getInitializeObject();
            if (uploader.isChatEnabled()) {
                String host = uploader.getHost();
                int port = uploader.getGnutellaPort();
                RouterService.createChat(host, port);
            }
            ++i;
        }
    }

    void browseWithSelectedUploads() {
        boolean found = false;
        int[] sel = this.TABLE.getSelectedRows();
        HashSet searched = new HashSet(sel.length);
        int i = 0;
        while (i < sel.length) {
            DataLine dl = this.DATA_MODEL.get(sel[i]);
            Uploader uploader = (Uploader)dl.getInitializeObject();
            if (uploader.isBrowseHostEnabled()) {
                String host = uploader.getHost();
                int port = uploader.getGnutellaPort();
                if (!searched.contains(host)) {
                    SearchMediator.doBrowseHost(host, port, null);
                    searched.add(host);
                    found = true;
                }
            }
            ++i;
        }
        if (found) {
            GUIMediator.instance().setWindow(0);
        }
    }

    public void handleMouseDoubleClick(MouseEvent e) {
    }

    void clearCompletedUploads() {
        ((UploadModel)this.DATA_MODEL).clearCompleted();
        this.clearSelection();
        this.setButtonEnabled(3, false);
    }

    protected JPopupMenu createPopupMenu() {
        JPopupMenu menu = new UploadPopupMenu(this).getComponent();
        menu.getComponent(0).setEnabled(!this.TABLE.getSelectionModel().isSelectionEmpty());
        menu.getComponent(1).setEnabled(_chatEnabled);
        menu.getComponent(2).setEnabled(_browseEnabled);
        return menu;
    }

    public void handleSelection(int row) {
        UploadDataLine dataLine = (UploadDataLine)this.DATA_MODEL.get(row);
        _chatEnabled = dataLine.isChatEnabled();
        _browseEnabled = dataLine.isBrowseEnabled();
        this.setButtonEnabled(0, !this.TABLE.getSelectionModel().isSelectionEmpty());
        this.setButtonEnabled(1, _chatEnabled);
        this.setButtonEnabled(2, _browseEnabled);
    }

    public void handleNoSelection() {
        _chatEnabled = false;
        _browseEnabled = false;
        this.setButtonEnabled(0, false);
        this.setButtonEnabled(1, false);
        this.setButtonEnabled(2, false);
    }
}

