/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.upload;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.IconManager;
import com.limegroup.gnutella.gui.tables.AbstractDataLine;
import com.limegroup.gnutella.gui.tables.IconAndNameHolderImpl;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import com.limegroup.gnutella.gui.tables.SizeHolder;
import com.limegroup.gnutella.gui.tables.TimeRemainingHolder;
import com.limegroup.gnutella.http.HTTPRequestMethod;
import javax.swing.Icon;

public final class UploadDataLine
extends AbstractDataLine {
    private Uploader UPLOADER;
    private static final String CONNECTING_STATE = GUIMediator.getStringResource("UPLOAD_TABLE_STRING_CONNECTING");
    private static final String UPLOADING_STATE = GUIMediator.getStringResource("UPLOAD_TABLE_STRING_UPLOADING");
    private static final String LIMIT_REACHED_STATE = GUIMediator.getStringResource("UPLOAD_TABLE_STRING_LIMITREACHED");
    private static final String FREELOADER_STATE = GUIMediator.getStringResource("UPLOAD_TABLE_STRING_FREELOADER");
    private static final String INTERRUPTED_STATE = GUIMediator.getStringResource("UPLOAD_TABLE_STRING_INTERRUPTED");
    private static final String COMPLETE_STATE = GUIMediator.getStringResource("UPLOAD_TABLE_STRING_COMPLETE");
    private static final String FILE_NOT_FOUND_STATE = GUIMediator.getStringResource("UPLOAD_TABLE_STRING_FNF");
    private static final String QUEUED_STATE = GUIMediator.getStringResource("UPLOAD_TABLE_STRING_QUEUED");
    private static final String UNAVAILABLE_RANGE_STATE = GUIMediator.getStringResource("UPLOAD_TABLE_STRING_UNAVAILABLE_RANGE");
    private static final String MALFORMED_REQUEST_STATE = GUIMediator.getStringResource("UPLOAD_TABLE_STRING_MALFORMED_REQUEST");
    private static final String BANNED_GREEDY_STATE = GUIMediator.getStringResource("UPLOAD_TABLE_STRING_BANNED_GREEDY");
    private static final String HASH_TREE_STATE = GUIMediator.getStringResource("UPLOAD_TABLE_STRING_HASH_TREE");
    private static final String AVERAGE_BANDWIDTH = GUIMediator.getStringResource("GENERAL_AVERAGE_BANDWIDTH");
    private static final String STARTED_ON = GUIMediator.getStringResource("GENERAL_STARTED_ON");
    private static final String FINISHED_ON = GUIMediator.getStringResource("GENERAL_FINISHED_ON");
    private static final String TIME_SPENT = GUIMediator.getStringResource("GENERAL_TIME_SPENT");
    private String _fileName;
    private String _status;
    private String _hostName;
    private String _userAgent;
    private int _progress;
    private boolean _chatEnabled;
    private boolean _browseEnabled;
    private double _speed;
    private int _timeLeft;
    private boolean _persistConnection;
    private long _startTime;
    private long _endTime = -1L;
    private int _state;
    static final int FILE_INDEX = 0;
    private static final LimeTableColumn FILE_COLUMN = new LimeTableColumn(0, "UPLOAD_TABLE_STRING_NAME", 160, true, class$com$limegroup$gnutella$gui$tables$IconAndNameHolder == null ? (class$com$limegroup$gnutella$gui$tables$IconAndNameHolder = UploadDataLine.class$("com.limegroup.gnutella.gui.tables.IconAndNameHolder")) : class$com$limegroup$gnutella$gui$tables$IconAndNameHolder);
    static final int HOST_INDEX = 1;
    private static final LimeTableColumn HOST_COLUMN = new LimeTableColumn(1, "UPLOAD_TABLE_STRING_HOST", 70, true, class$java$lang$String == null ? (class$java$lang$String = UploadDataLine.class$("java.lang.String")) : class$java$lang$String);
    static final int SIZE_INDEX = 2;
    private static final LimeTableColumn SIZE_COLUMN = new LimeTableColumn(2, "UPLOAD_TABLE_STRING_SIZE", 25, true, class$com$limegroup$gnutella$gui$tables$SizeHolder == null ? (class$com$limegroup$gnutella$gui$tables$SizeHolder = UploadDataLine.class$("com.limegroup.gnutella.gui.tables.SizeHolder")) : class$com$limegroup$gnutella$gui$tables$SizeHolder);
    static final int STATUS_INDEX = 3;
    private static final LimeTableColumn STATUS_COLUMN = new LimeTableColumn(3, "UPLOAD_TABLE_STRING_STATUS", 100, true, class$java$lang$String == null ? (class$java$lang$String = UploadDataLine.class$("java.lang.String")) : class$java$lang$String);
    static final int CHAT_INDEX = 4;
    private static final LimeTableColumn CHAT_COLUMN = new LimeTableColumn(4, "UPLOAD_TABLE_STRING_CHAT", 10, true, class$com$limegroup$gnutella$gui$tables$ChatHolder == null ? (class$com$limegroup$gnutella$gui$tables$ChatHolder = UploadDataLine.class$("com.limegroup.gnutella.gui.tables.ChatHolder")) : class$com$limegroup$gnutella$gui$tables$ChatHolder);
    static final int PROGRESS_INDEX = 5;
    private static final LimeTableColumn PROGRESS_COLUMN = new LimeTableColumn(5, "UPLOAD_TABLE_STRING_PROGRESS", 25, true, class$com$limegroup$gnutella$gui$tables$ProgressBarHolder == null ? (class$com$limegroup$gnutella$gui$tables$ProgressBarHolder = UploadDataLine.class$("com.limegroup.gnutella.gui.tables.ProgressBarHolder")) : class$com$limegroup$gnutella$gui$tables$ProgressBarHolder);
    static final int SPEED_INDEX = 6;
    private static final LimeTableColumn SPEED_COLUMN = new LimeTableColumn(6, "UPLOAD_TABLE_STRING_SPEED", 15, true, class$java$lang$String == null ? (class$java$lang$String = UploadDataLine.class$("java.lang.String")) : class$java$lang$String);
    static final int TIME_INDEX = 7;
    private static final LimeTableColumn TIME_COLUMN = new LimeTableColumn(7, "UPLOAD_TABLE_STRING_TIME_REMAINING", 15, true, class$com$limegroup$gnutella$gui$tables$TimeRemainingHolder == null ? (class$com$limegroup$gnutella$gui$tables$TimeRemainingHolder = UploadDataLine.class$("com.limegroup.gnutella.gui.tables.TimeRemainingHolder")) : class$com$limegroup$gnutella$gui$tables$TimeRemainingHolder);
    static final int USER_AGENT_INDEX = 8;
    private static final LimeTableColumn USER_AGENT_COLUMN = new LimeTableColumn(8, "UPLOAD_TABLE_STRING_USER_AGENT", 70, true, class$java$lang$String == null ? (class$java$lang$String = UploadDataLine.class$("java.lang.String")) : class$java$lang$String);
    static final int NUMBER_OF_COLUMNS = 9;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$tables$IconAndNameHolder;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$tables$SizeHolder;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$tables$ChatHolder;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$tables$ProgressBarHolder;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$tables$TimeRemainingHolder;

    public int getColumnCount() {
        return 9;
    }

    public void initialize(Object uploader) {
        super.initialize(uploader);
        if (this.UPLOADER != null) {
            this.UPLOADER = (Uploader)uploader;
        } else {
            this.UPLOADER = (Uploader)uploader;
            this._startTime = System.currentTimeMillis();
            this._chatEnabled = this.UPLOADER.isChatEnabled();
            this._browseEnabled = this.UPLOADER.isBrowseHostEnabled();
            this._fileName = this.UPLOADER.getFileName();
            this._hostName = this.UPLOADER.getHost();
            this._userAgent = this.UPLOADER.getUserAgent();
        }
        this._endTime = -1L;
        this._status = "";
        this._persistConnection = false;
        this.update();
    }

    public void cleanup() {
        if (!this._persistConnection) {
            this.UPLOADER.stop();
        }
    }

    public Object getValueAt(int index) {
        switch (index) {
            case 0: {
                FileDesc fd = this.UPLOADER.getFileDesc();
                Icon icon = fd == null ? null : IconManager.instance().getIconForFile(fd.getFile());
                return new IconAndNameHolderImpl(icon, this._fileName);
            }
            case 1: {
                return this._hostName;
            }
            case 2: {
                return new SizeHolder(this.getLength());
            }
            case 3: {
                return this._status;
            }
            case 4: {
                return this._chatEnabled ? Boolean.TRUE : Boolean.FALSE;
            }
            case 5: {
                return new Integer(this._progress);
            }
            case 6: {
                return this._speed == -1.0 ? "" : GUIUtils.rate2speed(this._speed);
            }
            case 7: {
                return new TimeRemainingHolder(this._timeLeft);
            }
            case 8: {
                return this._userAgent;
            }
        }
        return null;
    }

    public LimeTableColumn getColumn(int idx) {
        switch (idx) {
            case 0: {
                return FILE_COLUMN;
            }
            case 1: {
                return HOST_COLUMN;
            }
            case 2: {
                return SIZE_COLUMN;
            }
            case 3: {
                return STATUS_COLUMN;
            }
            case 4: {
                return CHAT_COLUMN;
            }
            case 5: {
                return PROGRESS_COLUMN;
            }
            case 6: {
                return SPEED_COLUMN;
            }
            case 7: {
                return TIME_COLUMN;
            }
            case 8: {
                return USER_AGENT_COLUMN;
            }
        }
        return null;
    }

    public boolean isClippable(int idx) {
        switch (idx) {
            case 4: 
            case 5: {
                return false;
            }
        }
        return true;
    }

    public String[] getToolTipArray(int col) {
        String[] info = new String[this._endTime != -1L ? 5 : 4];
        String tp = AVERAGE_BANDWIDTH + ": " + GUIUtils.rate2speed(this.UPLOADER.getAverageBandwidth());
        info[0] = STARTED_ON + GUIUtils.msec2DateTime(this._startTime);
        if (this._endTime != -1L) {
            info[1] = FINISHED_ON + GUIUtils.msec2DateTime(this._endTime);
            info[2] = TIME_SPENT + ": " + GUIUtils.seconds2time((int)((this._endTime - this._startTime) / 1000L));
            info[3] = "";
            info[4] = tp;
        } else {
            info[1] = TIME_SPENT + ": " + GUIUtils.seconds2time((int)((System.currentTimeMillis() - this._startTime) / 1000L));
            info[2] = "";
            info[3] = tp;
        }
        return info;
    }

    public boolean isDynamic(int idx) {
        switch (idx) {
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    int getLength() {
        return this.UPLOADER == null ? 0 : this.UPLOADER.getFileSize();
    }

    boolean containsUploader(Uploader uploader) {
        return this.UPLOADER.equals(uploader);
    }

    Uploader getUploader() {
        return this.UPLOADER;
    }

    String getHost() {
        return this.UPLOADER.getHost();
    }

    int getFileIndex() {
        return this.UPLOADER.getIndex();
    }

    int getState() {
        return this._state;
    }

    boolean isCompleted() {
        return this._state == 4;
    }

    boolean isChatEnabled() {
        return this._chatEnabled;
    }

    boolean isBrowseEnabled() {
        return this._browseEnabled;
    }

    public void update() {
        int state = this.UPLOADER.getState();
        int lastState = this.UPLOADER.getLastTransferState();
        if (state == 4 && this._endTime == -1L || state == 0 && this.UPLOADER.getTotalAmountUploaded() != 0) {
            state = lastState;
        }
        if (state == 4 && lastState != 3 && lastState != 9 && lastState != 15) {
            state = lastState;
        }
        this._speed = -1.0;
        this._timeLeft = 0;
        this.updateStatus(state);
    }

    private void updateStatus(int state) {
        this._state = state;
        switch (this._state) {
            case 0: {
                this._status = CONNECTING_STATE;
                break;
            }
            case 1: {
                this._status = FREELOADER_STATE;
                break;
            }
            case 4: {
                if (this._status != COMPLETE_STATE) {
                    this.setProgress();
                    if (this._progress == 99) {
                        this._progress = 100;
                    }
                }
                this._status = COMPLETE_STATE;
                break;
            }
            case 13: {
                this._status = UNAVAILABLE_RANGE_STATE;
                break;
            }
            case 11: {
                this._status = MALFORMED_REQUEST_STATE;
                break;
            }
            case 2: {
                this._status = LIMIT_REACHED_STATE;
                break;
            }
            case 5: {
                if (this._status != INTERRUPTED_STATE) {
                    this.setProgress();
                }
                this._status = INTERRUPTED_STATE;
                break;
            }
            case 7: {
                this._status = FILE_NOT_FOUND_STATE;
                break;
            }
            case 15: {
                this._status = HASH_TREE_STATE;
                this.setProgress();
                this.setSpeedAndTimeLeft();
                break;
            }
            case 3: {
                this._status = UPLOADING_STATE;
                this.setProgress();
                this.setSpeedAndTimeLeft();
                break;
            }
            case 8: {
                Assert.that(false, "Browse Host status in GUI Upload view");
                break;
            }
            case 9: {
                this._status = QUEUED_STATE + " (" + (this.UPLOADER.getQueuePosition() + 1) + ")";
                break;
            }
            case 14: {
                this._status = BANNED_GREEDY_STATE;
                break;
            }
            default: {
                Assert.that(false, "Unknown status " + this.UPLOADER.getState() + " of uploader");
            }
        }
    }

    private void setSpeedAndTimeLeft() {
        try {
            this._speed = this.UPLOADER.getMeasuredBandwidth();
        }
        catch (InsufficientDataException ide) {
            this._speed = 0.0;
        }
        if (this._speed > 0.0) {
            double kbLeft = ((double)this.getLength() - (double)this.UPLOADER.getTotalAmountUploaded()) / 1024.0;
            this._timeLeft = (int)(kbLeft / this._speed);
        }
    }

    private void setProgress() {
        double d = (double)this.UPLOADER.getTotalAmountUploaded() / (double)this.getLength();
        this._progress = (int)Math.round(d * 100.0);
    }

    boolean isInactive() {
        return this._endTime != -1L;
    }

    boolean isUploading() {
        return this._state == 3;
    }

    void setPersistConnection(boolean persist) {
        this._persistConnection = persist;
    }

    void setEndTime(long time) {
        this._endTime = time;
        this.UPLOADER = new FakeUploader(this.UPLOADER);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class FakeUploader
    implements Uploader {
        private final int idx;
        private final int tUp;
        private final int gPort;
        private final float mBand;
        private final float aBand;
        private final String name;
        private final int size;
        private final String host;
        private final int state;
        private final String agent;
        private final boolean chat;
        private final boolean browse;
        private final int lastState;
        private final FileDesc fd;

        FakeUploader(Uploader u) {
            float bandwidth;
            this.idx = u.getIndex();
            this.tUp = u.getTotalAmountUploaded();
            this.gPort = u.getGnutellaPort();
            try {
                bandwidth = u.getMeasuredBandwidth();
            }
            catch (InsufficientDataException e) {
                bandwidth = 0.0f;
            }
            this.mBand = bandwidth;
            this.aBand = u.getAverageBandwidth();
            this.name = u.getFileName();
            this.size = u.getFileSize();
            this.host = u.getHost();
            this.state = u.getState();
            this.chat = u.isChatEnabled();
            this.browse = u.isBrowseHostEnabled();
            this.agent = u.getUserAgent();
            this.lastState = u.getLastTransferState();
            this.fd = u.getFileDesc();
        }

        public void stop() {
        }

        public String getFileName() {
            return this.name;
        }

        public int getFileSize() {
            return this.size;
        }

        public int getAmountRequested() {
            return 0;
        }

        public FileDesc getFileDesc() {
            return this.fd;
        }

        public int getIndex() {
            return this.idx;
        }

        public int amountUploaded() {
            return 0;
        }

        public int getTotalAmountUploaded() {
            return this.tUp;
        }

        public String getHost() {
            return this.host;
        }

        public int getState() {
            return this.state;
        }

        public int getLastTransferState() {
            return this.lastState;
        }

        public void setState(int s) {
        }

        public void writeResponse() {
        }

        public boolean isChatEnabled() {
            return this.chat;
        }

        public boolean isBrowseHostEnabled() {
            return this.browse;
        }

        public int getGnutellaPort() {
            return this.gPort;
        }

        public String getUserAgent() {
            return this.agent;
        }

        public boolean isHeaderParsed() {
            return true;
        }

        public boolean supportsQueueing() {
            return false;
        }

        public HTTPRequestMethod getMethod() {
            return HTTPRequestMethod.HEAD;
        }

        public int getQueuePosition() {
            return -1;
        }

        public boolean isInactive() {
            return true;
        }

        public void measureBandwidth() {
        }

        public float getMeasuredBandwidth() {
            return this.mBand;
        }

        public float getAverageBandwidth() {
            return this.aBand;
        }
    }
}

