/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.statistics.panes;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.statistics.panes.AbstractOptionPaneItem;
import javax.swing.JLabel;

public final class NetStats
extends AbstractOptionPaneItem {
    private final JLabel CURRENT_HOSTS = new JLabel();
    private final JLabel TOTAL_HOSTS = new JLabel();
    private final JLabel TOTAL_FILES = new JLabel();
    private final JLabel TOTAL_FILE_SIZE = new JLabel();

    public NetStats() {
        super("NET_PANE");
        LabeledComponent comp0 = new LabeledComponent("STATS_NET", this.CURRENT_HOSTS, 130);
        LabeledComponent comp1 = new LabeledComponent("STATS_HOSTS", this.TOTAL_HOSTS, 130);
        LabeledComponent comp2 = new LabeledComponent("STATS_FILES", this.TOTAL_FILES, 130);
        LabeledComponent comp3 = new LabeledComponent("STATS_FILE_SIZE", this.TOTAL_FILE_SIZE, 130);
        this.add(comp0.getComponent());
        this.add(comp1.getComponent());
        this.add(comp2.getComponent());
        this.add(comp3.getComponent());
    }

    public void refresh() {
        int numConn = RouterService.getNumInitializedConnections();
        int numHosts = (int)RouterService.getNumHosts();
        long numFiles = RouterService.getNumFiles();
        long totSize = RouterService.getTotalFileSize();
        this.CURRENT_HOSTS.setText(GUIUtils.toLocalizedInteger(numConn));
        this.TOTAL_HOSTS.setText(GUIUtils.toLocalizedInteger(numHosts));
        this.TOTAL_FILES.setText(GUIUtils.toLocalizedInteger(numFiles));
        this.TOTAL_FILE_SIZE.setText(GUIUtils.toLocalizedInteger(totSize > 0L && totSize < 1024L ? 1L : (totSize + 512L) / 1024L));
    }
}

