/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.statistics.panes;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.TitledPaddedPanel;
import com.limegroup.gnutella.gui.statistics.panes.PaneItem;
import com.limegroup.gnutella.gui.statistics.panes.PaneItemMainLabel;
import com.limegroup.gnutella.gui.statistics.panes.StatisticDisplayer;
import com.limegroup.gnutella.statistics.Statistic;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import javax.swing.Box;
import javax.swing.JComponent;

public abstract class AbstractPaneItem
implements PaneItem {
    protected final StatisticDisplayer STAT_DISPLAYER;
    protected final TitledPaddedPanel CONTAINER = new TitledPaddedPanel();
    protected static final Component HORIZONTAL_SEPARATOR = Box.createRigidArea(new Dimension(6, 0));
    protected static final Component VERTICAL_SEPARATOR = Box.createRigidArea(new Dimension(0, 6));
    private final PaneItemMainLabel LABEL;

    protected AbstractPaneItem(String key, StatisticDisplayer statDisplayer) {
        this.STAT_DISPLAYER = statDisplayer;
        String title = "STATS_" + key + "_TITLE";
        String label = "STATS_" + key + "_LABEL";
        this.CONTAINER.setTitle(GUIMediator.getStringResource(title));
        this.LABEL = new PaneItemMainLabel(GUIMediator.getStringResource(label));
        this.add(this.LABEL.getLabel());
        this.add(statDisplayer.getComponent());
    }

    public JComponent getStatsComponent() {
        return this.STAT_DISPLAYER.getComponent();
    }

    public Container getContainer() {
        return this.CONTAINER;
    }

    protected final void add(Component comp) {
        this.CONTAINER.add(comp);
    }

    protected final Component getHorizontalSeparator() {
        return HORIZONTAL_SEPARATOR;
    }

    protected final Component getVerticalSeparator() {
        return VERTICAL_SEPARATOR;
    }

    protected void registerStatistic(Statistic stat, String displayName) {
        this.STAT_DISPLAYER.registerStatistic(stat, displayName);
    }

    protected void registerDualStatistic(Statistic stat0, Statistic stat1, String displayName) {
        this.STAT_DISPLAYER.registerDualStatistic(stat0, stat1, displayName);
    }

    public void refresh() {
        this.STAT_DISPLAYER.refresh();
    }

    public String toString() {
        return "AbstractPaneItem: " + this.CONTAINER.getTitle();
    }

    public void componentResized(ComponentEvent e, Component comp) {
        this.LABEL.componentResized(e, comp);
    }
}

