/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.statistics;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.RefreshListener;
import com.limegroup.gnutella.gui.ThemeObserver;
import com.limegroup.gnutella.gui.statistics.StatisticsConstructor;
import com.limegroup.gnutella.gui.statistics.StatisticsPaneManager;
import com.limegroup.gnutella.gui.statistics.StatisticsTreeManager;
import com.limegroup.gnutella.statistics.StatisticsManager;
import java.awt.Component;
import javax.swing.JComponent;

public final class StatisticsMediator
implements RefreshListener,
ThemeObserver {
    public static final String ROOT_NODE_KEY = "STATISTICS_ROOT_NODE";
    private static final StatisticsMediator INSTANCE = new StatisticsMediator();
    private static StatisticsTreeManager _treeManager = null;
    private static StatisticsPaneManager _paneManager = null;
    private static StatisticsConstructor _constructor = null;

    public static synchronized StatisticsMediator instance() {
        return INSTANCE;
    }

    private StatisticsMediator() {
        GUIMediator.setSplashScreenString(GUIMediator.getStringResource("SPLASH_STATUS_STATISTICS_WINDOW"));
    }

    public final void setStatisticsVisible(boolean visible) {
        if (_constructor == null) {
            if (!visible) {
                return;
            }
            this.updateTheme();
        }
        _constructor.setStatisticsVisible(visible);
    }

    public final boolean isStatisticsVisible() {
        if (_constructor == null) {
            return false;
        }
        return _constructor.isStatisticsVisible();
    }

    public final void handleSelection(String key) {
        _paneManager.show(key);
    }

    public Component getMainStatisticsComponent() {
        if (_constructor == null) {
            this.updateTheme();
        }
        return StatisticsConstructor.getMainComponent();
    }

    public JComponent getComponent() {
        if (_constructor == null) {
            this.updateTheme();
        }
        return StatisticsConstructor.getComponent();
    }

    public static JComponent getStatDisplayComponent() {
        if (_constructor == null) {
            INSTANCE.updateTheme();
        }
        return StatisticsConstructor.getStatDisplayComponent();
    }

    public void refresh() {
        if (this.isStatisticsVisible()) {
            _paneManager.refresh();
        }
    }

    public void setAdvancedStatsVisible(boolean visible) {
        if (_constructor == null) {
            this.updateTheme();
        }
        StatisticsManager.instance().setRecordAdvancedStats(visible);
        StatisticsConstructor.setAdvancedStatsVisible(visible);
    }

    public void updateTheme() {
        _treeManager = new StatisticsTreeManager();
        _paneManager = new StatisticsPaneManager();
        _constructor = new StatisticsConstructor(_treeManager, _paneManager);
    }
}

