/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.statistics;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.statistics.StatisticsButtonPanel;
import com.limegroup.gnutella.gui.statistics.StatisticsPane;
import com.limegroup.gnutella.gui.statistics.StatisticsPaneImpl;
import com.limegroup.gnutella.gui.statistics.StatisticsPaneManager;
import com.limegroup.gnutella.gui.statistics.StatisticsPaneParent;
import com.limegroup.gnutella.gui.statistics.StatisticsTreeManager;
import com.limegroup.gnutella.gui.statistics.VisibleStatsPane;
import com.limegroup.gnutella.gui.statistics.panes.AdvancedStats;
import com.limegroup.gnutella.gui.statistics.panes.AllBytesReceived;
import com.limegroup.gnutella.gui.statistics.panes.AllBytesSent;
import com.limegroup.gnutella.gui.statistics.panes.AllMessagesReceived;
import com.limegroup.gnutella.gui.statistics.panes.AllMessagesSent;
import com.limegroup.gnutella.gui.statistics.panes.BandwidthStats;
import com.limegroup.gnutella.gui.statistics.panes.CompressableDownstreamBandwidth;
import com.limegroup.gnutella.gui.statistics.panes.CompressableUpstreamBandwidth;
import com.limegroup.gnutella.gui.statistics.panes.ConnectionAttemptsPaneItem;
import com.limegroup.gnutella.gui.statistics.panes.DownloadAlternateLocations;
import com.limegroup.gnutella.gui.statistics.panes.DownloadConnections;
import com.limegroup.gnutella.gui.statistics.panes.DownloadResponses;
import com.limegroup.gnutella.gui.statistics.panes.DownloadTCPConnectTime;
import com.limegroup.gnutella.gui.statistics.panes.DownloadTransfers;
import com.limegroup.gnutella.gui.statistics.panes.ErrorGeneric;
import com.limegroup.gnutella.gui.statistics.panes.ErrorPingReplies;
import com.limegroup.gnutella.gui.statistics.panes.ErrorPushes;
import com.limegroup.gnutella.gui.statistics.panes.ErrorQueries;
import com.limegroup.gnutella.gui.statistics.panes.ErrorQueryReplies;
import com.limegroup.gnutella.gui.statistics.panes.ErrorVendorMessages;
import com.limegroup.gnutella.gui.statistics.panes.FilteredMessagesPaneItem;
import com.limegroup.gnutella.gui.statistics.panes.FlowControl;
import com.limegroup.gnutella.gui.statistics.panes.FlowControlBytes;
import com.limegroup.gnutella.gui.statistics.panes.HTTPRequestsPaneItem;
import com.limegroup.gnutella.gui.statistics.panes.HandshakingLeaf;
import com.limegroup.gnutella.gui.statistics.panes.HandshakingUltrapeer;
import com.limegroup.gnutella.gui.statistics.panes.HitHops;
import com.limegroup.gnutella.gui.statistics.panes.HitHopsBytes;
import com.limegroup.gnutella.gui.statistics.panes.HitTTL;
import com.limegroup.gnutella.gui.statistics.panes.HitTTLBytes;
import com.limegroup.gnutella.gui.statistics.panes.IncomingHandshaking;
import com.limegroup.gnutella.gui.statistics.panes.MulticastBytesReceived;
import com.limegroup.gnutella.gui.statistics.panes.MulticastBytesSent;
import com.limegroup.gnutella.gui.statistics.panes.MulticastDuplicateQueries;
import com.limegroup.gnutella.gui.statistics.panes.MulticastDuplicateQueriesBytes;
import com.limegroup.gnutella.gui.statistics.panes.MulticastLimeReceivedBytes;
import com.limegroup.gnutella.gui.statistics.panes.MulticastLimeReceivedMessages;
import com.limegroup.gnutella.gui.statistics.panes.MulticastLimeReceivedPings;
import com.limegroup.gnutella.gui.statistics.panes.MulticastLimeReceivedPingsBytes;
import com.limegroup.gnutella.gui.statistics.panes.MulticastLimeReceivedPongs;
import com.limegroup.gnutella.gui.statistics.panes.MulticastLimeReceivedPongsBytes;
import com.limegroup.gnutella.gui.statistics.panes.MulticastLimeReceivedPushRequests;
import com.limegroup.gnutella.gui.statistics.panes.MulticastLimeReceivedPushRequestsBytes;
import com.limegroup.gnutella.gui.statistics.panes.MulticastLimeReceivedQueries;
import com.limegroup.gnutella.gui.statistics.panes.MulticastLimeReceivedQueriesBytes;
import com.limegroup.gnutella.gui.statistics.panes.MulticastLimeReceivedQueryReplies;
import com.limegroup.gnutella.gui.statistics.panes.MulticastLimeReceivedQueryRepliesBytes;
import com.limegroup.gnutella.gui.statistics.panes.MulticastLimeSentBytes;
import com.limegroup.gnutella.gui.statistics.panes.MulticastLimeSentMessages;
import com.limegroup.gnutella.gui.statistics.panes.MulticastLimeSentPings;
import com.limegroup.gnutella.gui.statistics.panes.MulticastLimeSentPingsBytes;
import com.limegroup.gnutella.gui.statistics.panes.MulticastLimeSentPongs;
import com.limegroup.gnutella.gui.statistics.panes.MulticastLimeSentPongsBytes;
import com.limegroup.gnutella.gui.statistics.panes.MulticastLimeSentPushRequests;
import com.limegroup.gnutella.gui.statistics.panes.MulticastLimeSentPushRequestsBytes;
import com.limegroup.gnutella.gui.statistics.panes.MulticastLimeSentQueries;
import com.limegroup.gnutella.gui.statistics.panes.MulticastLimeSentQueriesBytes;
import com.limegroup.gnutella.gui.statistics.panes.MulticastLimeSentQueryReplies;
import com.limegroup.gnutella.gui.statistics.panes.MulticastLimeSentQueryRepliesBytes;
import com.limegroup.gnutella.gui.statistics.panes.MulticastMessagesReceived;
import com.limegroup.gnutella.gui.statistics.panes.MulticastMessagesSent;
import com.limegroup.gnutella.gui.statistics.panes.NetStats;
import com.limegroup.gnutella.gui.statistics.panes.OutOfBandThroughputPaneItem;
import com.limegroup.gnutella.gui.statistics.panes.OutgoingHandshaking;
import com.limegroup.gnutella.gui.statistics.panes.OutgoingServerReject;
import com.limegroup.gnutella.gui.statistics.panes.PaneItem;
import com.limegroup.gnutella.gui.statistics.panes.QueryHops;
import com.limegroup.gnutella.gui.statistics.panes.QueryHopsBytes;
import com.limegroup.gnutella.gui.statistics.panes.QueryReplyRouteErrors;
import com.limegroup.gnutella.gui.statistics.panes.QueryTTL;
import com.limegroup.gnutella.gui.statistics.panes.QueryTTLBytes;
import com.limegroup.gnutella.gui.statistics.panes.RouteErrorsPaneItem;
import com.limegroup.gnutella.gui.statistics.panes.RoutedIncomingLeafQueries;
import com.limegroup.gnutella.gui.statistics.panes.RoutedOutgoingLeafQueries;
import com.limegroup.gnutella.gui.statistics.panes.RoutedOutgoingUltrapeerQueries;
import com.limegroup.gnutella.gui.statistics.panes.TCPAverageMessageSize;
import com.limegroup.gnutella.gui.statistics.panes.TCPBytesReceived;
import com.limegroup.gnutella.gui.statistics.panes.TCPBytesSent;
import com.limegroup.gnutella.gui.statistics.panes.TCPDuplicateQueries;
import com.limegroup.gnutella.gui.statistics.panes.TCPDuplicateQueriesBytes;
import com.limegroup.gnutella.gui.statistics.panes.TCPLimeAverageMessageSize;
import com.limegroup.gnutella.gui.statistics.panes.TCPLimeReceivedBytes;
import com.limegroup.gnutella.gui.statistics.panes.TCPLimeReceivedMessages;
import com.limegroup.gnutella.gui.statistics.panes.TCPLimeReceivedPings;
import com.limegroup.gnutella.gui.statistics.panes.TCPLimeReceivedPingsBytes;
import com.limegroup.gnutella.gui.statistics.panes.TCPLimeReceivedPongs;
import com.limegroup.gnutella.gui.statistics.panes.TCPLimeReceivedPongsBytes;
import com.limegroup.gnutella.gui.statistics.panes.TCPLimeReceivedPushRequests;
import com.limegroup.gnutella.gui.statistics.panes.TCPLimeReceivedPushRequestsBytes;
import com.limegroup.gnutella.gui.statistics.panes.TCPLimeReceivedQueries;
import com.limegroup.gnutella.gui.statistics.panes.TCPLimeReceivedQueriesBytes;
import com.limegroup.gnutella.gui.statistics.panes.TCPLimeReceivedQueryReplies;
import com.limegroup.gnutella.gui.statistics.panes.TCPLimeReceivedQueryRepliesBytes;
import com.limegroup.gnutella.gui.statistics.panes.TCPLimeSentBytes;
import com.limegroup.gnutella.gui.statistics.panes.TCPLimeSentMessages;
import com.limegroup.gnutella.gui.statistics.panes.TCPLimeSentPings;
import com.limegroup.gnutella.gui.statistics.panes.TCPLimeSentPingsBytes;
import com.limegroup.gnutella.gui.statistics.panes.TCPLimeSentPongs;
import com.limegroup.gnutella.gui.statistics.panes.TCPLimeSentPongsBytes;
import com.limegroup.gnutella.gui.statistics.panes.TCPLimeSentPushRequests;
import com.limegroup.gnutella.gui.statistics.panes.TCPLimeSentPushRequestsBytes;
import com.limegroup.gnutella.gui.statistics.panes.TCPLimeSentQueries;
import com.limegroup.gnutella.gui.statistics.panes.TCPLimeSentQueriesBytes;
import com.limegroup.gnutella.gui.statistics.panes.TCPLimeSentQueryReplies;
import com.limegroup.gnutella.gui.statistics.panes.TCPLimeSentQueryRepliesBytes;
import com.limegroup.gnutella.gui.statistics.panes.TCPMessagesReceived;
import com.limegroup.gnutella.gui.statistics.panes.TCPMessagesSent;
import com.limegroup.gnutella.gui.statistics.panes.TotalDownstreamBandwidth;
import com.limegroup.gnutella.gui.statistics.panes.TotalReceivedBytes;
import com.limegroup.gnutella.gui.statistics.panes.TotalReceivedMessages;
import com.limegroup.gnutella.gui.statistics.panes.TotalSentBytes;
import com.limegroup.gnutella.gui.statistics.panes.TotalSentMessages;
import com.limegroup.gnutella.gui.statistics.panes.TotalUpstreamBandwidth;
import com.limegroup.gnutella.gui.statistics.panes.UDPBytesReceived;
import com.limegroup.gnutella.gui.statistics.panes.UDPBytesSent;
import com.limegroup.gnutella.gui.statistics.panes.UDPLimeReceivedBytes;
import com.limegroup.gnutella.gui.statistics.panes.UDPLimeReceivedMessages;
import com.limegroup.gnutella.gui.statistics.panes.UDPLimeReceivedPings;
import com.limegroup.gnutella.gui.statistics.panes.UDPLimeReceivedPingsBytes;
import com.limegroup.gnutella.gui.statistics.panes.UDPLimeReceivedPongs;
import com.limegroup.gnutella.gui.statistics.panes.UDPLimeReceivedPongsBytes;
import com.limegroup.gnutella.gui.statistics.panes.UDPLimeReceivedPushRequests;
import com.limegroup.gnutella.gui.statistics.panes.UDPLimeReceivedPushRequestsBytes;
import com.limegroup.gnutella.gui.statistics.panes.UDPLimeReceivedQueries;
import com.limegroup.gnutella.gui.statistics.panes.UDPLimeReceivedQueriesBytes;
import com.limegroup.gnutella.gui.statistics.panes.UDPLimeReceivedQueryReplies;
import com.limegroup.gnutella.gui.statistics.panes.UDPLimeReceivedQueryRepliesBytes;
import com.limegroup.gnutella.gui.statistics.panes.UDPLimeSentBytes;
import com.limegroup.gnutella.gui.statistics.panes.UDPLimeSentMessages;
import com.limegroup.gnutella.gui.statistics.panes.UDPLimeSentPings;
import com.limegroup.gnutella.gui.statistics.panes.UDPLimeSentPingsBytes;
import com.limegroup.gnutella.gui.statistics.panes.UDPLimeSentPongs;
import com.limegroup.gnutella.gui.statistics.panes.UDPLimeSentPongsBytes;
import com.limegroup.gnutella.gui.statistics.panes.UDPLimeSentPushRequests;
import com.limegroup.gnutella.gui.statistics.panes.UDPLimeSentPushRequestsBytes;
import com.limegroup.gnutella.gui.statistics.panes.UDPLimeSentQueries;
import com.limegroup.gnutella.gui.statistics.panes.UDPLimeSentQueriesBytes;
import com.limegroup.gnutella.gui.statistics.panes.UDPLimeSentQueryReplies;
import com.limegroup.gnutella.gui.statistics.panes.UDPLimeSentQueryRepliesBytes;
import com.limegroup.gnutella.gui.statistics.panes.UDPMessagesReceived;
import com.limegroup.gnutella.gui.statistics.panes.UDPMessagesSent;
import com.limegroup.gnutella.gui.statistics.panes.UploadGeneral;
import com.limegroup.gnutella.gui.statistics.panes.UploadRequestMethods;
import com.limegroup.gnutella.gui.statistics.panes.UploadRequests;
import com.limegroup.gnutella.gui.statistics.panes.UploadResponses;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public final class StatisticsConstructor {
    private static final JDialog DIALOG = new JDialog(GUIMediator.getAppFrame(), GUIMediator.getStringResource("STATS_TITLE"), false);
    private static final int STATISTICS_WIDTH = 660;
    private static final int STATISTICS_HEIGHT = 460;
    private static StatisticsTreeManager _treeManager;
    private static StatisticsPaneManager _paneManager;
    private static final String ADVANCED_KEY = "STATS_ADVANCED_PANE_TITLE";
    private static final JPanel MAIN_PANEL;
    private static final JSplitPane SPLIT_PANE;

    public StatisticsConstructor(StatisticsTreeManager treeManager, StatisticsPaneManager paneManager) {
        _treeManager = treeManager;
        _paneManager = paneManager;
        ((Component)DIALOG).setSize(660, 460);
        Box splitBox = new Box(0);
        Component treeComponent = _treeManager.getComponent();
        JComponent paneComponent = _paneManager.getComponent();
        SPLIT_PANE.setLeftComponent(treeComponent);
        SPLIT_PANE.setRightComponent(paneComponent);
        splitBox.add(SPLIT_PANE);
        SPLIT_PANE.setBorder(BorderFactory.createEmptyBorder());
        MAIN_PANEL.add(splitBox);
        MAIN_PANEL.add(Box.createVerticalStrut(17));
        MAIN_PANEL.add(new StatisticsButtonPanel().getComponent());
        DIALOG.getContentPane().add(MAIN_PANEL);
        DIALOG.addComponentListener(new PaneAdapter());
        if (!CommonUtils.isJava118()) {
            String BANDWIDTH_KEY = "STATS_BANDWIDTH_PANE_TITLE";
            VisibleStatsPane bandwidthPane = new VisibleStatsPane("STATS_BANDWIDTH_PANE_TITLE");
            bandwidthPane.add(new BandwidthStats());
            StatisticsConstructor.addGroupTreeNode("STATISTICS_ROOT_NODE", bandwidthPane);
            String UPSTREAM_BANDWIDTH_KEY = "TOTAL_UPSTREAM_BANDWIDTH";
            StatisticsConstructor.addStatisticPane("STATS_BANDWIDTH_PANE_TITLE", "TOTAL_UPSTREAM_BANDWIDTH", new TotalUpstreamBandwidth("TOTAL_UPSTREAM_BANDWIDTH"));
            String DOWNSTREAM_BANDWIDTH_KEY = "TOTAL_DOWNSTREAM_BANDWIDTH";
            StatisticsConstructor.addStatisticPane("STATS_BANDWIDTH_PANE_TITLE", "TOTAL_DOWNSTREAM_BANDWIDTH", new TotalDownstreamBandwidth("TOTAL_DOWNSTREAM_BANDWIDTH"));
        }
        String NET_KEY = "STATS_NET_PANE_TITLE";
        VisibleStatsPane netPane = new VisibleStatsPane("STATS_NET_PANE_TITLE");
        netPane.add(new NetStats());
        StatisticsConstructor.addGroupTreeNode("STATISTICS_ROOT_NODE", netPane);
        if (!CommonUtils.isJava118()) {
            VisibleStatsPane advancedPane = new VisibleStatsPane(ADVANCED_KEY);
            advancedPane.add(new AdvancedStats());
            StatisticsConstructor.addGroupTreeNode("STATISTICS_ROOT_NODE", advancedPane);
        }
        _treeManager.getTree().setSelectionRow(0);
    }

    static void setAdvancedStatsVisible(boolean visible) {
        if (visible) {
            _treeManager.advancedSize();
            SPLIT_PANE.setDividerLocation(200);
            StatisticsConstructor.makeStatsVisible();
            ((Component)DIALOG).setSize(735, 460);
        } else {
            _treeManager.defaultSize();
            SPLIT_PANE.setDividerLocation(125);
            _treeManager.removeAllChildren(ADVANCED_KEY);
            ((Component)DIALOG).setSize(660, 460);
        }
    }

    private static void makeStatsVisible() {
        String GNUTELLA_KEY = "GNUTELLA_MESSAGES";
        StatisticsConstructor.addGroupTreeNode(ADVANCED_KEY, "GNUTELLA_MESSAGES");
        StatisticsConstructor.addReceivedStats("GNUTELLA_MESSAGES");
        StatisticsConstructor.addSentStats("GNUTELLA_MESSAGES");
        StatisticsConstructor.addFlowControlStats("GNUTELLA_MESSAGES");
        StatisticsConstructor.addCompressionStats("GNUTELLA_MESSAGES");
        StatisticsConstructor.addHandshakingStats("GNUTELLA_MESSAGES");
        StatisticsConstructor.addQRPStats("GNUTELLA_MESSAGES");
        StatisticsConstructor.addErrorStats("GNUTELLA_MESSAGES");
        String OOB_THROUGHPUT_KEY = "OOB_THROUGHPUT";
        StatisticsConstructor.addStatisticPane("GNUTELLA_MESSAGES", "OOB_THROUGHPUT", new OutOfBandThroughputPaneItem("OOB_THROUGHPUT"));
        String ROUTE_ERRORS_KEY = "ROUTE_ERRORS";
        StatisticsConstructor.addStatisticPane("GNUTELLA_MESSAGES", "ROUTE_ERRORS", new RouteErrorsPaneItem("ROUTE_ERRORS"));
        String QUERY_REPLY_ROUTE_ERRORS_KEY = "QUERY_REPLY_ROUTE_ERRORS";
        StatisticsConstructor.addStatisticPane("GNUTELLA_MESSAGES", "QUERY_REPLY_ROUTE_ERRORS", new QueryReplyRouteErrors("QUERY_REPLY_ROUTE_ERRORS"));
        String FILTERED_MESSAGES_KEY = "FILTERED_MESSAGES";
        StatisticsConstructor.addStatisticPane("GNUTELLA_MESSAGES", "FILTERED_MESSAGES", new FilteredMessagesPaneItem("FILTERED_MESSAGES"));
        String CONNECTION_ATTEMPTS_KEY = "TOTAL_CONNECTION_ATTEMPTS";
        StatisticsConstructor.addStatisticPane("GNUTELLA_MESSAGES", "TOTAL_CONNECTION_ATTEMPTS", new ConnectionAttemptsPaneItem("TOTAL_CONNECTION_ATTEMPTS"));
        String HTTP_REQUESTS_KEY = "TOTAL_HTTP_REQUESTS";
        StatisticsConstructor.addStatisticPane(ADVANCED_KEY, "TOTAL_HTTP_REQUESTS", new HTTPRequestsPaneItem("TOTAL_HTTP_REQUESTS"));
        StatisticsConstructor.addDownloadStats(ADVANCED_KEY);
        StatisticsConstructor.addUploadStats(ADVANCED_KEY);
    }

    private static void addDownloadStats(String ADVANCED_KEY) {
        String DOWNLOAD_GROUP_KEY = "DOWNLOAD_STATISTICS";
        StatisticsConstructor.addGroupTreeNode(ADVANCED_KEY, "DOWNLOAD_STATISTICS");
        String CONNECTIONS_KEY = "DOWNLOAD_CONNECTIONS";
        StatisticsConstructor.addStatisticPane("DOWNLOAD_STATISTICS", "DOWNLOAD_CONNECTIONS", new DownloadConnections("DOWNLOAD_CONNECTIONS"));
        String RESPONSES_KEY = "DOWNLOAD_RESPONSES";
        StatisticsConstructor.addStatisticPane("DOWNLOAD_STATISTICS", "DOWNLOAD_RESPONSES", new DownloadResponses("DOWNLOAD_RESPONSES"));
        String ALTERNATE_KEY = "DOWNLOAD_ALTERNATE";
        StatisticsConstructor.addStatisticPane("DOWNLOAD_STATISTICS", "DOWNLOAD_ALTERNATE", new DownloadAlternateLocations("DOWNLOAD_ALTERNATE"));
        String TRANFERS_KEY = "DOWNLOAD_TRANFERS";
        StatisticsConstructor.addStatisticPane("DOWNLOAD_STATISTICS", "DOWNLOAD_TRANFERS", new DownloadTransfers("DOWNLOAD_TRANFERS"));
        String TCP_CONNECT_TIME_KEY = "DOWNLOAD_TCP_CONNECT_TIME";
        StatisticsConstructor.addStatisticPane("DOWNLOAD_STATISTICS", "DOWNLOAD_TCP_CONNECT_TIME", new DownloadTCPConnectTime("DOWNLOAD_TCP_CONNECT_TIME"));
    }

    private static void addUploadStats(String ADVANCED_KEY) {
        String UPLOAD_GROUP_KEY = "UPLOAD_STATISTICS";
        StatisticsConstructor.addGroupTreeNode(ADVANCED_KEY, "UPLOAD_STATISTICS");
        String REQUESTS_KEY = "UPLOAD_REQUESTS";
        StatisticsConstructor.addStatisticPane("UPLOAD_STATISTICS", "UPLOAD_REQUESTS", new UploadRequests("UPLOAD_REQUESTS"));
        String RESPONSES_KEY = "UPLOAD_RESPONSES";
        StatisticsConstructor.addStatisticPane("UPLOAD_STATISTICS", "UPLOAD_RESPONSES", new UploadResponses("UPLOAD_RESPONSES"));
        String METHODS_KEY = "UPLOAD_METHODS";
        StatisticsConstructor.addStatisticPane("UPLOAD_STATISTICS", "UPLOAD_METHODS", new UploadRequestMethods("UPLOAD_METHODS"));
        String GENERAL_KEY = "UPLOAD_GENERAL";
        StatisticsConstructor.addStatisticPane("UPLOAD_STATISTICS", "UPLOAD_GENERAL", new UploadGeneral("UPLOAD_GENERAL"));
    }

    private static void addHandshakingStats(String GNUTELLA_KEY) {
        String GROUP_KEY = "HANDSHAKING";
        StatisticsConstructor.addGroupTreeNode(GNUTELLA_KEY, "HANDSHAKING");
        String LEAF_KEY = "HANDSHAKING_LEAF";
        StatisticsConstructor.addStatisticPane("HANDSHAKING", "HANDSHAKING_LEAF", new HandshakingLeaf("HANDSHAKING_LEAF"));
        String UP_KEY = "HANDSHAKING_ULTRAPEER";
        StatisticsConstructor.addStatisticPane("HANDSHAKING", "HANDSHAKING_ULTRAPEER", new HandshakingUltrapeer("HANDSHAKING_ULTRAPEER"));
        String OUT_KEY = "HANDSHAKING_OUTGOING";
        StatisticsConstructor.addStatisticPane("HANDSHAKING", "HANDSHAKING_OUTGOING", new OutgoingHandshaking("HANDSHAKING_OUTGOING"));
        String IN_KEY = "HANDSHAKING_INCOMING";
        StatisticsConstructor.addStatisticPane("HANDSHAKING", "HANDSHAKING_INCOMING", new IncomingHandshaking("HANDSHAKING_INCOMING"));
        String SERVER_REJECT_KEY = "HANDSHAKING_OUTGOING_SERVER_REJECT";
        StatisticsConstructor.addStatisticPane("HANDSHAKING", "HANDSHAKING_OUTGOING_SERVER_REJECT", new OutgoingServerReject("HANDSHAKING_OUTGOING_SERVER_REJECT"));
    }

    private static void addCompressionStats(String GNUTELLA_KEY) {
        String COMPRESSION_GROUP_KEY = "COMPRESSABLE_MESSAGES";
        StatisticsConstructor.addGroupTreeNode(GNUTELLA_KEY, "COMPRESSABLE_MESSAGES");
        String COMPRESSABLE_UPSTREAM_KEY = "COMPRESSABLE_UPSTREAM";
        StatisticsConstructor.addStatisticPane("COMPRESSABLE_MESSAGES", "COMPRESSABLE_UPSTREAM", new CompressableUpstreamBandwidth("COMPRESSABLE_UPSTREAM"));
        String COMPRESSABLE_DOWNSTREAM_KEY = "COMPRESSABLE_DOWNSTREAM";
        StatisticsConstructor.addStatisticPane("COMPRESSABLE_MESSAGES", "COMPRESSABLE_DOWNSTREAM", new CompressableDownstreamBandwidth("COMPRESSABLE_DOWNSTREAM"));
    }

    private static void addFlowControlStats(String GNUTELLA_KEY) {
        String FLOW_CONTROL_GROUP_KEY = "FLOW_CONTROLLED_MESSAGES";
        StatisticsConstructor.addGroupTreeNode(GNUTELLA_KEY, "FLOW_CONTROLLED_MESSAGES");
        String FLOW_CONTROL_KEY = "FLOW_CONTROL";
        StatisticsConstructor.addStatisticPane("FLOW_CONTROLLED_MESSAGES", "FLOW_CONTROL", new FlowControl("FLOW_CONTROL"));
        String FLOW_CONTROL_BYTES_KEY = "FLOW_CONTROL_BYTES";
        StatisticsConstructor.addStatisticPane("FLOW_CONTROLLED_MESSAGES", "FLOW_CONTROL_BYTES", new FlowControlBytes("FLOW_CONTROL_BYTES"));
    }

    private static void addReceivedStats(String GNUTELLA_KEY) {
        String RECEIVED_KEY = "RECEIVED_MESSAGES";
        StatisticsConstructor.addGroupTreeNode(GNUTELLA_KEY, "RECEIVED_MESSAGES");
        StatisticsConstructor.addReceivedNumberStats("RECEIVED_MESSAGES");
        StatisticsConstructor.addReceivedBytesStats("RECEIVED_MESSAGES");
        StatisticsConstructor.addReceivedAverageMessageSizeStats("RECEIVED_MESSAGES");
        StatisticsConstructor.addReceivedLimeStats("RECEIVED_MESSAGES");
    }

    private static void addSentStats(String GNUTELLA_KEY) {
        String SENT_KEY = "SENT_MESSAGES";
        StatisticsConstructor.addGroupTreeNode(GNUTELLA_KEY, "SENT_MESSAGES");
        StatisticsConstructor.addSentNumberStats("SENT_MESSAGES");
        StatisticsConstructor.addSentBytesStats("SENT_MESSAGES");
        StatisticsConstructor.addSentLimeStats("SENT_MESSAGES");
    }

    private static void addQRPStats(String GNUTELLA_KEY) {
        String QRP_GROUP_KEY = "QRP_MESSAGES";
        StatisticsConstructor.addGroupTreeNode(GNUTELLA_KEY, "QRP_MESSAGES");
        StatisticsConstructor.addUltrapeerQRPStats("QRP_MESSAGES");
        StatisticsConstructor.addLeafQRPStats("QRP_MESSAGES");
    }

    private static void addErrorStats(String GNUTELLA_KEY) {
        String ERROR_GROUP_KEY = "ERROR_MESSAGES";
        StatisticsConstructor.addGroupTreeNode(GNUTELLA_KEY, "ERROR_MESSAGES");
        String GENERIC_KEY = "ERROR_GENERIC";
        StatisticsConstructor.addStatisticPane("ERROR_MESSAGES", "ERROR_GENERIC", new ErrorGeneric("ERROR_GENERIC"));
        String QUERY_KEY = "ERROR_QUERIES";
        StatisticsConstructor.addStatisticPane("ERROR_MESSAGES", "ERROR_QUERIES", new ErrorQueries("ERROR_QUERIES"));
        String QUERY_REPLY_KEY = "ERROR_QUERY_REPLIES";
        StatisticsConstructor.addStatisticPane("ERROR_MESSAGES", "ERROR_QUERY_REPLIES", new ErrorQueryReplies("ERROR_QUERY_REPLIES"));
        String PING_REPLY_KEY = "ERROR_PING_REPLY";
        StatisticsConstructor.addStatisticPane("ERROR_MESSAGES", "ERROR_PING_REPLY", new ErrorPingReplies("ERROR_PING_REPLY"));
        String PUSH_KEY = "ERROR_PUSHES";
        StatisticsConstructor.addStatisticPane("ERROR_MESSAGES", "ERROR_PUSHES", new ErrorPushes("ERROR_PUSHES"));
        String VENDOR_KEY = "ERROR_VENDOR";
        StatisticsConstructor.addStatisticPane("ERROR_MESSAGES", "ERROR_VENDOR", new ErrorVendorMessages("ERROR_VENDOR"));
    }

    private static void addReceivedNumberStats(String RECEIVED_KEY) {
        String NUMBER_KEY = "RECEIVED_MESSAGE_NUMBER";
        StatisticsConstructor.addGroupTreeNode(RECEIVED_KEY, "RECEIVED_MESSAGE_NUMBER");
        String TOTAL_RECEIVED_KEY = "TOTAL_RECEIVED_MESSAGES";
        StatisticsConstructor.addStatisticPane("RECEIVED_MESSAGE_NUMBER", "TOTAL_RECEIVED_MESSAGES", new TotalReceivedMessages("TOTAL_RECEIVED_MESSAGES"));
        String RECEIVED_TCP_KEY = "TOTAL_RECEIVED_TCP_MESSAGES";
        StatisticsConstructor.addStatisticPane("RECEIVED_MESSAGE_NUMBER", "TOTAL_RECEIVED_TCP_MESSAGES", new TCPMessagesReceived("TOTAL_RECEIVED_TCP_MESSAGES"));
        String RECEIVED_UDP_KEY = "TOTAL_RECEIVED_UDP_MESSAGES";
        StatisticsConstructor.addStatisticPane("RECEIVED_MESSAGE_NUMBER", "TOTAL_RECEIVED_UDP_MESSAGES", new UDPMessagesReceived("TOTAL_RECEIVED_UDP_MESSAGES"));
        String RECEIVED_MULTICAST_KEY = "TOTAL_RECEIVED_MULTICAST_MESSAGES";
        StatisticsConstructor.addStatisticPane("RECEIVED_MESSAGE_NUMBER", "TOTAL_RECEIVED_MULTICAST_MESSAGES", new MulticastMessagesReceived("TOTAL_RECEIVED_MULTICAST_MESSAGES"));
        String RECEIVED_ALL_KEY = "RECEIVED_ALL";
        StatisticsConstructor.addStatisticPane("RECEIVED_MESSAGE_NUMBER", "RECEIVED_ALL", new AllMessagesReceived("RECEIVED_ALL"));
        String QUERIES_KEY = "RECEIVED_QUERY_REQUESTS";
        StatisticsConstructor.addGroupTreeNode("RECEIVED_MESSAGE_NUMBER", "RECEIVED_QUERY_REQUESTS");
        String QUERIES_HOPS_KEY = "QUERY_REQUEST_HOPS";
        StatisticsConstructor.addStatisticPane("RECEIVED_QUERY_REQUESTS", "QUERY_REQUEST_HOPS", new QueryHops("QUERY_REQUEST_HOPS"));
        String QUERIES_TTL_KEY = "QUERY_REQUEST_TTL";
        StatisticsConstructor.addStatisticPane("RECEIVED_QUERY_REQUESTS", "QUERY_REQUEST_TTL", new QueryTTL("QUERY_REQUEST_TTL"));
        String DUPLICATE_QUERIES_TCP_KEY = "DUPLICATE_RECEIVED_TCP_QUERIES";
        StatisticsConstructor.addStatisticPane("RECEIVED_QUERY_REQUESTS", "DUPLICATE_RECEIVED_TCP_QUERIES", new TCPDuplicateQueries("DUPLICATE_RECEIVED_TCP_QUERIES"));
        String DUPLICATE_QUERIES_MULTICAST_KEY = "DUPLICATE_RECEIVED_MULTICAST_QUERIES";
        StatisticsConstructor.addStatisticPane("RECEIVED_QUERY_REQUESTS", "DUPLICATE_RECEIVED_MULTICAST_QUERIES", new MulticastDuplicateQueries("DUPLICATE_RECEIVED_MULTICAST_QUERIES"));
        String HITS_KEY = "RECEIVED_QUERY_REPLIES";
        StatisticsConstructor.addGroupTreeNode("RECEIVED_MESSAGE_NUMBER", "RECEIVED_QUERY_REPLIES");
        String HITS_HOPS_KEY = "QUERY_REPLY_HOPS";
        StatisticsConstructor.addStatisticPane("RECEIVED_QUERY_REPLIES", "QUERY_REPLY_HOPS", new HitHops("QUERY_REPLY_HOPS"));
        String HITS_TTL_KEY = "QUERY_REPLY_TTL";
        StatisticsConstructor.addStatisticPane("RECEIVED_QUERY_REPLIES", "QUERY_REPLY_TTL", new HitTTL("QUERY_REPLY_TTL"));
    }

    private static void addReceivedBytesStats(String RECEIVED_KEY) {
        String BYTES_KEY = "RECEIVED_MESSAGE_BYTES";
        StatisticsConstructor.addGroupTreeNode(RECEIVED_KEY, "RECEIVED_MESSAGE_BYTES");
        String TOTAL_RECEIVED_BYTES_KEY = "TOTAL_RECEIVED_BYTES_MESSAGES";
        StatisticsConstructor.addStatisticPane("RECEIVED_MESSAGE_BYTES", "TOTAL_RECEIVED_BYTES_MESSAGES", new TotalReceivedBytes("TOTAL_RECEIVED_BYTES_MESSAGES"));
        String RECEIVED_BYTES_TCP_KEY = "TOTAL_RECEIVED_BYTES_TCP_MESSAGES";
        StatisticsConstructor.addStatisticPane("RECEIVED_MESSAGE_BYTES", "TOTAL_RECEIVED_BYTES_TCP_MESSAGES", new TCPBytesReceived("TOTAL_RECEIVED_BYTES_TCP_MESSAGES"));
        String RECEIVED_BYTES_UDP_KEY = "TOTAL_RECEIVED_BYTES_UDP_MESSAGES";
        StatisticsConstructor.addStatisticPane("RECEIVED_MESSAGE_BYTES", "TOTAL_RECEIVED_BYTES_UDP_MESSAGES", new UDPBytesReceived("TOTAL_RECEIVED_BYTES_UDP_MESSAGES"));
        String RECEIVED_BYTES_MULTICAST_KEY = "TOTAL_RECEIVED_BYTES_MULTICAST_MESSAGES";
        StatisticsConstructor.addStatisticPane("RECEIVED_MESSAGE_BYTES", "TOTAL_RECEIVED_BYTES_MULTICAST_MESSAGES", new MulticastBytesReceived("TOTAL_RECEIVED_BYTES_MULTICAST_MESSAGES"));
        String RECEIVED_BYTES_ALL_KEY = "RECEIVED_BYTES_ALL";
        StatisticsConstructor.addStatisticPane("RECEIVED_MESSAGE_BYTES", "RECEIVED_BYTES_ALL", new AllBytesReceived("RECEIVED_BYTES_ALL"));
        String QUERIES_KEY = "RECEIVED_QUERY_REQUESTS_BYTES";
        StatisticsConstructor.addGroupTreeNode("RECEIVED_MESSAGE_BYTES", "RECEIVED_QUERY_REQUESTS_BYTES");
        String QUERIES_HOPS_BYTES_KEY = "QUERY_REQUEST_HOPS_BYTES";
        StatisticsConstructor.addStatisticPane("RECEIVED_QUERY_REQUESTS_BYTES", "QUERY_REQUEST_HOPS_BYTES", new QueryHopsBytes("QUERY_REQUEST_HOPS_BYTES"));
        String QUERIES_TTL_BYTES_KEY = "QUERY_REQUEST_TTL_BYTES";
        StatisticsConstructor.addStatisticPane("RECEIVED_QUERY_REQUESTS_BYTES", "QUERY_REQUEST_TTL_BYTES", new QueryTTLBytes("QUERY_REQUEST_TTL_BYTES"));
        String DUPLICATE_QUERIES_BYTES_TCP_KEY = "DUPLICATE_RECEIVED_BYTES_TCP_QUERIES";
        StatisticsConstructor.addStatisticPane("RECEIVED_QUERY_REQUESTS_BYTES", "DUPLICATE_RECEIVED_BYTES_TCP_QUERIES", new TCPDuplicateQueriesBytes("DUPLICATE_RECEIVED_BYTES_TCP_QUERIES"));
        String DUPLICATE_QUERIES_BYTES_MULTICAST_KEY = "DUPLICATE_RECEIVED_BYTES_MULTICAST_QUERIES";
        StatisticsConstructor.addStatisticPane("RECEIVED_QUERY_REQUESTS_BYTES", "DUPLICATE_RECEIVED_BYTES_MULTICAST_QUERIES", new MulticastDuplicateQueriesBytes("DUPLICATE_RECEIVED_BYTES_MULTICAST_QUERIES"));
        String HITS_KEY = "RECEIVED_QUERY_REPLIES_BYTES";
        StatisticsConstructor.addGroupTreeNode("RECEIVED_MESSAGE_BYTES", "RECEIVED_QUERY_REPLIES_BYTES");
        String HITS_HOPS_BYTES_KEY = "QUERY_REPLY_HOPS_BYTES";
        StatisticsConstructor.addStatisticPane("RECEIVED_QUERY_REPLIES_BYTES", "QUERY_REPLY_HOPS_BYTES", new HitHopsBytes("QUERY_REPLY_HOPS_BYTES"));
        String HITS_TTL_BYTES_KEY = "QUERY_REPLY_TTL_BYTES";
        StatisticsConstructor.addStatisticPane("RECEIVED_QUERY_REPLIES_BYTES", "QUERY_REPLY_TTL_BYTES", new HitTTLBytes("QUERY_REPLY_TTL_BYTES"));
    }

    private static void addReceivedLimeStats(String RECEIVED_KEY) {
        String LIMEWIRE_RECEIVED_KEY = "RECEIVED_LIMEWIRE";
        StatisticsConstructor.addGroupTreeNode(RECEIVED_KEY, "RECEIVED_LIMEWIRE");
        String LIME_NUMBER_KEY = "LIME_RECEIVED_MESSAGE_NUMBER";
        StatisticsConstructor.addGroupTreeNode("RECEIVED_LIMEWIRE", "LIME_RECEIVED_MESSAGE_NUMBER");
        StatisticsConstructor.addReceivedLimeNumberStatsTCP("LIME_RECEIVED_MESSAGE_NUMBER");
        StatisticsConstructor.addReceivedLimeNumberStatsUDP("LIME_RECEIVED_MESSAGE_NUMBER");
        StatisticsConstructor.addReceivedLimeNumberStatsMulticast("LIME_RECEIVED_MESSAGE_NUMBER");
        String LIME_BYTES_KEY = "LIME_RECEIVED_MESSAGE_BYTES";
        StatisticsConstructor.addGroupTreeNode("RECEIVED_LIMEWIRE", "LIME_RECEIVED_MESSAGE_BYTES");
        StatisticsConstructor.addReceivedLimeBytesStatsTCP("LIME_RECEIVED_MESSAGE_BYTES");
        StatisticsConstructor.addReceivedLimeBytesStatsUDP("LIME_RECEIVED_MESSAGE_BYTES");
        StatisticsConstructor.addReceivedLimeBytesStatsMulticast("LIME_RECEIVED_MESSAGE_BYTES");
        StatisticsConstructor.addReceivedAverageLimeMessageSizeStats("RECEIVED_LIMEWIRE");
    }

    private static void addReceivedLimeNumberStatsTCP(String LIME_NUMBER_KEY) {
        String TCP_KEY = "STATS_RECEIVED_TCP";
        StatisticsConstructor.addGroupTreeNode(LIME_NUMBER_KEY, "STATS_RECEIVED_TCP");
        String LIME_RECEIVED_TCP_MESSAGES_KEY = "LIME_RECEIVED_TCP_MESSAGES";
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_TCP", "LIME_RECEIVED_TCP_MESSAGES", new TCPLimeReceivedMessages("LIME_RECEIVED_TCP_MESSAGES"));
        String LIME_RECEIVED_TCP_PINGS_KEY = "LIME_RECEIVED_TCP_PING_REQUESTS";
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_TCP", "LIME_RECEIVED_TCP_PING_REQUESTS", new TCPLimeReceivedPings("LIME_RECEIVED_TCP_PING_REQUESTS"));
        String LIME_RECEIVED_TCP_PONGS_KEY = "LIME_RECEIVED_TCP_PING_REPLIES";
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_TCP", "LIME_RECEIVED_TCP_PING_REPLIES", new TCPLimeReceivedPongs("LIME_RECEIVED_TCP_PING_REPLIES"));
        String LIME_RECEIVED_TCP_QUERIES_KEY = "LIME_RECEIVED_TCP_QUERIES";
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_TCP", "LIME_RECEIVED_TCP_QUERIES", new TCPLimeReceivedQueries("LIME_RECEIVED_TCP_QUERIES"));
        String LIME_RECEIVED_TCP_QUERY_REPLIES_KEY = "LIME_RECEIVED_TCP_QUERY_REPLIES";
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_TCP", "LIME_RECEIVED_TCP_QUERY_REPLIES", new TCPLimeReceivedQueryReplies("LIME_RECEIVED_TCP_QUERY_REPLIES"));
        String LIME_RECEIVED_TCP_PUSH_REQUESTS_KEY = "LIME_RECEIVED_TCP_PUSH_REQUESTS";
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_TCP", "LIME_RECEIVED_TCP_PUSH_REQUESTS", new TCPLimeReceivedPushRequests("LIME_RECEIVED_TCP_PUSH_REQUESTS"));
    }

    private static void addReceivedLimeNumberStatsUDP(String LIME_NUMBER_KEY) {
        String UDP_KEY = "STATS_RECEIVED_UDP";
        StatisticsConstructor.addGroupTreeNode(LIME_NUMBER_KEY, "STATS_RECEIVED_UDP");
        String LIME_RECEIVED_UDP_MESSAGES_KEY = "LIME_RECEIVED_UDP_MESSAGES";
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_UDP", "LIME_RECEIVED_UDP_MESSAGES", new UDPLimeReceivedMessages("LIME_RECEIVED_UDP_MESSAGES"));
        String LIME_RECEIVED_UDP_PINGS_KEY = "LIME_RECEIVED_UDP_PING_REQUESTS";
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_UDP", "LIME_RECEIVED_UDP_PING_REQUESTS", new UDPLimeReceivedPings("LIME_RECEIVED_UDP_PING_REQUESTS"));
        String LIME_RECEIVED_UDP_PONGS_KEY = "LIME_RECEIVED_UDP_PING_REPLIES";
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_UDP", "LIME_RECEIVED_UDP_PING_REPLIES", new UDPLimeReceivedPongs("LIME_RECEIVED_UDP_PING_REPLIES"));
        String LIME_RECEIVED_UDP_QUERIES_KEY = "LIME_RECEIVED_UDP_QUERIES";
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_UDP", "LIME_RECEIVED_UDP_QUERIES", new UDPLimeReceivedQueries("LIME_RECEIVED_UDP_QUERIES"));
        String LIME_RECEIVED_UDP_QUERY_REPLIES_KEY = "LIME_RECEIVED_UDP_QUERY_REPLIES";
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_UDP", "LIME_RECEIVED_UDP_QUERY_REPLIES", new UDPLimeReceivedQueryReplies("LIME_RECEIVED_UDP_QUERY_REPLIES"));
        String LIME_RECEIVED_UDP_PUSH_REQUESTS_KEY = "LIME_RECEIVED_UDP_PUSH_REQUESTS";
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_UDP", "LIME_RECEIVED_UDP_PUSH_REQUESTS", new UDPLimeReceivedPushRequests("LIME_RECEIVED_UDP_PUSH_REQUESTS"));
    }

    private static void addReceivedLimeNumberStatsMulticast(String LIME_NUMBER_KEY) {
        String MULTICAST_KEY = "STATS_RECEIVED_MULTICAST";
        StatisticsConstructor.addGroupTreeNode(LIME_NUMBER_KEY, "STATS_RECEIVED_MULTICAST");
        String LIME_RECEIVED_MULTICAST_MESSAGES_KEY = "LIME_RECEIVED_MULTICAST_MESSAGES";
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_MULTICAST", "LIME_RECEIVED_MULTICAST_MESSAGES", new MulticastLimeReceivedMessages("LIME_RECEIVED_MULTICAST_MESSAGES"));
        String LIME_RECEIVED_MULTICAST_PINGS_KEY = "LIME_RECEIVED_MULTICAST_PING_REQUESTS";
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_MULTICAST", "LIME_RECEIVED_MULTICAST_PING_REQUESTS", new MulticastLimeReceivedPings("LIME_RECEIVED_MULTICAST_PING_REQUESTS"));
        String LIME_RECEIVED_MULTICAST_PONGS_KEY = "LIME_RECEIVED_MULTICAST_PING_REPLIES";
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_MULTICAST", "LIME_RECEIVED_MULTICAST_PING_REPLIES", new MulticastLimeReceivedPongs("LIME_RECEIVED_MULTICAST_PING_REPLIES"));
        String LIME_RECEIVED_MULTICAST_QUERIES_KEY = "LIME_RECEIVED_MULTICAST_QUERIES";
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_MULTICAST", "LIME_RECEIVED_MULTICAST_QUERIES", new MulticastLimeReceivedQueries("LIME_RECEIVED_MULTICAST_QUERIES"));
        String LIME_RECEIVED_MULTICAST_QUERY_REPLIES_KEY = "LIME_RECEIVED_MULTICAST_QUERY_REPLIES";
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_MULTICAST", "LIME_RECEIVED_MULTICAST_QUERY_REPLIES", new MulticastLimeReceivedQueryReplies("LIME_RECEIVED_MULTICAST_QUERY_REPLIES"));
        String LIME_RECEIVED_MULTICAST_PUSH_REQUESTS_KEY = "LIME_RECEIVED_MULTICAST_PUSH_REQUESTS";
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_MULTICAST", "LIME_RECEIVED_MULTICAST_PUSH_REQUESTS", new MulticastLimeReceivedPushRequests("LIME_RECEIVED_MULTICAST_PUSH_REQUESTS"));
    }

    private static void addReceivedLimeBytesStatsTCP(String LIME_BYTES_KEY) {
        String TCP_KEY = "STATS_RECEIVED_TCP_BYTES";
        StatisticsConstructor.addGroupTreeNode(LIME_BYTES_KEY, "STATS_RECEIVED_TCP_BYTES");
        String LIME_RECEIVED_TCP_MESSAGES_KEY = "LIME_RECEIVED_BYTES_TCP_MESSAGES";
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_TCP_BYTES", "LIME_RECEIVED_BYTES_TCP_MESSAGES", new TCPLimeReceivedBytes("LIME_RECEIVED_BYTES_TCP_MESSAGES"));
        String LIME_RECEIVED_TCP_PINGS_KEY = "LIME_RECEIVED_BYTES_TCP_PING_REQUESTS";
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_TCP_BYTES", "LIME_RECEIVED_BYTES_TCP_PING_REQUESTS", new TCPLimeReceivedPingsBytes("LIME_RECEIVED_BYTES_TCP_PING_REQUESTS"));
        String LIME_RECEIVED_TCP_PONGS_KEY = "LIME_RECEIVED_BYTES_TCP_PING_REPLIES";
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_TCP_BYTES", "LIME_RECEIVED_BYTES_TCP_PING_REPLIES", new TCPLimeReceivedPongsBytes("LIME_RECEIVED_BYTES_TCP_PING_REPLIES"));
        String LIME_RECEIVED_TCP_QUERIES_KEY = "LIME_RECEIVED_BYTES_TCP_QUERIES";
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_TCP_BYTES", "LIME_RECEIVED_BYTES_TCP_QUERIES", new TCPLimeReceivedQueriesBytes("LIME_RECEIVED_BYTES_TCP_QUERIES"));
        String LIME_RECEIVED_TCP_QUERY_REPLIES_KEY = "LIME_RECEIVED_BYTES_TCP_QUERY_REPLIES";
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_TCP_BYTES", "LIME_RECEIVED_BYTES_TCP_QUERY_REPLIES", new TCPLimeReceivedQueryRepliesBytes("LIME_RECEIVED_BYTES_TCP_QUERY_REPLIES"));
        String LIME_RECEIVED_TCP_PUSH_REQUESTS_KEY = "LIME_RECEIVED_BYTES_TCP_PUSH_REQUESTS";
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_TCP_BYTES", "LIME_RECEIVED_BYTES_TCP_PUSH_REQUESTS", new TCPLimeReceivedPushRequestsBytes("LIME_RECEIVED_BYTES_TCP_PUSH_REQUESTS"));
    }

    private static void addReceivedLimeBytesStatsUDP(String LIME_BYTES_KEY) {
        String UDP_KEY = "STATS_RECEIVED_UDP_BYTES";
        StatisticsConstructor.addGroupTreeNode(LIME_BYTES_KEY, "STATS_RECEIVED_UDP_BYTES");
        String LIME_RECEIVED_UDP_MESSAGES_KEY = "LIME_RECEIVED_BYTES_UDP_MESSAGES";
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_UDP_BYTES", "LIME_RECEIVED_BYTES_UDP_MESSAGES", new UDPLimeReceivedBytes("LIME_RECEIVED_BYTES_UDP_MESSAGES"));
        String LIME_RECEIVED_UDP_PINGS_KEY = "LIME_RECEIVED_BYTES_UDP_PING_REQUESTS";
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_UDP_BYTES", "LIME_RECEIVED_BYTES_UDP_PING_REQUESTS", new UDPLimeReceivedPingsBytes("LIME_RECEIVED_BYTES_UDP_PING_REQUESTS"));
        String LIME_RECEIVED_UDP_PONGS_KEY = "LIME_RECEIVED_BYTES_UDP_PING_REPLIES";
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_UDP_BYTES", "LIME_RECEIVED_BYTES_UDP_PING_REPLIES", new UDPLimeReceivedPongsBytes("LIME_RECEIVED_BYTES_UDP_PING_REPLIES"));
        String LIME_RECEIVED_UDP_QUERIES_KEY = "LIME_RECEIVED_BYTES_UDP_QUERIES";
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_UDP_BYTES", "LIME_RECEIVED_BYTES_UDP_QUERIES", new UDPLimeReceivedQueriesBytes("LIME_RECEIVED_BYTES_UDP_QUERIES"));
        String LIME_RECEIVED_UDP_QUERY_REPLIES_KEY = "LIME_RECEIVED_BYTES_UDP_QUERY_REPLIES";
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_UDP_BYTES", "LIME_RECEIVED_BYTES_UDP_QUERY_REPLIES", new UDPLimeReceivedQueryRepliesBytes("LIME_RECEIVED_BYTES_UDP_QUERY_REPLIES"));
        String LIME_RECEIVED_UDP_PUSH_REQUESTS_KEY = "LIME_RECEIVED_BYTES_UDP_PUSH_REQUESTS";
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_UDP_BYTES", "LIME_RECEIVED_BYTES_UDP_PUSH_REQUESTS", new UDPLimeReceivedPushRequestsBytes("LIME_RECEIVED_BYTES_UDP_PUSH_REQUESTS"));
    }

    private static void addReceivedLimeBytesStatsMulticast(String LIME_BYTES_KEY) {
        String MULTICAST_KEY = "STATS_RECEIVED_MULTICAST_BYTES";
        StatisticsConstructor.addGroupTreeNode(LIME_BYTES_KEY, "STATS_RECEIVED_MULTICAST_BYTES");
        String LIME_RECEIVED_MULTICAST_MESSAGES_KEY = "LIME_RECEIVED_BYTES_MULTICAST_MESSAGES";
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_MULTICAST_BYTES", "LIME_RECEIVED_BYTES_MULTICAST_MESSAGES", new MulticastLimeReceivedBytes("LIME_RECEIVED_BYTES_MULTICAST_MESSAGES"));
        String LIME_RECEIVED_MULTICAST_PINGS_KEY = "LIME_RECEIVED_BYTES_MULTICAST_PING_REQUESTS";
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_MULTICAST_BYTES", "LIME_RECEIVED_BYTES_MULTICAST_PING_REQUESTS", new MulticastLimeReceivedPingsBytes("LIME_RECEIVED_BYTES_MULTICAST_PING_REQUESTS"));
        String LIME_RECEIVED_MULTICAST_PONGS_KEY = "LIME_RECEIVED_BYTES_MULTICAST_PING_REPLIES";
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_MULTICAST_BYTES", "LIME_RECEIVED_BYTES_MULTICAST_PING_REPLIES", new MulticastLimeReceivedPongsBytes("LIME_RECEIVED_BYTES_MULTICAST_PING_REPLIES"));
        String LIME_RECEIVED_MULTICAST_QUERIES_KEY = "LIME_RECEIVED_BYTES_MULTICAST_QUERIES";
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_MULTICAST_BYTES", "LIME_RECEIVED_BYTES_MULTICAST_QUERIES", new MulticastLimeReceivedQueriesBytes("LIME_RECEIVED_BYTES_MULTICAST_QUERIES"));
        String LIME_RECEIVED_MULTICAST_QUERY_REPLIES_KEY = "LIME_RECEIVED_BYTES_MULTICAST_QUERY_REPLIES";
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_MULTICAST_BYTES", "LIME_RECEIVED_BYTES_MULTICAST_QUERY_REPLIES", new MulticastLimeReceivedQueryRepliesBytes("LIME_RECEIVED_BYTES_MULTICAST_QUERY_REPLIES"));
        String LIME_RECEIVED_MULTICAST_PUSH_REQUESTS_KEY = "LIME_RECEIVED_BYTES_MULTICAST_PUSH_REQUESTS";
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_MULTICAST_BYTES", "LIME_RECEIVED_BYTES_MULTICAST_PUSH_REQUESTS", new MulticastLimeReceivedPushRequestsBytes("LIME_RECEIVED_BYTES_MULTICAST_PUSH_REQUESTS"));
    }

    private static void addReceivedAverageMessageSizeStats(String receivedKey) {
        String RECEIVED_AVERAGE_MESSAGE_SIZE = "RECEIVED_AVERAGE_MESSAGE_SIZE";
        StatisticsConstructor.addStatisticPane(receivedKey, "RECEIVED_AVERAGE_MESSAGE_SIZE", new TCPAverageMessageSize("RECEIVED_AVERAGE_MESSAGE_SIZE"));
    }

    private static void addReceivedAverageLimeMessageSizeStats(String receivedKey) {
        String RECEIVED_AVERAGE_LIME_MESSAGE_SIZE = "RECEIVED_AVERAGE_LIME_MESSAGE_SIZE";
        StatisticsConstructor.addStatisticPane(receivedKey, "RECEIVED_AVERAGE_LIME_MESSAGE_SIZE", new TCPLimeAverageMessageSize("RECEIVED_AVERAGE_LIME_MESSAGE_SIZE"));
    }

    private static void addSentNumberStats(String SENT_KEY) {
        String NUMBER_SENT_KEY = "SENT_MESSAGE_NUMBER";
        StatisticsConstructor.addGroupTreeNode(SENT_KEY, "SENT_MESSAGE_NUMBER");
        String TOTAL_SENT_KEY = "TOTAL_SENT_MESSAGES";
        StatisticsConstructor.addStatisticPane("SENT_MESSAGE_NUMBER", "TOTAL_SENT_MESSAGES", new TotalSentMessages("TOTAL_SENT_MESSAGES"));
        String SENT_TCP_KEY = "TOTAL_SENT_TCP_MESSAGES";
        StatisticsConstructor.addStatisticPane("SENT_MESSAGE_NUMBER", "TOTAL_SENT_TCP_MESSAGES", new TCPMessagesSent("TOTAL_SENT_TCP_MESSAGES"));
        String SENT_UDP_KEY = "TOTAL_SENT_UDP_MESSAGES";
        StatisticsConstructor.addStatisticPane("SENT_MESSAGE_NUMBER", "TOTAL_SENT_UDP_MESSAGES", new UDPMessagesSent("TOTAL_SENT_UDP_MESSAGES"));
        String SENT_MULTICAST_KEY = "TOTAL_SENT_MULTICAST_MESSAGES";
        StatisticsConstructor.addStatisticPane("SENT_MESSAGE_NUMBER", "TOTAL_SENT_MULTICAST_MESSAGES", new MulticastMessagesSent("TOTAL_SENT_MULTICAST_MESSAGES"));
        String SENT_ALL_KEY = "SENT_ALL";
        StatisticsConstructor.addStatisticPane("SENT_MESSAGE_NUMBER", "SENT_ALL", new AllMessagesSent("SENT_ALL"));
    }

    private static void addUltrapeerQRPStats(String QRP_KEY) {
        String ULTRAPEER_KEY = "QRP_ULTRAPEER";
        StatisticsConstructor.addGroupTreeNode(QRP_KEY, "QRP_ULTRAPEER");
        String ROUTED_ULTRAPEER_QUERY_KEY = "QRP_ULTRAPEER_ROUTED_QUERIES_SENT";
        StatisticsConstructor.addStatisticPane("QRP_ULTRAPEER", "QRP_ULTRAPEER_ROUTED_QUERIES_SENT", new RoutedOutgoingUltrapeerQueries("QRP_ULTRAPEER_ROUTED_QUERIES_SENT"));
    }

    private static void addLeafQRPStats(String QRP_KEY) {
        String LEAF_KEY = "QRP_LEAF";
        StatisticsConstructor.addGroupTreeNode(QRP_KEY, "QRP_LEAF");
        String ROUTED_LEAF_SENT_QUERY_KEY = "QRP_LEAF_ROUTED_QUERIES_SENT";
        StatisticsConstructor.addStatisticPane("QRP_LEAF", "QRP_LEAF_ROUTED_QUERIES_SENT", new RoutedOutgoingLeafQueries("QRP_LEAF_ROUTED_QUERIES_SENT"));
        String ROUTED_LEAF_RECVD_QUERY_KEY = "QRP_LEAF_ROUTED_QUERIES_RECEIVED";
        StatisticsConstructor.addStatisticPane("QRP_LEAF", "QRP_LEAF_ROUTED_QUERIES_RECEIVED", new RoutedIncomingLeafQueries("QRP_LEAF_ROUTED_QUERIES_RECEIVED"));
    }

    private static void addSentBytesStats(String SENT_KEY) {
        String BYTES_SENT_KEY = "SENT_MESSAGE_BYTES";
        StatisticsConstructor.addGroupTreeNode(SENT_KEY, "SENT_MESSAGE_BYTES");
        String TOTAL_BYTES_SENT_KEY = "TOTAL_SENT_BYTES_MESSAGES";
        StatisticsConstructor.addStatisticPane("SENT_MESSAGE_BYTES", "TOTAL_SENT_BYTES_MESSAGES", new TotalSentBytes("TOTAL_SENT_BYTES_MESSAGES"));
        String SENT_BYTES_TCP_KEY = "TOTAL_SENT_BYTES_TCP_MESSAGES";
        StatisticsConstructor.addStatisticPane("SENT_MESSAGE_BYTES", "TOTAL_SENT_BYTES_TCP_MESSAGES", new TCPBytesSent("TOTAL_SENT_BYTES_TCP_MESSAGES"));
        String SENT_BYTES_UDP_KEY = "TOTAL_SENT_BYTES_UDP_MESSAGES";
        StatisticsConstructor.addStatisticPane("SENT_MESSAGE_BYTES", "TOTAL_SENT_BYTES_UDP_MESSAGES", new UDPBytesSent("TOTAL_SENT_BYTES_UDP_MESSAGES"));
        String SENT_BYTES_MULTICAST_KEY = "TOTAL_SENT_BYTES_MULTICAST_MESSAGES";
        StatisticsConstructor.addStatisticPane("SENT_MESSAGE_BYTES", "TOTAL_SENT_BYTES_MULTICAST_MESSAGES", new MulticastBytesSent("TOTAL_SENT_BYTES_MULTICAST_MESSAGES"));
        String SENT_BYTES_ALL_KEY = "SENT_BYTES_ALL";
        StatisticsConstructor.addStatisticPane("SENT_MESSAGE_BYTES", "SENT_BYTES_ALL", new AllBytesSent("SENT_BYTES_ALL"));
    }

    private static void addSentLimeStats(String SENT_KEY) {
        String LIMEWIRE_SENT_KEY = "SENT_LIMEWIRE";
        StatisticsConstructor.addGroupTreeNode(SENT_KEY, "SENT_LIMEWIRE");
        String LIME_NUMBER_KEY = "LIME_SENT_MESSAGES_NUMBER";
        StatisticsConstructor.addGroupTreeNode("SENT_LIMEWIRE", "LIME_SENT_MESSAGES_NUMBER");
        StatisticsConstructor.addSentLimeNumberStatsTCP("LIME_SENT_MESSAGES_NUMBER");
        StatisticsConstructor.addSentLimeNumberStatsUDP("LIME_SENT_MESSAGES_NUMBER");
        StatisticsConstructor.addSentLimeNumberStatsMulticast("LIME_SENT_MESSAGES_NUMBER");
        String LIME_BYTES_KEY = "LIME_SENT_MESSAGES_BYTES";
        StatisticsConstructor.addGroupTreeNode("SENT_LIMEWIRE", "LIME_SENT_MESSAGES_BYTES");
        StatisticsConstructor.addSentLimeBytesStatsTCP("LIME_SENT_MESSAGES_BYTES");
        StatisticsConstructor.addSentLimeBytesStatsUDP("LIME_SENT_MESSAGES_BYTES");
        StatisticsConstructor.addSentLimeBytesStatsMulticast("LIME_SENT_MESSAGES_BYTES");
    }

    private static void addSentLimeNumberStatsTCP(String LIME_NUMBER_KEY) {
        String TCP_KEY = "STATS_SENT_TCP";
        StatisticsConstructor.addGroupTreeNode(LIME_NUMBER_KEY, "STATS_SENT_TCP");
        String LIME_SENT_TCP_MESSAGES_KEY = "LIME_SENT_TCP_MESSAGES";
        StatisticsConstructor.addStatisticPane("STATS_SENT_TCP", "LIME_SENT_TCP_MESSAGES", new TCPLimeSentMessages("LIME_SENT_TCP_MESSAGES"));
        String LIME_SENT_TCP_PINGS_KEY = "LIME_SENT_TCP_PING_REQUESTS";
        StatisticsConstructor.addStatisticPane("STATS_SENT_TCP", "LIME_SENT_TCP_PING_REQUESTS", new TCPLimeSentPings("LIME_SENT_TCP_PING_REQUESTS"));
        String LIME_SENT_TCP_PONGS_KEY = "LIME_SENT_TCP_PING_REPLIES";
        StatisticsConstructor.addStatisticPane("STATS_SENT_TCP", "LIME_SENT_TCP_PING_REPLIES", new TCPLimeSentPongs("LIME_SENT_TCP_PING_REPLIES"));
        String LIME_SENT_TCP_QUERIES_KEY = "LIME_SENT_TCP_QUERIES";
        StatisticsConstructor.addStatisticPane("STATS_SENT_TCP", "LIME_SENT_TCP_QUERIES", new TCPLimeSentQueries("LIME_SENT_TCP_QUERIES"));
        String LIME_SENT_TCP_QUERY_REPLIES_KEY = "LIME_SENT_TCP_QUERY_REPLIES";
        StatisticsConstructor.addStatisticPane("STATS_SENT_TCP", "LIME_SENT_TCP_QUERY_REPLIES", new TCPLimeSentQueryReplies("LIME_SENT_TCP_QUERY_REPLIES"));
        String LIME_SENT_TCP_PUSH_REQUESTS_KEY = "LIME_SENT_TCP_PUSH_REQUESTS";
        StatisticsConstructor.addStatisticPane("STATS_SENT_TCP", "LIME_SENT_TCP_PUSH_REQUESTS", new TCPLimeSentPushRequests("LIME_SENT_TCP_PUSH_REQUESTS"));
    }

    private static void addSentLimeNumberStatsUDP(String LIME_NUMBER_KEY) {
        String UDP_KEY = "STATS_SENT_UDP";
        StatisticsConstructor.addGroupTreeNode(LIME_NUMBER_KEY, "STATS_SENT_UDP");
        String LIME_SENT_UDP_MESSAGES_KEY = "LIME_SENT_UDP_MESSAGES";
        StatisticsConstructor.addStatisticPane("STATS_SENT_UDP", "LIME_SENT_UDP_MESSAGES", new UDPLimeSentMessages("LIME_SENT_UDP_MESSAGES"));
        String LIME_SENT_UDP_PINGS_KEY = "LIME_SENT_UDP_PING_REQUESTS";
        StatisticsConstructor.addStatisticPane("STATS_SENT_UDP", "LIME_SENT_UDP_PING_REQUESTS", new UDPLimeSentPings("LIME_SENT_UDP_PING_REQUESTS"));
        String LIME_SENT_UDP_PONGS_KEY = "LIME_SENT_UDP_PING_REPLIES";
        StatisticsConstructor.addStatisticPane("STATS_SENT_UDP", "LIME_SENT_UDP_PING_REPLIES", new UDPLimeSentPongs("LIME_SENT_UDP_PING_REPLIES"));
        String LIME_SENT_UDP_QUERIES_KEY = "LIME_SENT_UDP_QUERIES";
        StatisticsConstructor.addStatisticPane("STATS_SENT_UDP", "LIME_SENT_UDP_QUERIES", new UDPLimeSentQueries("LIME_SENT_UDP_QUERIES"));
        String LIME_SENT_UDP_QUERY_REPLIES_KEY = "LIME_SENT_UDP_QUERY_REPLIES";
        StatisticsConstructor.addStatisticPane("STATS_SENT_UDP", "LIME_SENT_UDP_QUERY_REPLIES", new UDPLimeSentQueryReplies("LIME_SENT_UDP_QUERY_REPLIES"));
        String LIME_SENT_UDP_PUSH_REQUESTS_KEY = "LIME_SENT_UDP_PUSH_REQUESTS";
        StatisticsConstructor.addStatisticPane("STATS_SENT_UDP", "LIME_SENT_UDP_PUSH_REQUESTS", new UDPLimeSentPushRequests("LIME_SENT_UDP_PUSH_REQUESTS"));
    }

    private static void addSentLimeNumberStatsMulticast(String LIME_NUMBER_KEY) {
        String MULTICAST_KEY = "STATS_SENT_MULTICAST";
        StatisticsConstructor.addGroupTreeNode(LIME_NUMBER_KEY, "STATS_SENT_MULTICAST");
        String LIME_SENT_MULTICAST_MESSAGES_KEY = "LIME_SENT_MULTICAST_MESSAGES";
        StatisticsConstructor.addStatisticPane("STATS_SENT_MULTICAST", "LIME_SENT_MULTICAST_MESSAGES", new MulticastLimeSentMessages("LIME_SENT_MULTICAST_MESSAGES"));
        String LIME_SENT_MULTICAST_PINGS_KEY = "LIME_SENT_MULTICAST_PING_REQUESTS";
        StatisticsConstructor.addStatisticPane("STATS_SENT_MULTICAST", "LIME_SENT_MULTICAST_PING_REQUESTS", new MulticastLimeSentPings("LIME_SENT_MULTICAST_PING_REQUESTS"));
        String LIME_SENT_MULTICAST_PONGS_KEY = "LIME_SENT_MULTICAST_PING_REPLIES";
        StatisticsConstructor.addStatisticPane("STATS_SENT_MULTICAST", "LIME_SENT_MULTICAST_PING_REPLIES", new MulticastLimeSentPongs("LIME_SENT_MULTICAST_PING_REPLIES"));
        String LIME_SENT_MULTICAST_QUERIES_KEY = "LIME_SENT_MULTICAST_QUERIES";
        StatisticsConstructor.addStatisticPane("STATS_SENT_MULTICAST", "LIME_SENT_MULTICAST_QUERIES", new MulticastLimeSentQueries("LIME_SENT_MULTICAST_QUERIES"));
        String LIME_SENT_MULTICAST_QUERY_REPLIES_KEY = "LIME_SENT_MULTICAST_QUERY_REPLIES";
        StatisticsConstructor.addStatisticPane("STATS_SENT_MULTICAST", "LIME_SENT_MULTICAST_QUERY_REPLIES", new MulticastLimeSentQueryReplies("LIME_SENT_MULTICAST_QUERY_REPLIES"));
        String LIME_SENT_MULTICAST_PUSH_REQUESTS_KEY = "LIME_SENT_MULTICAST_PUSH_REQUESTS";
        StatisticsConstructor.addStatisticPane("STATS_SENT_MULTICAST", "LIME_SENT_MULTICAST_PUSH_REQUESTS", new MulticastLimeSentPushRequests("LIME_SENT_MULTICAST_PUSH_REQUESTS"));
    }

    private static void addSentLimeBytesStatsTCP(String LIME_BYTES_KEY) {
        String TCP_KEY = "STATS_SENT_TCP_BYTES";
        StatisticsConstructor.addGroupTreeNode(LIME_BYTES_KEY, "STATS_SENT_TCP_BYTES");
        String LIME_SENT_TCP_MESSAGES_KEY = "LIME_SENT_BYTES_TCP_MESSAGES";
        StatisticsConstructor.addStatisticPane("STATS_SENT_TCP_BYTES", "LIME_SENT_BYTES_TCP_MESSAGES", new TCPLimeSentBytes("LIME_SENT_BYTES_TCP_MESSAGES"));
        String LIME_SENT_TCP_PINGS_KEY = "LIME_SENT_BYTES_TCP_PING_REQUESTS";
        StatisticsConstructor.addStatisticPane("STATS_SENT_TCP_BYTES", "LIME_SENT_BYTES_TCP_PING_REQUESTS", new TCPLimeSentPingsBytes("LIME_SENT_BYTES_TCP_PING_REQUESTS"));
        String LIME_SENT_TCP_PONGS_KEY = "LIME_SENT_BYTES_TCP_PING_REPLIES";
        StatisticsConstructor.addStatisticPane("STATS_SENT_TCP_BYTES", "LIME_SENT_BYTES_TCP_PING_REPLIES", new TCPLimeSentPongsBytes("LIME_SENT_BYTES_TCP_PING_REPLIES"));
        String LIME_SENT_TCP_QUERIES_KEY = "LIME_SENT_BYTES_TCP_QUERIES";
        StatisticsConstructor.addStatisticPane("STATS_SENT_TCP_BYTES", "LIME_SENT_BYTES_TCP_QUERIES", new TCPLimeSentQueriesBytes("LIME_SENT_BYTES_TCP_QUERIES"));
        String LIME_SENT_TCP_QUERY_REPLIES_KEY = "LIME_SENT_BYTES_TCP_QUERY_REPLIES";
        StatisticsConstructor.addStatisticPane("STATS_SENT_TCP_BYTES", "LIME_SENT_BYTES_TCP_QUERY_REPLIES", new TCPLimeSentQueryRepliesBytes("LIME_SENT_BYTES_TCP_QUERY_REPLIES"));
        String LIME_SENT_TCP_PUSH_REQUESTS_KEY = "LIME_SENT_BYTES_TCP_PUSH_REQUESTS";
        StatisticsConstructor.addStatisticPane("STATS_SENT_TCP_BYTES", "LIME_SENT_BYTES_TCP_PUSH_REQUESTS", new TCPLimeSentPushRequestsBytes("LIME_SENT_BYTES_TCP_PUSH_REQUESTS"));
    }

    private static void addSentLimeBytesStatsUDP(String LIME_BYTES_KEY) {
        String UDP_KEY = "STATS_SENT_UDP_BYTES";
        StatisticsConstructor.addGroupTreeNode(LIME_BYTES_KEY, "STATS_SENT_UDP_BYTES");
        String LIME_SENT_UDP_MESSAGES_KEY = "LIME_SENT_BYTES_UDP_MESSAGES";
        StatisticsConstructor.addStatisticPane("STATS_SENT_UDP_BYTES", "LIME_SENT_BYTES_UDP_MESSAGES", new UDPLimeSentBytes("LIME_SENT_BYTES_UDP_MESSAGES"));
        String LIME_SENT_UDP_PINGS_KEY = "LIME_SENT_BYTES_UDP_PING_REQUESTS";
        StatisticsConstructor.addStatisticPane("STATS_SENT_UDP_BYTES", "LIME_SENT_BYTES_UDP_PING_REQUESTS", new UDPLimeSentPingsBytes("LIME_SENT_BYTES_UDP_PING_REQUESTS"));
        String LIME_SENT_UDP_PONGS_KEY = "LIME_SENT_BYTES_UDP_PING_REPLIES";
        StatisticsConstructor.addStatisticPane("STATS_SENT_UDP_BYTES", "LIME_SENT_BYTES_UDP_PING_REPLIES", new UDPLimeSentPongsBytes("LIME_SENT_BYTES_UDP_PING_REPLIES"));
        String LIME_SENT_UDP_QUERIES_KEY = "LIME_SENT_BYTES_UDP_QUERIES";
        StatisticsConstructor.addStatisticPane("STATS_SENT_UDP_BYTES", "LIME_SENT_BYTES_UDP_QUERIES", new UDPLimeSentQueriesBytes("LIME_SENT_BYTES_UDP_QUERIES"));
        String LIME_SENT_UDP_QUERY_REPLIES_KEY = "LIME_SENT_BYTES_UDP_QUERY_REPLIES";
        StatisticsConstructor.addStatisticPane("STATS_SENT_UDP_BYTES", "LIME_SENT_BYTES_UDP_QUERY_REPLIES", new UDPLimeSentQueryRepliesBytes("LIME_SENT_BYTES_UDP_QUERY_REPLIES"));
        String LIME_SENT_UDP_PUSH_REQUESTS_KEY = "LIME_SENT_BYTES_UDP_PUSH_REQUESTS";
        StatisticsConstructor.addStatisticPane("STATS_SENT_UDP_BYTES", "LIME_SENT_BYTES_UDP_PUSH_REQUESTS", new UDPLimeSentPushRequestsBytes("LIME_SENT_BYTES_UDP_PUSH_REQUESTS"));
    }

    private static void addSentLimeBytesStatsMulticast(String LIME_BYTES_KEY) {
        String MULTICAST_KEY = "STATS_SENT_MULTICAST_BYTES";
        StatisticsConstructor.addGroupTreeNode(LIME_BYTES_KEY, "STATS_SENT_MULTICAST_BYTES");
        String LIME_SENT_MULTICAST_MESSAGES_KEY = "LIME_SENT_BYTES_MULTICAST_MESSAGES";
        StatisticsConstructor.addStatisticPane("STATS_SENT_MULTICAST_BYTES", "LIME_SENT_BYTES_MULTICAST_MESSAGES", new MulticastLimeSentBytes("LIME_SENT_BYTES_MULTICAST_MESSAGES"));
        String LIME_SENT_MULTICAST_PINGS_KEY = "LIME_SENT_BYTES_MULTICAST_PING_REQUESTS";
        StatisticsConstructor.addStatisticPane("STATS_SENT_MULTICAST_BYTES", "LIME_SENT_BYTES_MULTICAST_PING_REQUESTS", new MulticastLimeSentPingsBytes("LIME_SENT_BYTES_MULTICAST_PING_REQUESTS"));
        String LIME_SENT_MULTICAST_PONGS_KEY = "LIME_SENT_BYTES_MULTICAST_PING_REPLIES";
        StatisticsConstructor.addStatisticPane("STATS_SENT_MULTICAST_BYTES", "LIME_SENT_BYTES_MULTICAST_PING_REPLIES", new MulticastLimeSentPongsBytes("LIME_SENT_BYTES_MULTICAST_PING_REPLIES"));
        String LIME_SENT_MULTICAST_QUERIES_KEY = "LIME_SENT_BYTES_MULTICAST_QUERIES";
        StatisticsConstructor.addStatisticPane("STATS_SENT_MULTICAST_BYTES", "LIME_SENT_BYTES_MULTICAST_QUERIES", new MulticastLimeSentQueriesBytes("LIME_SENT_BYTES_MULTICAST_QUERIES"));
        String LIME_SENT_MULTICAST_QUERY_REPLIES_KEY = "LIME_SENT_BYTES_MULTICAST_QUERY_REPLIES";
        StatisticsConstructor.addStatisticPane("STATS_SENT_MULTICAST_BYTES", "LIME_SENT_BYTES_MULTICAST_QUERY_REPLIES", new MulticastLimeSentQueryRepliesBytes("LIME_SENT_BYTES_MULTICAST_QUERY_REPLIES"));
        String LIME_SENT_MULTICAST_PUSH_REQUESTS_KEY = "LIME_SENT_BYTES_MULTICAST_PUSH_REQUESTS";
        StatisticsConstructor.addStatisticPane("STATS_SENT_MULTICAST_BYTES", "LIME_SENT_BYTES_MULTICAST_PUSH_REQUESTS", new MulticastLimeSentPushRequestsBytes("LIME_SENT_BYTES_MULTICAST_PUSH_REQUESTS"));
    }

    private static void addStatisticPane(String parentKey, String key, PaneItem item) {
        StatisticsPaneImpl pane = new StatisticsPaneImpl("STATS_" + key + "_TITLE");
        pane.add(item);
        _treeManager.addNode(parentKey, pane);
        _paneManager.addPane(pane);
    }

    private static void addGroupTreeNode(String parentKey, String childKey) {
        StatisticsPaneParent pane = new StatisticsPaneParent(childKey);
        _treeManager.addNode(parentKey, pane);
        _paneManager.addPane(pane);
    }

    private static void addGroupTreeNode(String parentKey, StatisticsPane pane) {
        _treeManager.addNode(parentKey, pane);
        _paneManager.addPane(pane);
    }

    public void setStatisticsVisible(boolean visible) {
        if (visible) {
            DIALOG.setLocationRelativeTo(GUIMediator.getAppFrame());
            DIALOG.show();
        } else {
            DIALOG.dispose();
        }
    }

    public boolean isStatisticsVisible() {
        return DIALOG.isVisible();
    }

    public static Component getMainComponent() {
        return DIALOG;
    }

    public static JComponent getComponent() {
        return MAIN_PANEL;
    }

    public static JComponent getStatDisplayComponent() {
        return _paneManager.getFirstDisplayedPaneItem().getStatsComponent();
    }

    static {
        MAIN_PANEL = new PaddedPanel();
        SPLIT_PANE = new JSplitPane(1);
    }

    private class PaneAdapter
    extends ComponentAdapter {
        private PaneAdapter() {
        }

        public void componentResized(ComponentEvent e) {
            _paneManager.componentResized(e);
        }
    }
}

