/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.search.Selector;
import com.limegroup.gnutella.settings.AbstractSettings;
import com.limegroup.gnutella.settings.SettingsFactory;
import com.limegroup.gnutella.settings.StringSetting;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Map;

class SelectorsHandler
extends AbstractSettings {
    private static final SelectorsHandler INSTANCE = new SelectorsHandler();
    private static final SettingsFactory FACTORY = INSTANCE.getFactory();
    private static final Map FILTERS = new HashMap();

    public static SelectorsHandler instance() {
        return INSTANCE;
    }

    private SelectorsHandler() {
        super("filters.props", "LimeWire Filters File");
    }

    public static Selector getSelector(String type, int depth) {
        String key = type + "_" + depth;
        SelectorSettingPair pair = (SelectorSettingPair)FILTERS.get(key);
        if (pair == null) {
            pair = SelectorsHandler.addDefault(type, depth);
        }
        return pair.selector;
    }

    public static void setSelector(String type, int depth, Selector selector) {
        String key = type + "_" + depth;
        SelectorSettingPair pair = (SelectorSettingPair)FILTERS.get(key);
        if (pair == null) {
            pair = SelectorsHandler.addDefault(type, depth);
        }
        StringSetting setting = pair.setting;
        setting.setValue(selector.toString());
        FILTERS.put(key, new SelectorSettingPair(selector, setting));
    }

    private static SelectorSettingPair addDefault(String type, int depth) {
        String key = type + "_" + depth;
        Selector selector = SelectorsHandler.getDefaultSelector(type, depth);
        StringSetting setting = FACTORY.createStringSetting(key, selector.toString());
        try {
            selector = Selector.createFromString(setting.getValue());
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        SelectorSettingPair pair = new SelectorSettingPair(selector, setting);
        FILTERS.put(key, pair);
        return pair;
    }

    private static Selector getDefaultSelector(String type, int depth) {
        if ("*".equals(type)) {
            switch (depth) {
                case 0: {
                    return Selector.createSchemaSelector();
                }
                case 1: {
                    return Selector.createFieldSelector("audio", "audios__audio__artist__");
                }
                case 2: {
                    return Selector.createFieldSelector("audio", "audios__audio__album__");
                }
            }
        } else if ("audio".equals(type)) {
            switch (depth) {
                case 0: {
                    return Selector.createFieldSelector("audio", "audios__audio__genre__");
                }
                case 1: {
                    return Selector.createFieldSelector("audio", "audios__audio__artist__");
                }
                case 2: {
                    return Selector.createFieldSelector("audio", "audios__audio__album__");
                }
            }
        } else if ("video".equals(type)) {
            switch (depth) {
                case 0: {
                    return Selector.createPropertySelector("RESULT_PANEL_TYPE");
                }
                case 1: {
                    return Selector.createFieldSelector("video", "videos__video__type__");
                }
                case 2: {
                    return Selector.createFieldSelector("video", "videos__video__rating__");
                }
            }
        } else {
            switch (depth) {
                case 0: {
                    return Selector.createSchemaSelector();
                }
                case 1: {
                    return Selector.createPropertySelector("RESULT_PANEL_TYPE");
                }
                case 2: {
                    return Selector.createPropertySelector("RESULT_PANEL_SPEED");
                }
            }
        }
        throw new IllegalArgumentException("invalid depth: " + depth);
    }

    private static class SelectorSettingPair {
        private final Selector selector;
        private final StringSetting setting;

        SelectorSettingPair(Selector selector, StringSetting setting) {
            this.selector = selector;
            this.setting = setting;
        }
    }
}

