/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.util.ApproximateMatcher;
import com.sun.java.util.collections.Set;

final class SearchResult {
    private final RemoteFileDesc RFD;
    private final HostData DATA;
    private Set _alts;
    private String processedFilename = null;

    SearchResult(RemoteFileDesc rfd, HostData data, Set alts) {
        this.RFD = rfd;
        this.DATA = data;
        this._alts = alts;
    }

    RemoteFileDesc getRemoteFileDesc() {
        return this.RFD;
    }

    HostData getHostData() {
        return this.DATA;
    }

    Set getAlts() {
        return this._alts;
    }

    void clearAlts() {
        this._alts = null;
    }

    void setAlts(Set alts) {
        this._alts = alts;
    }

    int getSize() {
        return this.RFD.getSize();
    }

    String getFilenameNoExtension() {
        String fullname = this.RFD.getFileName();
        int i = fullname.lastIndexOf(".");
        if (i < 0) {
            return fullname;
        }
        return fullname.substring(0, i);
    }

    String getExtension() {
        String fullname = this.RFD.getFileName();
        int i = fullname.lastIndexOf(".");
        if (i < 0) {
            return "";
        }
        return fullname.substring(i + 1);
    }

    private String getProcessedFilename(ApproximateMatcher matcher) {
        if (this.processedFilename != null) {
            return this.processedFilename;
        }
        this.processedFilename = matcher.process(this.getFilenameNoExtension());
        return this.processedFilename;
    }

    int match(SearchResult o, ApproximateMatcher matcher) {
        float floatSizeNew;
        this.getProcessedFilename(matcher);
        o.getProcessedFilename(matcher);
        if (!this.getExtension().equals(o.getExtension())) {
            return 1;
        }
        float floatSizeThis = this.getSize();
        float sizeDiff = Math.abs(floatSizeThis - (floatSizeNew = (float)o.getSize()));
        if (sizeDiff > 60000.0f) {
            return 2;
        }
        int allowedDifferences = Math.round(Math.min(0.1f * (float)this.getFilenameNoExtension().length(), 0.1f * (float)o.getFilenameNoExtension().length()));
        allowedDifferences = Math.min(allowedDifferences, 4);
        if (!matcher.matches(this.getProcessedFilename(matcher), o.getProcessedFilename(matcher), allowedDifferences)) {
            return 3;
        }
        return 0;
    }
}

