/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.AutoCompleteTextField;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.KeyProcessingTextField;
import com.limegroup.gnutella.gui.search.DitherPanel;
import com.limegroup.gnutella.gui.search.Ditherer;
import com.limegroup.gnutella.gui.search.NamedMediaType;
import com.limegroup.gnutella.gui.search.SchemaBox;
import com.limegroup.gnutella.gui.search.SearchField;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.settings.FilterSettings;
import com.limegroup.gnutella.settings.ThemeFileHandler;
import com.limegroup.gnutella.settings.ThemeSettings;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.gui.InputPanel;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;

class SearchInputPanel
extends JPanel {
    private final JLabel WHATSNEW_SEARCH_LABEL = new JLabel();
    private final JLabel SEARCH_TYPE_LABEL = new JLabel();
    private final SearchField SEARCH_FIELD = new SearchField(15);
    private final AutoCompleteTextField BROWSE_HOST_FIELD = new AutoCompleteTextField();
    private final JButton WHATSNEW = new JButton(GUIMediator.getStringResource("SEARCH_TYPE_WHATSNEW"));
    private final JTabbedPane PANE = new JTabbedPane(3);
    private final CardLayout META_CARDS = new CardLayout();
    private final JPanel META_PANEL = new JPanel(this.META_CARDS);
    private static final String DEFAULT_PANEL_KEY = "defaultPanel";
    private final SchemaBox SCHEMA_BOX = new SchemaBox();
    private final Ditherer DITHERER = new Ditherer(62, ThemeFileHandler.SEARCH_PANEL_BG_1.getValue(), ThemeFileHandler.SEARCH_PANEL_BG_2.getValue());
    private final ActionListener SEARCH_LISTENER = new SearchListener();

    SearchInputPanel() {
        super(new BorderLayout(0, 5));
        SchemaListener schemaListener = new SchemaListener();
        this.SCHEMA_BOX.addSelectionListener(schemaListener);
        this.add((Component)this.SCHEMA_BOX, "North");
        JPanel searchEntry = this.createSearchEntryPanel();
        JPanel whatsnew = this.createWhatIsNewPanel();
        JPanel browseHost = this.createBrowseHostPanel();
        this.panelize(searchEntry);
        this.panelize(whatsnew);
        this.panelize(browseHost);
        this.PANE.add(GUIMediator.getStringResource("SEARCH_TYPE_KEYWORD"), searchEntry);
        this.PANE.add(GUIMediator.getStringResource("SEARCH_TYPE_WHATSNEW"), whatsnew);
        if (!ThemeSettings.isNativeTheme()) {
            this.PANE.setBorder(new LineBorder(ThemeFileHandler.SEARCH_GRID_COLOR.getValue()){

                public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                    try {
                        Component sel = SearchInputPanel.this.PANE.getSelectedComponent();
                        if (sel != null) {
                            height = sel.getBounds().height + 4;
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException aioobe) {
                        // empty catch block
                    }
                    super.paintBorder(c, g, x, y, width, height);
                }
            });
        }
        this.add((Component)this.PANE, "Center");
        this.add(Box.createVerticalStrut(20), "South");
        this.WHATSNEW_SEARCH_LABEL.setFont(UIManager.getFont("Table.font.bold"));
        Font bold = UIManager.getFont("Table.font.bold");
        Font bolder = new Font(bold.getName(), bold.getStyle(), bold.getSize() + 5);
        this.SEARCH_TYPE_LABEL.setFont(bolder);
        this.SEARCH_TYPE_LABEL.setPreferredSize(new Dimension(100, 20));
        schemaListener.actionPerformed(null);
    }

    KeyProcessingTextField getForwardingSearchField() {
        if (this.isNormalSearchType()) {
            return this.SEARCH_FIELD;
        }
        if (this.isBrowseHostSearchType()) {
            return this.BROWSE_HOST_FIELD;
        }
        return null;
    }

    boolean isKeyEventForwardable() {
        return this.isNormalSearchType() || this.isBrowseHostSearchType();
    }

    boolean isBrowseHostSearchType() {
        return this.PANE.getSelectedIndex() == 2;
    }

    boolean isWhatIsNewSearchType() {
        return this.PANE.getSelectedIndex() == 1;
    }

    boolean isNormalSearchType() {
        return this.PANE.getSelectedIndex() == 0;
    }

    void requestSearchFocusImmediately() {
        if (this.isNormalSearchType()) {
            if (this.SCHEMA_BOX.getSelectedSchema() != null) {
                this.getInputPanel().requestFirstFocus();
            } else {
                this.SEARCH_FIELD.requestFocus();
            }
        } else if (this.isWhatIsNewSearchType()) {
            this.WHATSNEW.requestFocus();
        } else if (this.isBrowseHostSearchType()) {
            this.BROWSE_HOST_FIELD.requestFocus();
        }
    }

    void requestSearchFocus() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SearchInputPanel.this.requestSearchFocusImmediately();
            }
        });
    }

    private void panelize(JComponent c) {
        GUIUtils.setOpaque(false, c);
        if (!ThemeSettings.isNativeTheme()) {
            c.setOpaque(true);
        }
        c.setBackground(ThemeFileHandler.SEARCH_PANEL_BG_2.getValue());
        c.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 0));
    }

    private JPanel createBrowseHostPanel() {
        this.BROWSE_HOST_FIELD.addActionListener(this.SEARCH_LISTENER);
        JLabel label = new JLabel(GUIMediator.getStringResource("SEARCH_BROWSEHOST_TITLE"));
        label.setFont(UIManager.getFont("Table.font.bold"));
        label.setPreferredSize(new Dimension(GUIUtils.width(label), 10));
        BoxPanel labelPanel = new BoxPanel(1);
        labelPanel.add(GUIUtils.center(label));
        JTextArea text = new JTextArea(GUIMediator.getStringResource("SEARCH_BROWSEHOST_DESC"));
        text.setLineWrap(true);
        text.setWrapStyleWord(true);
        text.setColumns(15);
        text.setEditable(false);
        text.setFont(UIManager.getFont("Table.font"));
        text.setForeground(label.getForeground());
        JButton search = new JButton(GUIMediator.getStringResource("SEARCH_BROWSEHOST_BUTTON"));
        search.addActionListener(this.SEARCH_LISTENER);
        BoxPanel panel = new BoxPanel(1);
        panel.add(labelPanel);
        panel.add(Box.createVerticalStrut(15));
        panel.add(text);
        panel.add(Box.createVerticalStrut(15));
        panel.add(this.BROWSE_HOST_FIELD);
        panel.add(Box.createVerticalStrut(15));
        panel.add(GUIUtils.center(search));
        DitherPanel centered = new DitherPanel(this.DITHERER);
        centered.setLayout(new FlowLayout(1, 0, 0));
        centered.add(panel);
        return centered;
    }

    private JPanel createWhatIsNewPanel() {
        JLabel label = new JLabel(GUIMediator.getStringResource("SEARCH_WHATSNEW_TITLE_ONE"));
        label.setFont(UIManager.getFont("Table.font.bold"));
        label.setPreferredSize(new Dimension(GUIUtils.width(label), 10));
        JLabel label2 = new JLabel(GUIMediator.getStringResource("SEARCH_WHATSNEW_TITLE_TWO"));
        label2.setFont(UIManager.getFont("Table.font.bold"));
        BoxPanel labelPanel = new BoxPanel(1);
        labelPanel.add(GUIUtils.center(label));
        labelPanel.add(GUIUtils.center(label2));
        JTextArea text = new JTextArea(GUIMediator.getStringResource("SEARCH_WHATSNEW_DESC"));
        text.setLineWrap(true);
        text.setWrapStyleWord(true);
        text.setColumns(15);
        text.setEditable(false);
        text.setFont(UIManager.getFont("Table.font"));
        text.setForeground(label.getForeground());
        JTextArea type = new JTextArea(GUIMediator.getStringResource("SEARCH_CURRENT_SEARCH") + "  ");
        type.setFont(UIManager.getFont("Table.font"));
        type.setEditable(false);
        type.setForeground(label.getForeground());
        JPanel typePanel = new JPanel(new FlowLayout(1, 0, 0));
        typePanel.add(type);
        typePanel.add(this.WHATSNEW_SEARCH_LABEL);
        this.WHATSNEW.addActionListener(this.SEARCH_LISTENER);
        final JCheckBox hideAdult = new JCheckBox(GUIMediator.getStringResource("SEARCH_WHATSNEW_HIDE_ADULT"), FilterSettings.FILTER_WHATS_NEW_ADULT.getValue());
        hideAdult.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                FilterSettings.FILTER_WHATS_NEW_ADULT.setValue(hideAdult.isSelected());
            }
        });
        BoxPanel panel = new BoxPanel(1);
        panel.add(labelPanel);
        panel.add(Box.createVerticalStrut(15));
        panel.add(text);
        panel.add(Box.createVerticalStrut(30));
        panel.add(typePanel);
        panel.add(Box.createVerticalStrut(5));
        panel.add(GUIUtils.center(this.WHATSNEW));
        if (!FilterSettings.FILTER_ADULT.getValue()) {
            panel.add(Box.createVerticalStrut(30));
            panel.add(GUIUtils.center(hideAdult));
        }
        DitherPanel centered = new DitherPanel(this.DITHERER);
        centered.setLayout(new FlowLayout(1, 0, 0));
        centered.add(panel);
        return centered;
    }

    private JPanel createSearchEntryPanel() {
        this.SEARCH_FIELD.addActionListener(this.SEARCH_LISTENER);
        this.META_PANEL.add((Component)this.createDefaultSearchPanel(), DEFAULT_PANEL_KEY);
        List medias = NamedMediaType.getAllNamedMediaTypes();
        Iterator i = medias.iterator();
        while (i.hasNext()) {
            NamedMediaType nmt = (NamedMediaType)i.next();
            String name = nmt.getName();
            LimeXMLSchema schema = nmt.getSchema();
            if (schema == null) continue;
            InputPanel panel = new InputPanel(schema, this.SEARCH_LISTENER, this.SEARCH_FIELD.getDocument());
            panel.addMoreOptionsListener(new MoreOptionsListener());
            JScrollPane pane = new JScrollPane(panel, 20, 31);
            pane.setOpaque(false);
            pane.setBorder(BorderFactory.createEmptyBorder());
            pane.getViewport().setBorder(null);
            BoxPanel box = new BoxPanel(1);
            box.add(pane);
            box.add(Box.createVerticalStrut(5));
            box.add(this.createSearchButtonPanel());
            this.META_PANEL.add((Component)GUIUtils.left(box), name);
        }
        DitherPanel search = new DitherPanel(this.DITHERER);
        search.setLayout(new BoxLayout(search, 1));
        search.add(GUIUtils.left(this.SEARCH_TYPE_LABEL));
        search.add(Box.createVerticalStrut(5));
        search.add(this.META_PANEL);
        return search;
    }

    private JPanel createDefaultSearchPanel() {
        JPanel label = this.createLabel(GUIMediator.getStringResource("SEARCH_DEFAULT_FIELD_TITLE"));
        BoxPanel fullPanel = new BoxPanel(1);
        fullPanel.add(label);
        fullPanel.add(Box.createVerticalStrut(3));
        fullPanel.add(GUIUtils.left(this.SEARCH_FIELD));
        fullPanel.add(Box.createVerticalStrut(5));
        fullPanel.add(this.createSearchButtonPanel());
        return GUIUtils.left(fullPanel);
    }

    private JPanel createLabel(String text) {
        BoxPanel labelPanel = new BoxPanel(0);
        labelPanel.setOpaque(false);
        labelPanel.add(new JLabel(text));
        labelPanel.add(Box.createHorizontalGlue());
        return labelPanel;
    }

    private JPanel createSearchButtonPanel() {
        JPanel b = new JPanel(new FlowLayout(0, 0, 0));
        JButton searchButton = new JButton(GUIMediator.getStringResource("SEARCH_SEARCH_BUTTON_LABEL"));
        searchButton.setToolTipText(GUIMediator.getStringResource("SEARCH_SEARCH_BUTTON_TIP"));
        searchButton.addActionListener(this.SEARCH_LISTENER);
        b.add(Box.createHorizontalGlue());
        b.add(searchButton);
        return b;
    }

    private JComponent getVisibleComponent() {
        int i = 0;
        while (i < this.META_PANEL.getComponentCount()) {
            Component current = this.META_PANEL.getComponent(i);
            if (current.isVisible()) {
                return (JComponent)current;
            }
            ++i;
        }
        return null;
    }

    private JScrollPane getVisibleScrollPane() {
        JComponent parent = (JComponent)this.getVisibleComponent().getComponent(0);
        Object pane = null;
        int i = 0;
        while (i < parent.getComponentCount()) {
            Component current = parent.getComponent(i);
            if (current.isVisible() && current instanceof JScrollPane) {
                return (JScrollPane)current;
            }
            ++i;
        }
        return null;
    }

    private InputPanel getInputPanel() {
        JScrollPane pane = this.getVisibleScrollPane();
        if (pane == null) {
            return null;
        }
        return (InputPanel)pane.getViewport().getView();
    }

    private class MoreOptionsListener
    implements ActionListener {
        private MoreOptionsListener() {
        }

        public void actionPerformed(ActionEvent e) {
            JCheckBox box = (JCheckBox)e.getSource();
            JComponent c = SearchInputPanel.this.getVisibleComponent();
            if (box.isSelected()) {
                c.setLayout(new BoxLayout(c, 1));
            } else {
                c.setLayout(new FlowLayout(0, 0, 0));
            }
            SearchInputPanel.this.invalidate();
            SearchInputPanel.this.revalidate();
            SearchInputPanel.this.repaint();
        }
    }

    private class SearchListener
    implements ActionListener {
        private SearchListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String query = null;
            String xml = null;
            MediaType mt = SearchInputPanel.this.SCHEMA_BOX.getSelectedMediaType();
            InputPanel panel = null;
            SearchInformation info = null;
            if (SearchInputPanel.this.isWhatIsNewSearchType()) {
                info = SearchInformation.createWhatsNewSearch(SearchInputPanel.this.SCHEMA_BOX.getSelectedItem(), mt);
            } else if (SearchInputPanel.this.isNormalSearchType()) {
                if (SearchInputPanel.this.SCHEMA_BOX.getSelectedSchema() != null) {
                    panel = SearchInputPanel.this.getInputPanel();
                    query = panel.getStandardQuery();
                    xml = panel.getInput(true);
                } else {
                    query = SearchInputPanel.this.SEARCH_FIELD.getText();
                }
                info = SearchInformation.createKeywordSearch(query, xml, mt);
            } else if (SearchInputPanel.this.isBrowseHostSearchType()) {
                String user = SearchInputPanel.this.BROWSE_HOST_FIELD.getText();
                info = SearchInformation.createBrowseHostSearch(user);
                mt = MediaType.getAnyTypeMediaType();
            }
            if (SearchMediator.triggerSearch(info) != null) {
                if (info.isKeywordSearch()) {
                    if (panel != null) {
                        panel.storeInput();
                        panel.clear();
                    } else {
                        SearchInputPanel.this.SEARCH_FIELD.addToDictionary();
                    }
                    SearchInputPanel.this.SEARCH_FIELD.setText("");
                } else if (info.isBrowseHostSearch()) {
                    SearchInputPanel.this.BROWSE_HOST_FIELD.addToDictionary();
                    SearchInputPanel.this.BROWSE_HOST_FIELD.setText("");
                }
            }
        }
    }

    private class SchemaListener
    implements ActionListener {
        private SchemaListener() {
        }

        public void actionPerformed(ActionEvent event) {
            if (SearchInputPanel.this.SCHEMA_BOX.getSelectedSchema() != null) {
                SearchInputPanel.this.META_CARDS.show(SearchInputPanel.this.META_PANEL, SearchInputPanel.this.SCHEMA_BOX.getSelectedItem());
            } else {
                SearchInputPanel.this.META_CARDS.show(SearchInputPanel.this.META_PANEL, SearchInputPanel.DEFAULT_PANEL_KEY);
            }
            SearchInputPanel.this.WHATSNEW_SEARCH_LABEL.setText(SearchInputPanel.this.SCHEMA_BOX.getSelectedItem());
            SearchInputPanel.this.WHATSNEW_SEARCH_LABEL.setPreferredSize(new Dimension(GUIUtils.width(SearchInputPanel.this.WHATSNEW_SEARCH_LABEL), 20));
            SearchInputPanel.this.SEARCH_TYPE_LABEL.setText(SearchInputPanel.this.SCHEMA_BOX.getSelectedItem());
            SearchInputPanel.this.requestSearchFocus();
        }
    }
}

