/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.util.IpPort;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;

class SearchInformation {
    public static final int KEYWORD = 0;
    public static final int WHATS_NEW = 1;
    public static final int BROWSE_HOST = 2;
    public static final String WHATS_NEW_DESC = GUIMediator.getStringResource("SEARCH_WHATS_NEW_SMALL");
    private final int type;
    private final String query;
    private final String xml;
    private final MediaType media;

    private SearchInformation(int type, String query, String xml, MediaType media) {
        if (media == null) {
            throw new NullPointerException("null media");
        }
        if (query == null) {
            throw new NullPointerException("null query");
        }
        this.type = type;
        this.query = query;
        this.xml = xml;
        this.media = media;
    }

    static SearchInformation createKeywordSearch(String query, String xml, MediaType media) {
        return new SearchInformation(0, query, xml, media);
    }

    static SearchInformation createWhatsNewSearch(String name, MediaType type) {
        return new SearchInformation(1, WHATS_NEW_DESC + " - " + name, null, type);
    }

    static SearchInformation createBrowseHostSearch(String desc) {
        return new SearchInformation(2, desc, null, MediaType.getAnyTypeMediaType());
    }

    String getQuery() {
        return this.query;
    }

    String getXML() {
        return this.xml;
    }

    MediaType getMediaType() {
        return this.media;
    }

    IpPort getIpPort() {
        if (!this.isBrowseHostSearch()) {
            throw new IllegalStateException();
        }
        StringTokenizer st = new StringTokenizer(this.getQuery(), ":");
        String host = null;
        int port = 6346;
        if (st.hasMoreTokens()) {
            host = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            try {
                port = Integer.parseInt(st.nextToken());
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
        }
        InetAddress addr = null;
        try {
            addr = InetAddress.getByName(host);
        }
        catch (UnknownHostException ignored) {
            // empty catch block
        }
        final String _host = host;
        final int _port = port;
        final InetAddress _addr = addr;
        return new IpPort(){

            public InetAddress getInetAddress() {
                return _addr;
            }

            public String getAddress() {
                return _host;
            }

            public int getPort() {
                return _port;
            }
        };
    }

    boolean isXMLSearch() {
        return this.xml != null && !this.xml.equals("");
    }

    boolean isKeywordSearch() {
        return this.type == 0;
    }

    boolean isWhatsNewSearch() {
        return this.type == 1;
    }

    boolean isBrowseHostSearch() {
        return this.type == 2;
    }
}

