/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.search.ResultPanel;
import java.awt.event.ActionListener;
import javax.swing.JButton;

final class SearchButtons {
    private final ButtonRow BUTTONS;
    static final int DOWNLOAD_BUTTON_INDEX = 0;
    static final int BROWSE_BUTTON_INDEX = 1;
    static final int STOP_BUTTON_INDEX = 2;
    private static final String DOWNLOAD_BUTTON_LABEL = GUIMediator.getStringResource("SEARCH_DOWNLOAD_BUTTON_LABEL");
    private static final String DOWNLOAD_BUTTON_TIP = GUIMediator.getStringResource("SEARCH_DOWNLOAD_BUTTON_TIP");
    private static final String WISHLIST_BUTTON_LABEL = GUIMediator.getStringResource("SEARCH_WISHLIST_BUTTON_LABEL");
    private static final String WISHLIST_BUTTON_TIP = GUIMediator.getStringResource("SEARCH_WISHLIST_BUTTON_TIP");

    SearchButtons(ResultPanel rp) {
        String[] buttonLabelKeys = new String[]{"SEARCH_WISHLIST_BUTTON_LABEL", "SEARCH_BROWSE_HOST_BUTTON_LABEL", "SEARCH_STOP_BUTTON_LABEL"};
        String[] buttonTipKeys = new String[]{"SEARCH_WISHLIST_BUTTON_TIP", "SEARCH_BROWSE_HOST_BUTTON_TIP", "SEARCH_STOP_BUTTON_TIP"};
        ActionListener[] buttonListeners = new ActionListener[]{rp.DOWNLOAD_LISTENER, rp.BROWSE_HOST_LISTENER, rp.STOP_LISTENER};
        this.BUTTONS = new ButtonRow(buttonLabelKeys, buttonTipKeys, buttonListeners);
        JButton stop = this.BUTTONS.getButtonAtIndex(2);
        this.BUTTONS.remove(stop);
        BoxPanel stopPanel = new BoxPanel(0);
        stopPanel.setAlignmentX(1.0f);
        stopPanel.add(stop);
        this.BUTTONS.add(stopPanel);
    }

    ButtonRow getComponent() {
        return this.BUTTONS;
    }

    void transformWishlistButton() {
        this.transformButton(0, DOWNLOAD_BUTTON_LABEL, DOWNLOAD_BUTTON_TIP);
        this.BUTTONS.setButtonEnabled(0, false);
    }

    void transformDowloadButton() {
        this.transformButton(0, WISHLIST_BUTTON_LABEL, WISHLIST_BUTTON_TIP);
        this.BUTTONS.setButtonEnabled(0, true);
    }

    private void transformButton(int index, String label, String tip) {
        JButton button = this.BUTTONS.getButtonAtIndex(index);
        if (button != null) {
            button.setText(label);
            button.setToolTipText(tip);
        }
    }
}

