/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.ImageManipulator;
import com.limegroup.gnutella.gui.search.DitherPanel;
import com.limegroup.gnutella.gui.search.Ditherer;
import com.limegroup.gnutella.gui.search.NamedMediaType;
import com.limegroup.gnutella.settings.ThemeFileHandler;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;

final class SchemaBox
extends JPanel {
    private static final String SELECT_TYPE = GUIMediator.getStringResource("SEARCH_SELECT_TYPE");
    private static final String MEDIA = "NAMED_MEDIA_TYPE";
    private static final String SELECTED = "SELECTED_ICON";
    private static final String DESELECTED = "DESELECTED_ICON";
    private final JPanel SCHEMAS = new JPanel();
    private final ButtonGroup GROUP = new ButtonGroup();
    private final ItemListener HIGHLIGHTER = new Highlighter();
    private final MouseListener CLICK_FORWARDER = new Clicker();
    private final Ditherer DITHERER = new Ditherer(20, ThemeFileHandler.FILTER_TITLE_TOP_COLOR.getValue(), ThemeFileHandler.FILTER_TITLE_COLOR.getValue());

    SchemaBox() {
        List allSchemas = NamedMediaType.getAllNamedMediaTypes();
        int cols = 2;
        int rows = (int)Math.ceil((double)allSchemas.size() / 2.0);
        this.SCHEMAS.setBackground(ThemeFileHandler.SEARCH_GRID_COLOR.getValue());
        this.SCHEMAS.setLayout(new GridLayout(rows, cols, 1, 1));
        this.SCHEMAS.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.addSchemas(allSchemas);
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(new JLabel(SELECT_TYPE));
        this.add(panel);
        this.setLayout(new BoxLayout(this, 1));
        BoxPanel p = new BoxPanel(0);
        p.add(this.SCHEMAS);
        p.add(Box.createHorizontalStrut(1));
        this.add(p);
    }

    public void addSelectionListener(ActionListener listener) {
        Enumeration<AbstractButton> elements = this.GROUP.getElements();
        while (elements.hasMoreElements()) {
            AbstractButton button = elements.nextElement();
            button.addActionListener(listener);
        }
    }

    public Icon getSelectedIcon() {
        NamedMediaType nmt = this.getSelectedMedia();
        if (nmt == null) {
            return null;
        }
        return nmt.getIcon();
    }

    public LimeXMLSchema getSelectedSchema() {
        NamedMediaType nmt = this.getSelectedMedia();
        if (nmt == null) {
            return null;
        }
        return nmt.getSchema();
    }

    public String getSelectedItem() {
        NamedMediaType nmt = this.getSelectedMedia();
        if (nmt == null) {
            return null;
        }
        return nmt.getName();
    }

    public MediaType getSelectedMediaType() {
        NamedMediaType nmt = this.getSelectedMedia();
        if (nmt == null) {
            return null;
        }
        return nmt.getMediaType();
    }

    private void addSchemas(List schemas) {
        NamedMediaType current = NamedMediaType.getFromDescription("*");
        schemas.remove(current);
        this.addMediaType(current);
        current = NamedMediaType.getFromDescription("audio");
        schemas.remove(current);
        this.addMediaType(current);
        current = NamedMediaType.getFromDescription("image");
        schemas.remove(current);
        this.addMediaType(current);
        current = NamedMediaType.getFromDescription("video");
        schemas.remove(current);
        this.addMediaType(current);
        current = NamedMediaType.getFromDescription("text");
        schemas.remove(current);
        this.addMediaType(current);
        current = NamedMediaType.getFromDescription("application");
        schemas.remove(current);
        this.addMediaType(current);
        Iterator i = schemas.iterator();
        while (i.hasNext()) {
            this.addMediaType((NamedMediaType)i.next());
        }
    }

    private void addMediaType(NamedMediaType type) {
        Icon icon = type.getIcon();
        Icon disabledIcon = null;
        Icon rolloverIcon = null;
        JRadioButton button = new JRadioButton(type.getName());
        button.putClientProperty(MEDIA, type);
        button.putClientProperty(SELECTED, icon);
        if (icon != null) {
            disabledIcon = ImageManipulator.darken(icon);
            rolloverIcon = ImageManipulator.brighten(icon);
        }
        button.putClientProperty(DESELECTED, disabledIcon);
        button.setIcon(disabledIcon);
        button.setRolloverIcon(rolloverIcon);
        button.addItemListener(this.HIGHLIGHTER);
        button.setBorderPainted(false);
        button.setFocusPainted(false);
        button.setContentAreaFilled(false);
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setOpaque(false);
        button.addMouseListener(this.CLICK_FORWARDER);
        button.setPreferredSize(new Dimension(100, 22));
        this.GROUP.add(button);
        DitherPanel panel = new DitherPanel(this.DITHERER);
        panel.setDithering(false);
        panel.setLayout(new FlowLayout(0, 7, 1));
        panel.add(button);
        panel.addMouseListener(this.CLICK_FORWARDER);
        panel.setBackground(UIManager.getColor("TabbedPane.background"));
        this.SCHEMAS.add(panel);
        if (type.getMediaType() == MediaType.getAnyTypeMediaType()) {
            button.setSelected(true);
        } else {
            button.setSelected(false);
        }
    }

    private NamedMediaType getSelectedMedia() {
        Enumeration<AbstractButton> elements = this.GROUP.getElements();
        while (elements.hasMoreElements()) {
            AbstractButton button = elements.nextElement();
            if (!button.isSelected()) continue;
            return (NamedMediaType)button.getClientProperty(MEDIA);
        }
        return null;
    }

    private static void setIfNotNull(JComponent c, String col) {
        Color color = UIManager.getColor(col);
        if (color != null) {
            c.setBackground(color);
        }
    }

    private static class Clicker
    implements MouseListener {
        private Clicker() {
        }

        public void mouseEntered(MouseEvent e) {
            AbstractButton b;
            JComponent c = (JComponent)e.getSource();
            if (c instanceof AbstractButton) {
                b = (AbstractButton)c;
                c = (JComponent)c.getParent();
            } else {
                b = (AbstractButton)c.getComponent(0);
            }
            if (!b.isSelected()) {
                SchemaBox.setIfNotNull(c, "TabbedPane.selected");
            }
        }

        public void mouseExited(MouseEvent e) {
            AbstractButton b;
            JComponent c = (JComponent)e.getSource();
            if (c instanceof AbstractButton) {
                b = (AbstractButton)c;
                c = (JComponent)c.getParent();
            } else {
                b = (AbstractButton)c.getComponent(0);
            }
            if (!b.isSelected()) {
                SchemaBox.setIfNotNull(c, "TabbedPane.background");
            }
        }

        public void mouseClicked(MouseEvent e) {
            JComponent c = (JComponent)e.getSource();
            if (!(c instanceof AbstractButton)) {
                AbstractButton b = (AbstractButton)c.getComponent(0);
                b.doClick();
            }
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }
    }

    private static class Highlighter
    implements ItemListener {
        private Highlighter() {
        }

        public void itemStateChanged(ItemEvent e) {
            AbstractButton button = (AbstractButton)e.getSource();
            DitherPanel parent = (DitherPanel)button.getParent();
            if (e.getStateChange() == 1) {
                button.setIcon((Icon)button.getClientProperty(SchemaBox.SELECTED));
                parent.setDithering(true);
                parent.setBackground(ThemeFileHandler.FILTER_TITLE_COLOR.getValue());
            } else {
                button.setIcon((Icon)button.getClientProperty(SchemaBox.DESELECTED));
                parent.setDithering(false);
                parent.setBackground(UIManager.getColor("TabbedPane.background"));
            }
        }
    }
}

