/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.util.IpPort;
import com.limegroup.gnutella.util.NetworkUtils;
import com.sun.java.util.collections.Comparable;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Set;

class EndpointHolder
implements Comparable {
    private static final String MULTIPLE = GUIMediator.getStringResource("SEARCH_MULTIPLE_HOSTS");
    private final String _hostName;
    private final int _port;
    private boolean _isPrivate;
    private String _tag;
    private Set _hosts;

    EndpointHolder(String host, int port, boolean replyToMCast) {
        this._hostName = host;
        this._port = port;
        this._isPrivate = !replyToMCast && NetworkUtils.isPrivateAddress(host);
        this._tag = host;
    }

    void addHost(String host, int port) {
        if (this._hosts == null) {
            this._hosts = new HashSet();
            this._hosts.add(this._hostName + ":" + this._port);
        }
        this._hosts.add(host + ":" + port);
        this._tag = MULTIPLE + " (" + this._hosts.size() + ")";
        this._isPrivate = false;
    }

    void addHosts(Set alts) {
        if (this._hosts == null) {
            this._hosts = new HashSet();
            this._hosts.add(this._hostName + ":" + this._port);
        }
        Iterator i = alts.iterator();
        while (i.hasNext()) {
            IpPort next = (IpPort)i.next();
            this._hosts.add(next.getAddress() + ":" + next.getPort());
        }
        this._tag = MULTIPLE + " (" + this._hosts.size() + ")";
        this._isPrivate = false;
    }

    Set getHosts() {
        return this._hosts;
    }

    int numLocations() {
        return this._hosts == null ? 1 : this._hosts.size();
    }

    boolean isPrivateAddress() {
        return this._isPrivate;
    }

    public String toString() {
        return this._tag;
    }

    public int compareTo(Object o) {
        EndpointHolder other = (EndpointHolder)o;
        int n1 = this.numLocations();
        int n2 = other.numLocations();
        if (n1 == 1 && n2 == 1) {
            return this._tag.compareTo(other._tag);
        }
        return n1 - n2;
    }
}

