/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.search.AllowFilter;
import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.gui.search.TableLineFilter;

class CompositeFilter
implements TableLineFilter {
    private TableLineFilter[] delegates;

    CompositeFilter(int depth) {
        this.delegates = new TableLineFilter[depth];
        this.reset();
    }

    public void reset() {
        int i = 0;
        while (i < this.delegates.length) {
            this.delegates[i] = AllowFilter.instance();
            ++i;
        }
    }

    public boolean allow(TableLine line) {
        int i = 0;
        while (i < this.delegates.length) {
            if (!this.delegates[i].allow(line)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    boolean setFilter(int depth, TableLineFilter filter) {
        if (this.delegates[depth].equals(filter)) {
            return false;
        }
        this.delegates[depth] = filter;
        return true;
    }
}

