/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.ThemeObserver;
import java.awt.Component;
import java.awt.Graphics;
import java.util.MissingResourceException;
import javax.swing.Icon;

final class CancelSearchIconProxy
implements Icon,
ThemeObserver {
    private Icon _cancelIcon;
    private int _width;
    private int _height;
    private int _x;
    private int _y;
    private final boolean _selected;

    CancelSearchIconProxy(boolean sel) {
        this._selected = sel;
        this.updateTheme();
    }

    public void updateTheme() {
        if (!this._selected) {
            this._cancelIcon = GUIMediator.getThemeImage("kill.gif");
        } else {
            try {
                this._cancelIcon = GUIMediator.getThemeImage("kill_on.gif");
            }
            catch (MissingResourceException mre) {
                this._cancelIcon = GUIMediator.getThemeImage("kill.gif");
            }
        }
        this._width = this._cancelIcon.getIconWidth();
        this._height = this._cancelIcon.getIconHeight();
        this._x = 0;
        this._y = 0;
    }

    public int getIconWidth() {
        return this._width;
    }

    public int getIconHeight() {
        return this._height;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        this._x = x;
        this._y = y;
        this._cancelIcon.paintIcon(c, g, x, y);
    }

    boolean shouldKill(int x, int y) {
        int xMax = this._x + this._width;
        int yMax = this._y + this._height;
        if (x < this._x || x > xMax) {
            return false;
        }
        return y >= this._y && y <= yMax;
    }
}

