/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.FileChooserHandler;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.SizedTextField;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.QuestionsHandler;
import com.limegroup.gnutella.settings.ThemeSettings;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public final class ThemePaneItem
extends AbstractPaneItem {
    private final String OPTION_LABEL = "OPTIONS_THEME_BOX_LABEL";
    private JTextField _themeField = new SizedTextField();

    public ThemePaneItem(String key) {
        super(key);
        LabeledComponent comp = new LabeledComponent("OPTIONS_THEME_BOX_LABEL", this._themeField, 13);
        String[] labelKeys = new String[]{"GENERAL_BROWSE_BUTTON_LABEL", "GENERAL_DEFAULT_BUTTON_LABEL"};
        String[] toolTipKeys = new String[]{"OPTIONS_THEME_BROWSE_BUTTON_TIP", "OPTIONS_THEME_DEFAULT_BUTTON_TIP"};
        ActionListener[] listeners = new ActionListener[]{new SelectThemeFileListener(), new DefaultListener()};
        ButtonRow br = new ButtonRow(labelKeys, toolTipKeys, listeners, 0, 12);
        this.add(comp.getComponent());
        this.add(this.getVerticalSeparator());
        this.add(br);
    }

    public void initOptions() {
        this._themeField.setText(ThemeSettings.THEME_FILE.getValue().getAbsolutePath());
    }

    public boolean applyOptions() throws IOException {
        String theme = this._themeField.getText();
        File themeFile = new File(theme);
        if (!themeFile.isFile()) {
            GUIMediator.showError("ERROR_INVALID_THEME_FILE");
            throw new IOException("theme file is not a valid file");
        }
        if (!ThemeSettings.THEME_FILE.getValue().equals(themeFile)) {
            ThemeSettings.THEME_FILE.setValue(themeFile);
            GUIMediator.showMessage("THEME_CHANGED_MESSAGE", QuestionsHandler.THEME_CHANGED);
        }
        return false;
    }

    private static class ThemeFileFilter
    extends FileFilter {
        private ThemeFileFilter() {
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String name = f.getName();
            if (!name.endsWith("lwtp")) {
                return false;
            }
            if (!CommonUtils.isMacOSX() && name.equals("default_osx_theme.lwtp")) {
                return false;
            }
            return CommonUtils.isWindows() || !name.equals("windows_theme.lwtp");
        }

        public String getDescription() {
            return GUIMediator.getStringResource("THEME_FILE_DESCRIPTION");
        }
    }

    private class SelectThemeFileListener
    implements ActionListener {
        private SelectThemeFileListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                File file = null;
                String key = "OPTIONS_THEME_FILE_CHOOSER_TITLE";
                if (!CommonUtils.isMacOSX() || !ThemeSettings.isDefaultTheme()) {
                    file = FileChooserHandler.getInputFile((Component)AbstractPaneItem.MEDIATOR.getMainOptionsComponent(), key, new File(CommonUtils.getUserSettingsDir(), "themes"), new ThemeFileFilter());
                } else {
                    FileDialog dialog = new FileDialog((Frame)GUIMediator.getAppFrame(), GUIMediator.getStringResource(key), 0);
                    ((Component)dialog).setVisible(true);
                    String dirStr = dialog.getDirectory();
                    String fileStr = dialog.getFile();
                    if (dirStr == null || fileStr == null) {
                        return;
                    }
                    file = new File(dirStr, fileStr);
                }
                if (file == null) {
                    return;
                }
                if (!file.isFile()) {
                    return;
                }
                String newFile = file.getAbsolutePath();
                ThemePaneItem.this._themeField.setText(newFile);
            }
            catch (Throwable t) {
                ErrorService.error(t);
            }
        }
    }

    private class DefaultListener
    implements ActionListener {
        private DefaultListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                ThemePaneItem.this._themeField.setText(ThemeSettings.THEME_DEFAULT.getValue().getAbsolutePath());
            }
            catch (Throwable t) {
                ErrorService.error(t);
            }
        }
    }
}

