/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.gui.FileChooserHandler;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.StandardListEditor;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.FileUtils;
import com.limegroup.gnutella.util.ManagedThread;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;

public final class SharedDirPaneItem
extends AbstractPaneItem {
    private final StandardListEditor DIR_LIST = new StandardListEditor(new SelectSharedDirectoryListener());
    private boolean _directoryAdded = false;

    public SharedDirPaneItem(String key) {
        super(key);
        this.add(this.DIR_LIST.getComponent());
    }

    private void addDirectory(File dir) {
        if (!dir.isDirectory()) {
            return;
        }
        File[] dirs = this.DIR_LIST.getDataAsFileArray();
        int i = 0;
        while (i < dirs.length) {
            if (dirs[i].equals(dir)) {
                return;
            }
            ++i;
        }
        this.DIR_LIST.addFile(dir);
        this._directoryAdded = true;
    }

    private void handleSaveDirectory() {
        if (!AbstractPaneItem.MEDIATOR.getSaveDirectoryChanged()) {
            return;
        }
        File saveDir = SharingSettings.getSaveDirectory();
        if (saveDir != null && saveDir.exists() && saveDir.isDirectory() && FileUtils.setWriteable(saveDir)) {
            this.addDirectory(saveDir);
        }
    }

    public void initOptions() {
        File[] dirs = SharingSettings.DIRECTORIES_TO_SHARE.getValue();
        this.DIR_LIST.setListData(dirs);
        this.DIR_LIST.resetList();
        this._directoryAdded = false;
    }

    public boolean applyOptions() throws IOException {
        this.handleSaveDirectory();
        if (this.DIR_LIST.getListChanged() || this._directoryAdded) {
            this.DIR_LIST.resetList();
            this._directoryAdded = false;
            SharingSettings.DIRECTORIES_TO_SHARE.setValue(this.DIR_LIST.getDataAsFileArray());
            ManagedThread loadFileManagerSettings = new ManagedThread("DirectoriesChangedReloader"){

                public void managedRun() {
                    RouterService.getFileManager().loadSettings(true);
                }
            };
            loadFileManagerSettings.setDaemon(true);
            loadFileManagerSettings.start();
        }
        return false;
    }

    private class SelectSharedDirectoryListener
    implements ActionListener {
        private SelectSharedDirectoryListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            try {
                File dir = FileChooserHandler.getInputDirectory(AbstractPaneItem.MEDIATOR.getMainOptionsComponent());
                if (dir == null) {
                    return;
                }
                if (!dir.isDirectory() || !dir.canRead()) {
                    GUIMediator.showError("ERROR_INVALID_SHARED_DIRECTORY");
                    return;
                }
                SharedDirPaneItem.this.addDirectory(dir);
            }
            catch (Throwable e) {
                GUIMediator.showInternalError(e, "ChangeSharedDir");
            }
        }
    }
}

