/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.filters.IP;
import com.limegroup.gnutella.gui.ListEditor;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.FilterSettings;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.Vector;
import java.awt.Toolkit;
import java.io.IOException;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public final class IgnoreMessagesPaneItem
extends AbstractPaneItem {
    private final ListEditor MESSAGES_LIST = new ListEditor();

    public IgnoreMessagesPaneItem(String key) {
        super(key);
        this.add(this.MESSAGES_LIST);
        this.MESSAGES_LIST.addListDataListener(new IPEnforcer());
    }

    public void initOptions() {
        Object[] bannedIps = FilterSettings.BLACK_LISTED_IP_ADDRESSES.getValue();
        this.MESSAGES_LIST.setModel(new Vector(Arrays.asList(bannedIps)));
    }

    public boolean applyOptions() throws IOException {
        Vector model = this.MESSAGES_LIST.getModel();
        Object[] bannedIps = new String[model.size()];
        model.copyInto(bannedIps);
        FilterSettings.BLACK_LISTED_IP_ADDRESSES.setValue((String[])bannedIps);
        RouterService.adjustSpamFilters();
        return false;
    }

    private class IPEnforcer
    implements ListDataListener {
        private IPEnforcer() {
        }

        public void intervalAdded(ListDataEvent lde) {
            Vector model = (Vector)lde.getSource();
            String ipString = (String)model.get(lde.getIndex0());
            try {
                new IP(ipString);
            }
            catch (IllegalArgumentException e) {
                IgnoreMessagesPaneItem.this.MESSAGES_LIST.removeItem(lde.getIndex0());
                Toolkit.getDefaultToolkit().beep();
            }
        }

        public void intervalRemoved(ListDataEvent lde) {
        }

        public void contentsChanged(ListDataEvent lde) {
            Vector model = (Vector)lde.getSource();
            String ipString = (String)model.get(lde.getIndex0());
            try {
                new IP(ipString);
            }
            catch (IllegalArgumentException e) {
                Object[] bannedIps = FilterSettings.BLACK_LISTED_IP_ADDRESSES.getValue();
                IgnoreMessagesPaneItem.this.MESSAGES_LIST.setModel(new Vector(Arrays.asList(bannedIps)));
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }
}

