/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.SizedWholeNumberField;
import com.limegroup.gnutella.gui.WholeNumberField;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.util.NetworkUtils;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.JCheckBox;

public final class ForceIPPaneItem
extends AbstractPaneItem {
    private final String CHECK_BOX_LABEL_KEY = "OPTIONS_FORCE_IP_CHECK_BOX_LABEL";
    private final String PORT_LABEL_KEY = "OPTIONS_FORCE_IP_PORT_LABEL";
    private final JCheckBox CHECK_BOX = new JCheckBox();
    private final WholeNumberField PORT_FIELD = new SizedWholeNumberField();
    private volatile int _forcedPort;
    private volatile boolean _forceLocalIP;

    public ForceIPPaneItem(String key) {
        super(key);
        this.CHECK_BOX.addItemListener(new LocalIPBoxListener());
        LabeledComponent comp0 = new LabeledComponent("OPTIONS_FORCE_IP_CHECK_BOX_LABEL", this.CHECK_BOX, 130);
        LabeledComponent comp1 = new LabeledComponent("OPTIONS_FORCE_IP_PORT_LABEL", this.PORT_FIELD);
        BoxPanel bp0 = new BoxPanel(0);
        bp0.add(comp0.getComponent());
        bp0.add(Box.createHorizontalGlue());
        BoxPanel bp1 = new BoxPanel(0);
        bp1.add(comp1.getComponent());
        this.add(comp0.getComponent());
        this.add(this.getVerticalSeparator());
        this.add(bp1);
    }

    public void initOptions() {
        this._forcedPort = ConnectionSettings.FORCED_PORT.getValue();
        this._forceLocalIP = ConnectionSettings.FORCE_IP_ADDRESS.getValue();
        this.PORT_FIELD.setValue(this._forcedPort);
        this.CHECK_BOX.setSelected(this._forceLocalIP);
    }

    public boolean applyOptions() throws IOException {
        this.handleForcedIP();
        return false;
    }

    private void handleForcedIP() throws IOException {
        ConnectionSettings.FORCE_IP_ADDRESS.setValue(this.CHECK_BOX.isSelected());
        int forcedPort = this.PORT_FIELD.getValue();
        if (!NetworkUtils.isValidPort(forcedPort)) {
            this.PORT_FIELD.setValue(this._forcedPort);
            if (this.CHECK_BOX.isSelected()) {
                GUIMediator.showError("ERROR_FORCE_IP_PORT_RANGE");
                ConnectionSettings.FORCE_IP_ADDRESS.setValue(false);
                throw new IOException("bad port: " + forcedPort);
            }
        } else {
            ConnectionSettings.FORCED_PORT.setValue(forcedPort);
        }
        int storedPort = ConnectionSettings.FORCED_PORT.getValue();
        if (this._forceLocalIP != this.CHECK_BOX.isSelected() || this._forcedPort != storedPort) {
            RouterService.addressChanged();
        }
        this._forcedPort = storedPort;
        this._forceLocalIP = this.CHECK_BOX.isSelected();
    }

    private class LocalIPBoxListener
    implements ItemListener {
        private LocalIPBoxListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            ForceIPPaneItem.this.PORT_FIELD.setEditable(ForceIPPaneItem.this.CHECK_BOX.isSelected());
        }
    }
}

