/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.mp3;

import com.limegroup.gnutella.gui.FinalizeListener;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.mp3.AbstractAudioPlayer;
import java.io.File;
import java.io.IOException;
import quicktime.QTException;
import quicktime.QTSession;
import quicktime.app.QTFactory;
import quicktime.app.players.QTPlayer;
import quicktime.std.StdQTException;

final class QuickTimeAudioPlayer
extends AbstractAudioPlayer
implements FinalizeListener {
    private static QTPlayer _player;
    private int _status = 2;
    private File _curFile = new File(System.getProperty("user.dir"));

    QuickTimeAudioPlayer() {
        try {
            QTSession.open();
            GUIMediator.addFinalizeListener(this);
        }
        catch (QTException e) {
            GUIMediator.showInternalError(e);
        }
    }

    public int getStatus() {
        return this._status;
    }

    public void unpause() {
        if (_player == null) {
            return;
        }
        try {
            _player.getMovieController().play(1.0f);
            this._status = 0;
        }
        catch (StdQTException stdQTException) {
            // empty catch block
        }
    }

    public void pause() {
        if (_player == null) {
            return;
        }
        try {
            _player.getMovieController().play(0.0f);
            if (this._status != 2) {
                this._status = 1;
            }
        }
        catch (StdQTException stdQTException) {
            // empty catch block
        }
    }

    public void stop() {
        if (_player == null) {
            return;
        }
        try {
            _player.getMovieController().play(0.0f);
            _player.setTime(0);
            this._status = 2;
        }
        catch (StdQTException stdQTException) {
            // empty catch block
        }
    }

    public void play(File file) throws IOException {
        String soundLocation = file.getCanonicalPath();
        if (!this._curFile.equals(file)) {
            try {
                _player = (QTPlayer)QTFactory.makeDrawable((String)("file://" + soundLocation));
                _player.setControllerVisible(false);
            }
            catch (QTException qte) {
                return;
            }
            _player.startTasking();
        }
        try {
            _player.setRate(1.0f);
        }
        catch (StdQTException sqte) {
            return;
        }
        int frames = 0;
        try {
            frames = _player.getDuration();
        }
        catch (QTException e) {
            return;
        }
        this.fireSeekSetupRequired(frames);
        this.fireAudioPositionUpdated(0);
        this._status = 0;
        this._curFile = file;
    }

    public int getFrameSeek() {
        return 0;
    }

    public void doFinalize() {
        try {
            QTSession.close();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void refresh() {
        if (_player == null) {
            return;
        }
        if (this._status == 2) {
            return;
        }
        int framesRead = 0;
        int duration = 0;
        try {
            framesRead = _player.getTime();
            duration = _player.getDuration();
        }
        catch (StdQTException e) {
            return;
        }
        if (framesRead == duration) {
            if (this._status != 2) {
                this._status = 2;
            }
            this.firePlayComplete();
        } else {
            this.fireAudioPositionUpdated(framesRead);
        }
    }
}

